--materials
minetest.register_craftitem("wallygoo2:wallgoo_goo", {
description = "Wallgoo",
inventory_image = "wallgoo_goo.png",
})
minetest.register_craftitem("wallygoo2:floorgoo_goo", {
description = "Floorgoo",
inventory_image = "floorgoo_goo.png",
})
minetest.register_craftitem("wallygoo2:ceilinggoo_goo", {
description = "Ceilinggoo",
inventory_image = "ceilinggoo_goo.png",
})
minetest.register_craftitem("wallygoo2:wallgoo_brick_chunk", {
description = "Wallgoo brick chunk",
inventory_image = "wallgoo_brick_chunk.png",
})
minetest.register_craftitem("wallygoo2:ceilinggoo_brick_chunk", {
description = "Ceilinggoo brick chunk",
inventory_image = "ceilinggoo_brick_chunk.png",
})
minetest.register_craftitem("wallygoo2:floorgoo_brick_chunk", {
description = "Floorgoo brick chunk",
inventory_image = "floorgoo_brick_chunk.png",
})
minetest.register_craftitem("wallygoo2:wallgoo_stick", {
description = "Wallgoo stick",
inventory_image = "wallgoo_stick.png",
})
minetest.register_craftitem("wallygoo2:monument_research_template",{
description = "Monument research template",
inventory_image = "wallgoo_research_template.png",
})
minetest.register_craftitem("wallygoo2:weapon_research_template",{
description = "Weapon research template",
inventory_image = "wallgoo_research_template.png",
})
minetest.register_craftitem("wallygoo2:portal_fragment", {
description = "Portal fragment",
inventory_image = "portal_fragment.png",
})
minetest.register_craftitem("wallygoo2:portal_chunk", {
description = "Portal chunk",
inventory_image = "portal_chunk.png",
})
--nature nodes
minetest.register_node("wallygoo2:wallgoo_splat", {
description = "Wallgoo splat",
drawtype = "plantlike",
tiles = {"wallgoo_splat.png"},
inventory_image = "wallgoo_splat.png",
paramtype = "light",
sunlight_propagates = true,
walkable = false,
buildable_to = true,
groups = {oddly_breakable_by_hand=3, flammable=2, plant=1},
drop = "wallygoo2:wallgoo_goo",
})
minetest.register_node("wallygoo2:floorgoo_splat", {
description = "Floorgoo splat",
drawtype = "plantlike",
tiles = {"floorgoo_splat.png"},
inventory_image = "floorgoo_splat.png",
paramtype = "light",
sunlight_propagates = true,
walkable = false,
buildable_to = true,
groups = {oddly_breakable_by_hand=3, flammable=2, plant=1},
drop = "wallygoo2:floorgoo_goo",
})
minetest.register_node("wallygoo2:ceilinggoo_splat", {
description = "Ceilinggoo splat",
drawtype = "plantlike",
tiles = {"ceilinggoo_splat.png"},
inventory_image = "ceilinggoo_splat.png",
paramtype = "light",
paramtype2 = "wallmounted",
sunlight_propagates = true,
walkable = false,
buildable_to = true,
groups = {oddly_breakable_by_hand=3, flammable=2, plant=1},
drop = "wallygoo2:ceilinggoo_goo",
})
minetest.register_node("wallygoo2:wallgoo_sapling", {
description = "Wallgoo sapling",
tiles = {"wallgoo_sapling.png"},
drawtype = "plantlike",
inventory_image = "wallgoo_sapling.png",
paramtype = "light",
sunlight_propagates = true,
walkable = false,
buildable_to = true,
groups = {oddly_breakable_by_hand=3, dig_immediate=3, flammable=2, attached_node=1, sapling=1},
sounds = default.node_sound_leaves_defaults(),

on_construct = function(pos)
minetest.get_node_timer(pos):start(math.random(30, 300))
end,

on_timer = function(pos)
minetest.remove_node(pos)
minetest.place_schematic(
pos,
minetest.get_modpath("wallygoo2").."/schematics/goo_tree.mts",
"random",
nil,
true
)

return false
end,
})
minetest.register_node("wallygoo2:tree_trunk", {
description = "Wallgoo tree trunk",
tiles = {
"wallgoo_tree_top.png",
"wallgoo_tree_top.png",
"wallgoo_tree_trunk.png",
"wallgoo_tree_trunk.png",
"wallgoo_tree_trunk.png",
"wallgoo_tree_trunk.png"},
paramtype2 = "facedir",
is_ground_content = false,
groups = {tree=1, choppy=2, oddly_breakable_by_hand=1,flammable=2},
sounds = default.node_sound_wood_defaults(),
 })
 minetest.register_node("wallygoo2:wallgoo_leaves", {
 description = "Wallgoo Leaves",
 drawtype = "allfaces_optional",
 waving = 1,
 tiles = {"wallgoo_leaves.png"},
 paramtype = "light",
 sunlight_propagates = true,
 groups = {snappy=3, leafdecay=3, flammable=2, leaves=1},
 drop = {
 max_items = 1,
 items = {
 {items = {"wallygoo2:wallgoo_sapling"}, rarity = 25},
 {items = {"wallygoo2:wallgoo_goo"}, rarity =5},
 	}
 },
 sounds = default.node_sound_leaves_defaults(),
 })
 --tools
 minetest.register_tool("wallygoo2:wallgoo_pickaxe", {
 description = "Wallgoo pickaxe",
 inventory_image = "wallgoo_pickaxe.png",
 tool_capabilities ={
 full_punch_interval = 1.0,
 max_drop_level = 1,
 groupcaps = { 
 cracky= {times={[2]=1.5, [3]=0.75}, uses=30, maxlevel=2}
 },
 damage_groups = {fleshy=2},
 },
 })
minetest.register_tool("wallygoo2:wallgoo_axe", {
    description = "Wallgoo axe",
    inventory_image = "wallgoo_axe.png",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 1,
        groupcaps = { 
            choppy = {
                times = {[2]=1.5, [3]=0.75},
                uses = 30,
                maxlevel = 2
            }
        },
        damage_groups = {fleshy=3},
    },
})
minetest.register_tool("wallygoo2:wallgoo_shovel", {
    description = "Wallgoo shovel",
    inventory_image = "wallgoo_shovel.png",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 1,
        groupcaps = { 
            crumbly = {
                times = {[2]=1.5, [3]=0.75},
                uses = 30,
                maxlevel = 2
            }
        },
        damage_groups = {fleshy=3},
    },
})minetest.register_tool("wallygoo2:wallgoo_sword", {
    description = "Wallgoo sword",
    inventory_image = "wallgoo_sword.png",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 1,
        groupcaps = { 
            snappy = {
                times = {[2]=1.5, [3]=0.75},
                uses = 30,
                maxlevel = 2
            }
        },
        damage_groups = {fleshy=7},
    },
})
 minetest.register_tool("wallygoo2:ceilinggoo_sledgehammer", {
 description = "Ceilinggoo sledgehammer (high durability, low mining speed)",
 inventory_image = "ceilinggoo_sledgehammer.png",
 tool_capabilities = {
 full_punch_interval = 28.0,
 max_drop_level = 3,
 groupcaps ={
 cracky = {
 times = {[1]=82.0, [2]=48.0, [3]=32.0},
 uses = 153,
 maxlevel =3
 }
 },
 damage_groups = {fleshy=24},
 },
 })
 minetest.register_tool("wallygoo2:floorgoo_battle_axe", {
 description = "Floorgoo battle axe (high damage, slow recharge and breaking speed)",
 inventory_image = "floorgoo_battle_axe.png",
 tool_capabilities = {
        full_punch_interval = 28.0,
        max_drop_level = 1,
        groupcaps = { 
            snappy = {
                times = {[3]=82.0,[2]=48.0, [3]=32.0},
                uses = 35,
                maxlevel = 3
            }
        },
        damage_groups = {fleshy=50},
    },
})
 
--node blocks
minetest.register_node("wallygoo2:wallgoo_bricks", {
description = "Wallgoo bricks",
tiles ={"wallgoo_bricks.png"},
is_ground_content = false,
groups = {cracky=3, stone=1},
sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("wallygoo2:ceilinggoo_bricks", {
description = "Ceilinggoo bricks",
tiles ={"ceilinggoo_bricks.png"},
is_ground_content = false,
groups = {cracky=3, stone=1},
sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("wallygoo2:floorgoo_bricks", {
description = "Floorgoo bricks",
tiles ={"floorgoo_brick.png"},
is_ground_content = false,
groups = {cracky=3, stone=1},
sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("wallygoo2:wallgoo_planks", {
description = "Wallgoo wood planks",
tiles ={"wallgoo_planks.png"},
is_ground_content = false,
groups = {choppy=3,flammable=2},
sounds = default.node_sound_wood_defaults(),
})
minetest.register_node("wallygoo2:wallgoo_glass", {
description = "Wallgoo glass",
drawtype = "glasslike",
tiles = {"wallgoo_glass.png"}, 
paramtype = "light",
sunlight_propagates = true,
use_texture_alpha = "blend",
groups = {cracky=3, oddly_breakable_by_hand=3},
sounds = default.node_sound_glass_defaults(),
drop ="wallygoo2:wallgoo_goo",
})
minetest.register_node("wallygoo2:wallgoo_glow", {
description = "Wallgoo_glow",
tiles = {"wallgoo_glow.png"},
paramtype = "light",
light_source = 14,
groups = {cracky=2},
sounds = default.node_sound_glass_defaults(),
drop = "wallygoo2:wallgoo_goo",
})
minetest.register_node("wallygoo2:wallgoo_monument", {
description = "Wallgoo monument",
tiles ={"wallgoo_shrine_top.png",
"wallgoo_shrine_bottom.png",
"wallgoo_shrine_side.png",
"wallgoo_shrine_side.png",
"wallgoo_shrine_side.png",
"wallgoo_shrine_side.png"},
is_ground_content = false,
groups = {cracky=3},
sounds = default.node_sound_stone_defaults(),
})

-- Define research recipes (map input item -> output template)
local research_recipes = {
    ["wallygoo2:wallgoo_monument"] = "wallygoo2:monument_research_template",
    ["wallygoo2:ceilinggoo_sledgehammer"] =
    "wallygoo2:weapon_research_template",
   
}

-- Register the research table node
minetest.register_node("wallygoo2:research_table", {
    description = "Wallgoo Research Table",
    tiles = {
        "wallgoo_research_top.png",
        "wallgoo_research_top.png",
        "wallgoo_research_side.png",
        "wallgoo_research_side.png",
        "wallgoo_research_side.png",
        "wallgoo_research_side.png",
    },
    groups = {cracky = 1},
    sounds = default.node_sound_metal_defaults(),

    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("input", 1)
        inv:set_size("output", 1)
        meta:set_string("infotext", "Wallgoo Research Table")
    end,

    on_rightclick = function(pos, node, clicker)
        local pname = clicker:get_player_name()
        minetest.show_formspec(pname,
            "wallygoo2:research_table_" .. minetest.pos_to_string(pos),
            table.concat({
                "formspec_version[4]",
                "size[10,9]",
                "label[0.5,0.5;Insert an item to research]",
                "list[nodemeta:", pos.x, ",", pos.y, ",", pos.z, ";input;3,1;1,1;]",
                "list[nodemeta:", pos.x, ",", pos.y, ",", pos.z, ";output;5,1;1,1;]",
                "button[3,2;4,1;do_research;Research]", -- match handler
                "list[current_player;main;0,3.5;8,4;]",
                "listring[nodemeta:", pos.x, ",", pos.y, ",", pos.z, ";input]",
                "listring[nodemeta:", pos.x, ",", pos.y, ",", pos.z, ";output]",
                "listring[current_player;main]",
            })
        )
    end,
})

-- Handle form submission
minetest.register_on_player_receive_fields(function(player, formname, fields)
    if not player or not player:is_player() then return end
    if not formname:find("wallygoo2:research_table_") then return end
    if not fields.do_research then return end

    local pname = player:get_player_name()
    local pos_str = formname:match("wallygoo2:research_table_(.+)")
    local pos = pos_str and minetest.string_to_pos(pos_str)
    if not pos then return end

    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    local stack = inv:get_stack("input", 1)

    if stack:is_empty() then
        minetest.chat_send_player(pname, "Insert an item first!")
        return
    end

    local item_name = stack:get_name()
    local output_name = research_recipes[item_name]

    if not output_name then
        minetest.chat_send_player(pname, "This item cannot be researched.")
        return
    end

    if inv:room_for_item("output", output_name) then
        inv:add_item("output", output_name)
        stack:take_item(1)
        inv:set_stack("input", 1, stack)
        minetest.chat_send_player(pname, "You researched: " .. item_name)
        minetest.sound_play("wallygoo2_research", {pos = pos, gain = 1.0})
    else
        minetest.chat_send_player(pname, "Output slot is full!")
    end
end)
minetest.register_node("wallygoo2:portal_quadrant", {
description = "Wallgoo quadrant",
tiles ={"wallgoo_quadrant.png"},
is_ground_content = false,
groups = {cracky=3, stone=1},
sounds = default.node_sound_stone_defaults(),
})
local storage = minetest.get_mod_storage()
local portals = {}

-- Load portals when the mod starts
local data = storage:get_string("portals")
if data ~= "" then
    portals = minetest.deserialize(data) or {}
end

-- Save portals
local function save_portals()
    storage:set_string("portals", minetest.serialize(portals))
end

minetest.register_node("wallygoo2:portal", {
    description = "Wallgoo Portal (requires 2 portals)",
    drawtype = "glasslike",
    tiles = {"portal.png"},
    paramtype = "light",
    sunlight_propagates = true,
    light_source = 14,
    walkable = false,
    pointable = true,
    diggable = true,
    groups = {oddly_breakable_by_hand=3},

    on_construct = function(pos)
        table.insert(portals, vector.new(pos))
        save_portals()
    end,

    on_destruct = function(pos)
        for i,p in ipairs(portals) do
            if vector.equals(p, pos) then
                table.remove(portals, i)
                break
            end
        end
        save_portals()
    end,

    on_rightclick = function(pos, node, clicker)
        if not clicker or not clicker:is_player() then return end
        if #portals <= 1 then
            minetest.chat_send_player(clicker:get_player_name(),
                "second waypoint not detected please place another portal to teleport")
            return
        end

        local dest
        repeat
            dest = portals[math.random(#portals)]
        until not vector.equals(dest, pos)

        clicker:set_pos({x=dest.x, y=dest.y+1, z=dest.z})
        minetest.chat_send_player(clicker:get_player_name(),
            "you are pulled to another portal!")
    end,
})


--crafting
minetest.register_craft({
    output = "wallygoo2:research_table",
    recipe = {
        {"wallygoo2:ceilinggoo_goo", "wallygoo2:floorgoo_goo", "wallygoo2:ceilinggoo_goo"},
        {"wallygoo2:wallgoo_bricks", "wallygoo2:wallgoo_bricks", "wallygoo2:wallgoo_bricks"},
    }
})
minetest.register_craft({
output = "wallygoo2:wallgoo_brick_chunk",
recipe = {
{"wallygoo2:wallgoo_goo", "wallygoo2:wallgoo_goo"},
{"wallygoo2:wallgoo_goo", "wallygoo2:wallgoo_goo"},
}
})
minetest.register_craft({
output = "wallygoo2:ceilinggoo_brick_chunk",
recipe = {
{"wallygoo2:ceilinggoo_goo", "wallygoo2:ceilinggoo_goo"},
{"wallygoo2:ceilinggoo_goo", "wallygoo2:ceilinggoo_goo"},
}
})
minetest.register_craft({
output = "wallygoo2:floorgoo_brick_chunk",
recipe = {
{"wallygoo2:floorgoo_goo", "wallygoo2:floorgoo_goo"},
{"wallygoo2:floorgoo_goo", "wallygoo2:floorgoo_goo"},
}
})
minetest.register_craft({
output = "wallygoo2:wallgoo_bricks",
recipe = {
{"wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk"},
{"wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk"},
{"wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk"},
}
})
minetest.register_craft({
output = "wallygoo2:ceilinggoo_bricks",
recipe = {
{"wallygoo2:ceilinggoo_brick_chunk","wallygoo2:ceilinggoo_brick_chunk","wallygoo2:ceilinggoo_brick_chunk"},
{"wallygoo2:ceilinggoo_brick_chunk","wallygoo2:ceilinggoo_brick_chunk","wallygoo2:ceilinggoo_brick_chunk"},
{"wallygoo2:ceilinggoo_brick_chunk","wallygoo2:ceilinggoo_brick_chunk","wallygoo2:ceilinggoo_brick_chunk"},
}
})
minetest.register_craft({
output = "wallygoo2:floorgoo_bricks",
recipe = {
{"wallygoo2:floorgoo_brick_chunk","wallygoo2:floorgoo_brick_chunk","wallygoo2:floorgoo_brick_chunk"},
{"wallygoo2:floorgoo_brick_chunk","wallygoo2:floorgoo_brick_chunk","wallygoo2:floorgoo_brick_chunk"},
{"wallygoo2:floorgoo_brick_chunk","wallygoo2:floorgoo_brick_chunk","wallygoo2:floorgoo_brick_chunk"},
}
})

minetest.register_craft({
type ="shapeless",
output = "wallygoo2:wallgoo_sapling",
recipe ={"wallygoo2:wallgoo_goo","default:sapling"}
})
minetest.register_craft({
output = "wallygoo2:wallgoo_planks 2",
recipe = {
{"wallygoo2:tree_trunk"},
}
})
minetest.register_craft({
output = "wallygoo2:wallgoo_stick 4",
recipe = {
{"wallygoo2:wallgoo_planks"},
}
})
minetest.register_craft({
output = "wallygoo2:wallgoo_pickaxe",
recipe={
{"wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk"},
{"","wallygoo2:wallgoo_stick",""},
{"","wallygoo2:wallgoo_stick",""},
}
})
minetest.register_craft({
output = "wallygoo2:wallgoo_axe",
recipe = {
{"wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk",""},
{"wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_stick",""},
{"","wallygoo2:wallgoo_stick",""},
}
})
minetest.register_craft({
output = "wallygoo2:wallgoo_shovel",
recipe ={
{"","wallygoo2:wallgoo_brick_chunk",""},
{"","wallygoo2:wallgoo_stick",""},
{"","wallygoo2:wallgoo_stick",""},
}
})
minetest.register_craft({
output = "wallygoo2:wallgoo_sword",
recipe ={
{"","wallygoo2:wallgoo_brick_chunk",""},
{"","wallygoo2:wallgoo_brick_chunk",""},
{"","wallygoo2:wallgoo_stick",""},

}
})
minetest.register_craft({
output = "wallygoo2:ceilinggoo_sledgehammer",
recipe ={
{"wallygoo2:ceilinggoo_brick_chunk","wallygoo2:ceilinggoo_bricks","wallygoo2:ceilinggoo_brick_chunk"},
{"","wallygoo2:wallgoo_stick",""},
{"","wallygoo2:wallgoo_stick",""},
}
})
minetest.register_craft({
output = "wallygoo2:floorgoo_battle_axe",
recipe ={
{"wallygoo2:floorgoo_bricks","wallygoo2:floorgoo_brick_chunk","wallygoo2:floorgoo_bricks"},
{"","wallygoo2:weapon_research_template",""},
{"","wallygoo2:wallgoo_stick",""},
}
})
minetest.register_craft({
output = "wallygoo2:wallgoo_glass",
type = "shapeless",
recipe = {"wallygoo2:wallgoo_goo","default:glass","wallygoo2:wallgoo_goo"},
})
minetest.register_craft({
output = "wallygoo2:wallgoo_glow",
type = "shapeless",
recipe = {"wallygoo2:wallgoo_goo","default:torch","wallygoo2:wallgoo_goo"},
})
minetest.register_craft({
output ="wallygoo2:wallgoo_sandwich",
recipe = {
{"farming:bread"},
{"wallygoo2:wallgoo_goo"},
{"farming:bread"},
}
})
minetest.register_craft({
output ="wallygoo2:ceilinggoo_popsicle",
recipe = {
{"wallygoo2:ceilinggoo_goo"},
{"default:stick"},
}
})
minetest.register_craft({
output ="wallygoo2:floorgoo_smoothie",
recipe = {
{"wallygoo2:floorgoo_goo"},
{"wallygoo2:floorgoo_goo"},
{"wallygoo2:floorgoo_goo"},
}
})
minetest.register_craft({
output = "wallygoo2:portal_fragment",
type = "shapeless",
recipe = {"wallygoo2:wallgoo_goo","wallygoo2:wallgoo_brick_chunk","wallygoo2:monument_research_template"}
})
minetest.register_craft({
output = "wallygoo2:portal_chunk",
recipe = {
{"wallygoo2:portal_fragment","wallygoo2:portal_fragment","wallygoo2:portal_fragment"},
{"wallygoo2:portal_fragment","wallygoo2:portal_fragment","wallygoo2:portal_fragment"},
{"wallygoo2:portal_fragment","wallygoo2:portal_fragment","wallygoo2:portal_fragment"},
}
})
minetest.register_craft({
output = "wallygoo2:portal_quadrant",
recipe = {
{"wallygoo2:portal_chunk", "", "wallygoo2:portal_chunk"},
{"","",""},
{"wallygoo2:portal_chunk", "", "wallygoo2:portal_chunk"},
}
})
minetest.register_craft({
output = "wallygoo2:portal 2",
recipe = {
{"wallygoo2:portal_quadrant","wallygoo2:portal_quadrant","wallygoo2:portal_quadrant"},
{"wallygoo2:portal_quadrant","wallygoo2:floorgoo_goo","wallygoo2:portal_quadrant"},
{"wallygoo2:portal_quadrant","wallygoo2:portal_quadrant","wallygoo2:portal_quadrant"},
}
})
minetest.register_craft({
output = "wallygoo2:wallgoo_monument",
recipe ={
{"wallygoo2:wallgoo_stick","wallygoo2:wallgoo_goo","wallygoo2:wallgoo_stick"},
{"wallygoo2:wallgoo_stick","wallygoo2:wallgoo_goo","wallygoo2:wallgoo_stick"},
{"wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk","wallygoo2:wallgoo_brick_chunk"},
}
})

--structures
minetest.register_on_generated(function(minp, maxp, seed)
    -- roll chance: 1 in 800 chunks
    if math.random(1,50) == 1 then
        -- pick a position near the center of this chunk
        local pos = {
            x = minp.x + 8,
            y = minp.y + 1, -- ground level adjustment
            z = minp.z + 8
        }
        
        minetest.place_schematic(
            pos,
            minetest.get_modpath("wallygoo2").."/schematics/tower_name.mts",
            "random", 
            nil,      
            true      
        )
    end
end)

minetest.register_on_generated(function(minp, maxp, seed)
    
    if math.random(1,50) == 1 then
        local pos = {
            x = minp.x + 8,
            y = minp.y + 1,
            z = minp.z + 8
        }
        minetest.place_schematic(
            pos,
            minetest.get_modpath("wallygoo2").."/schematics/wallgooshrine.mts",
            "random",
            nil,
            true
        )
    end
end)
--spawning
minetest.register_decoration({
deco_type = "simple",
place_on = {"default:dirt_with_grass"},
sidelen=16,
fill_ratio = 0.02,
decoration ="wallygoo2:wallgoo_splat",
})
minetest.register_decoration({
deco_type = "simple",
place_on = {"default:dirt_with_grass"},
sidelen=16,
fill_ratio = 0.02,
decoration ="wallygoo2:ceilinggoo_splat",
})
minetest.register_decoration({
deco_type = "simple",
place_on = {"default:dirt_with_grass"},
sidelen=16,
fill_ratio = 0.02,
decoration ="wallygoo2:floorgoo_splat",
})
--foods
minetest.register_craftitem("wallygoo2:wallgoo_sandwich", {
description = "Wallgoo sandwich",
inventory_image = "wallgoo_sandwich.png",
on_use = minetest.item_eat(6),
})
minetest.register_craftitem("wallygoo2:ceilinggoo_popsicle", {
description = "Ceilinggoo popsicle",
inventory_image = "ceilinggoo_popsicle.png",
on_use = minetest.item_eat(4),
})
minetest.register_craftitem("wallygoo2:floorgoo_smoothie", {
description = "Floorgoo smoothie",
inventory_image = "floorgoo_smoothie.png",
on_use = minetest.item_eat(10),
})
