local S = minetest.get_translator("titou_nicknames")

minetest.register_privilege("nicknames_hide", {
    description = S("this permission is used to hide nicknames on head of players.")
})

minetest.register_privilege("nicknames_show", {
    description = S("this permission is used to show nicknames on head of players.")
})

minetest.register_chatcommand("nicknames_hide", {
    description = S("this command is used to hide nicknames on head of players."),
    privs = {nicknames_hide = true},
    func = function(name, param)
        for _, player in pairs(minetest.get_connected_players()) do
            player:set_nametag_attributes({color = {a = 0, r = 255, g = 255, b = 255}})
        end
        minetest.chat_send_player(name, S("all nicknames are now hid from your eyes."))
    end
})

minetest.register_chatcommand("nicknames_show", {
    description = S("this command is used to show nicknames on head of players."),
    privs = {nicknames_show = true},
    func = function(name, param)
        for _, player in pairs(minetest.get_connected_players()) do
            player:set_nametag_attributes({color = {a = 255, r = 255, g = 255, b = 255}})
        end
        minetest.chat_send_player(name, S("all nicknames are now showed from your eyes."))
    end
})

