local TRANSLATE = minetest.get_translator("titou_nicknames")
local KEY_SETTING_NICKNAMES_VISIBILITY = "titou_nicknames:visibility"
local KEY_SETTING_NICKNAMES_COLOR = "titou_nicknames:color"
local RGB_DATA = {
    green = {r = 0, g = 255, b = 0},
    purple = {r = 215, g = 0, b = 173},
    orange = {r = 255, g = 124, b = 0},
    blue = {r = 0, g = 0, b = 255},
    white = {r = 255, g = 255, b = 255}
}
local function nicknames_refresh()
    local VISIBILITY = minetest.settings:get(KEY_SETTING_NICKNAMES_VISIBILITY)
    local COLOR_NAME = minetest.settings:get(KEY_SETTING_NICKNAMES_COLOR)
    local RGB_DATA = RGB_DATA[COLOR_NAME]

    for _, player in pairs(minetest.get_connected_players()) do
        player:set_nametag_attributes({
            color = {a = VISIBILITY, r = RGB_DATA.r, g = RGB_DATA.g, b = RGB_DATA.b}
        })
    end
end

if minetest.settings:get(KEY_SETTING_NICKNAMES_VISIBILITY) == nil then
    minetest.settings:set(KEY_SETTING_NICKNAMES_VISIBILITY, "255")
end

if minetest.settings:get(KEY_SETTING_NICKNAMES_COLOR) == nil then
    minetest.settings:set(KEY_SETTING_NICKNAMES_COLOR, "white")
end

minetest.register_chatcommand("titou_status", {
    description = TRANSLATE("this command serves to know if the TITOU services are working."),
    func = function(name)
        minetest.chat_send_player(name, TRANSLATE("the TITOU services are correctly running here.thanks to titou4 for the mods."))
        return true
    end,
})

minetest.register_privilege("nicknames_settings", {
    description = TRANSLATE("this permission serves to define the settings of the players's nicknames.")
})

minetest.register_chatcommand("nicknames_visibility", {
    description = TRANSLATE("this command serves to define the visibility of the players's nicknames."),
    privs = {nicknames_settings = true},
    func = function(name, param)
	local SELECTION_VISIBILITY = param:trim()
	local SELECTION_VISIBILITY = tonumber(SELECTION_VISIBILITY)
	
	if not SELECTION_VISIBILITY or SELECTION_VISIBILITY < 0 or SELECTION_VISIBILITY > 255 then
	    local POSSIBILITIES = "0-255"
	    return false, TRANSLATE("please enter a correct value (@1).", POSSIBILITIES)
	end
	
	minetest.settings:set(KEY_SETTING_NICKNAMES_VISIBILITY, SELECTION_VISIBILITY)
	minetest.log("action", "[titou nicknames] " .. name .. " has changed the nicknames's visibility to " .. SELECTION_VISIBILITY .. ".")
	
        nicknames_refresh()
        return true, TRANSLATE("the custom setting has been successfully set.")
    end
})

minetest.register_chatcommand("nicknames_color", {
    description = TRANSLATE("this command serves to define the color of the players's nicknames."),
    privs = {nicknames_settings = true},
    func = function(name, param)
	local SELECTION_COLOR = param:trim()
	
        if not RGB_DATA[SELECTION_COLOR] then
            local POSSIBILITIES = "green/purple/orange/blue/white"
            return false, TRANSLATE("please enter a correct value (@1).", POSSIBILITIES)
        end
        
        minetest.settings:set(KEY_SETTING_NICKNAMES_COLOR, SELECTION_COLOR)
        minetest.log("action", "[titou nicknames] " .. name .. " has changed the nicknames's color to " .. SELECTION_COLOR .. ".")
	
        nicknames_refresh()
        return true, TRANSLATE("the custom setting has been successfully set.")
    end
})

minetest.register_on_joinplayer(function(player)
    nicknames_refresh()
end)
