local TRANSLATE = minetest.get_translator("titou_nicknames")
local KEY_SETTING_NICKNAMES_VISIBILITY = "titou_nicknames:visibility"
local KEY_SETTING_NICKNAMES_COLOR = "titou_nicknames:color"
local COLORS = {
    green = {r = 0, g = 255, b = 0},
    purple = {r = 215, g = 0, b = 173},
    orange = {r = 255, g = 124, b = 0},
    blue = {r = 0, g = 0, b = 255},
    white = {r = 255, g = 255, b = 255}
}
local function nicknames_refresh()
    local SELECTION_VISIBILITY = minetest.settings:get(KEY_SETTING_NICKNAMES_VISIBILITY)
    local SELECTION_COLOR = minetest.settings:get(KEY_SETTING_NICKNAMES_COLOR)
    local RGB_DATA = COLORS[SELECTION_COLOR]

    for _, player in pairs(minetest.get_connected_players()) do
        player:set_nametag_attributes({
            color = {a = SELECTION_VISIBILITY, r = RGB_DATA.r, g = RGB_DATA.g, b = RGB_DATA.b}
        })
    end
end

if minetest.settings:get(KEY_SETTING_NICKNAMES_VISIBILITY) == nil then
    minetest.settings:set(KEY_SETTING_NICKNAMES_VISIBILITY, "255")
end

if minetest.settings:get(KEY_SETTING_NICKNAMES_COLOR) == nil then
    minetest.settings:set(KEY_SETTING_NICKNAMES_COLOR, "white")
end

minetest.register_chatcommand("titou_status", {
    description = TRANSLATE("this command serves to know if the TITOU services are working."),
    func = function(name)
        local COMMAND_AUTHOR = name
        minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the TITOU services are correctly running here.thanks to titou4 for the mods."))
    end,
})

minetest.register_privilege("nicknames_settings", {
    description = TRANSLATE("this permission serves to define the settings of the players's nicknames.")
})

minetest.register_chatcommand("nicknames_visibility", {
    description = TRANSLATE("this command serves to define the visibility of the players's nicknames."),
    privs = {nicknames_settings = true},
    func = function(name, param)
        local COMMAND_AUTHOR = name
	local SELECTION_VISIBILITY = param:trim()
	
	if not tonumber(SELECTION_VISIBILITY) or tonumber(SELECTION_VISIBILITY) < 0 or tonumber(SELECTION_VISIBILITY) > 255
	then
	    local POSSIBILITIES = "0-255"
	    minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("please enter a correct value (@1).", POSSIBILITIES))
	else
	    minetest.settings:set(KEY_SETTING_NICKNAMES_VISIBILITY, SELECTION_VISIBILITY)
	    nicknames_refresh()
	    minetest.log("action", "[titou nicknames] " .. COMMAND_AUTHOR .. " has changed the nicknames's visibility to " .. SELECTION_VISIBILITY .. ".")
            minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the custom setting has been successfully set."))
	end
    end
})

minetest.register_chatcommand("nicknames_color", {
    description = TRANSLATE("this command serves to define the color of the players's nicknames."),
    privs = {nicknames_settings = true},
    func = function(name, param)
        local COMMAND_AUTHOR = name
	local SELECTION_COLOR = param:trim()
	
        if not COLORS[SELECTION_COLOR]
        then
            local POSSIBILITIES = "green/purple/orange/blue/white"
            minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("please enter a correct value (@1).", POSSIBILITIES))
        else
            minetest.settings:set(KEY_SETTING_NICKNAMES_COLOR, SELECTION_COLOR)
            nicknames_refresh()
            minetest.log("action", "[titou nicknames] " .. COMMAND_AUTHOR .. " has changed the nicknames's color to " .. SELECTION_COLOR .. ".")
            minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the custom setting has been successfully set."))
        end
    end
})

minetest.register_on_joinplayer(function(player)
    nicknames_refresh()
end)
