minetest.register_privilege("mute", {
    description = TRANSLATE("this permission serves to mute/unmute players."),
})

minetest.register_chatcommand("perm_mute_nick", {
	params = "[nickname] [reason]", 
	description = TRANSLATE("this command serves to permanently mute a player by his nickname."),
	privs = {mute = true},
	func = function(name, param)
		local playername_target, reason = param:match("^(%S+)%s*(.-)$")
		if not playername_target or playername_target == "" or not reason or reason == "" then
		    return false, TRANSLATE("usage : /perm_mute_nick [nickname] [reason]")
		end
		local player = minetest.get_player_by_name(playername_target)
		if not player then
		    return false, TRANSLATE("the player @1 is not connected.", playername_target)
		end
		local meta = player:get_meta()
		local current_status = meta:get_string("titou_punish:mute")
		if current_status and current_status ~= "peace" then
		    return false, TRANSLATE("the player @1 is already muted for @2.", playername_target, current_status)
		end
		meta:set_string("titou_punish:mute", reason)
		return true, TRANSLATE("the player @1 has been successfully muted.", playername_target)
	end,
})

minetest.register_chatcommand("unmute", {
	params = "[nickname]",
	description = TRANSLATE("this command serves to unmute a player by his nickname."),
	privs = {mute = true},
	func = function(name, param)
		local playername_target = param:trim()
		if playername_target == "" then
			return false, TRANSLATE("usage : /unmute [nickname]")
		end
		local player = minetest.get_player_by_name(playername_target)
		if not player then
			return false, TRANSLATE("the player @1 is not connected.", playername_target)
		end
		local meta = player:get_meta()
		local current_status = meta:get_string("titou_punish:mute")
		if not current_status or current_status == "peace" then
			return false, TRANSLATE("@1 is not muted.", playername_target)
		end
		meta:set_string("titou_punish:mute", "peace")
		return true, TRANSLATE("the player @1 has been successfully unmuted.", playername_target)
	end,
})

minetest.register_on_chat_message(function(name, message)
	local is_command = message:sub(1, 1) == "/"
	local player = minetest.get_player_by_name(name)
	if player then
		local meta = player:get_meta()
		local mute_reason = meta:get_string("titou_punish:mute")
		if mute_reason and mute_reason ~= "peace" and mute_reason ~= "" then
			if not is_command then
			    minetest.chat_send_player(name, TRANSLATE("you can't send public messages because you are muted for @1.", mute_reason))
			    return true 
			end
		elseif mute_reason == "" then
			meta:set_string("titou_punish:mute", "peace")
		end
	end
	return false
end)

