local KEY_META_INVENTORY = "titou_punish:inventory"
local USUAL_INV_SIZE = 32
local USUAL_CRAFT_SIZE = 9

minetest.register_privilege("inventory_toggle", {
    description = TRANSLATE("this permission serves to toggle the inventory of players.")
})

minetest.register_chatcommand("inventory_toggle", {
    params = "[nickname]",
    description = TRANSLATE("this command serves to enable or disable the inventory of a player."),
    privs = {inventory_toggle = true},
    func = function(player_punisher, param)
        local COMMAND_AUTHOR = name
        local player = minetest.get_player_by_name(param)
        if not player
        then
            return false, TRANSLATE("the player @1 is not connected.", param)
        end

        local player_punished = player:get_player_name()
        local inv = player:get_inventory()
        local meta = player:get_meta()
        local current_status = meta:get_string(KEY_META_INVENTORY)

        if current_status == "punished"
        then
            inv:set_size("main", USUAL_INV_SIZE)
            inv:set_size("craft", USUAL_CRAFT_SIZE)
            meta:set_string(KEY_META_INVENTORY, "peace")
            minetest.chat_send_player(player_punished, TRANSLATE("your inventory has been enabled but it is clear."))
            return true, TRANSLATE("the inventory of @1 is now enabled but it is clear.", player_punished)
        else
            inv:set_size("main", 0)
            inv:set_size("craft", 0)
            meta:set_string(KEY_META_INVENTORY, "punished")
            minetest.chat_send_player(player_punished, TRANSLATE("your inventory has been disabled.the content inside was deleted forever."))
            return true, TRANSLATE("the inventory of @1 is now disabled.the content inside was deleted forever.", player_punished)
        end
    end,
})


minetest.register_on_joinplayer(function(player)
    local meta = player:get_meta()
    local current_status = meta:get_string(KEY_META_INVENTORY)
    local inv = player:get_inventory()

    if current_status == "punished"
    then
        inv:set_size("main", 0)
        inv:set_size("craft", 0)
    else
        if current_status ~= "peace"
        then
            meta:set_string(KEY_META_INVENTORY, "peace")
        end
    end
end)
