local KEY_META_MUTE = "titou_punish:mute"

minetest.register_privilege("mute", {
    description = TRANSLATE("this permission serves to mute/unmute players."),
})

minetest.register_chatcommand("mute_nick_perm", {
    params = "[nickname] [reason]", 
    description = TRANSLATE("this command serves to permanently mute a player by his nickname."),
    privs = {mute = true},
    func = function(COMMAND_AUTHOR, ARGUMENTS)
        local IMPOSTOR, REASON = ARGUMENTS:match("^(%S+)%s*(.-)$")
        if IMPOSTOR
        then
            local PLAYERDATA = minetest.get_player_by_name(IMPOSTOR)
            if PLAYERDATA
            then
                local meta = PLAYERDATA:get_meta()
                local STATUS = meta:get_string(KEY_META_MUTE)
                if STATUS == ""
                then
                    meta:set_string(KEY_META_MUTE, "impostor")
                    minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the player @1 has been successfully muted.", IMPOSTOR))
                else
                    if STATUS == "impostor"
                    then
                        minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the player @1 is already muted.", IMPOSTOR))
                    else
                        minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the player @1 is already muted for @2.", IMPOSTOR, STATUS))
                    end
                end
            else
                minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the player @1 is not connected.", IMPOSTOR))
            end
        else
            minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("usage : /mute_nick_perm [nickname] [reason]"))
        end
    end,
})

minetest.register_chatcommand("unmute", {
    params = "[nickname]",
    description = TRANSLATE("this command serves to unmute a player by his nickname."),
    privs = {mute = true},
    func = function(COMMAND_AUTHOR, ARGUMENTS)
	local IMPOSTOR = ARGUMENTS:trim()
	if IMPOSTOR
	then
	    local PLAYERDATA = minetest.get_player_by_name(IMPOSTOR)
            if PLAYERDATA
            then
                local meta = PLAYERDATA:get_meta()
                local STATUS = meta:get_string(KEY_META_MUTE)
                if STATUS == ""
                then
                    minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("@1 is not muted.", IMPOSTOR))
                else
                    meta:set_string(KEY_META_MUTE, "")
                    minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the player @1 has been successfully unmuted.", IMPOSTOR))
                end
            else
                minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the player @1 is not connected.", IMPOSTOR))
            end
	else
	    minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("usage : /unmute [nickname]"))
	end
    end,
})

minetest.register_on_chat_message(function(IMPOSTOR, MESSAGE)
    local PLAYERDATA = minetest.get_player_by_name(IMPOSTOR)
    local meta = PLAYERDATA:get_meta()
    local STATUS = meta:get_string(KEY_META_MUTE)
    if STATUS ~= "" then
        if STATUS == "impostor" then
            minetest.chat_send_player(IMPOSTOR, TRANSLATE("you can't send public messages because you are muted."))
        else
            minetest.chat_send_player(IMPOSTOR, TRANSLATE("you can't send public messages because you are muted for @1.", STATUS))
        end
        return true
    end
end)

minetest.register_on_chatcommand(function(IMPOSTOR, COMMAND)
    local PLAYERDATA = minetest.get_player_by_name(IMPOSTOR)
    local meta = PLAYERDATA:get_meta()
    local STATUS = meta:get_string(KEY_META_MUTE)
    if COMMAND == "msg" and STATUS ~= ""
    then
        if STATUS == "impostor"
        then
            minetest.chat_send_player(IMPOSTOR, TRANSLATE("you can't send private messages because you are muted."))
        else
            minetest.chat_send_player(IMPOSTOR, TRANSLATE("you can't send private messages because you are muted for @1.", STATUS))
        end
        return true
    end
    
    if COMMAND == "me" and STATUS ~= ""
    then
        if STATUS == "impostor"
        then
            minetest.chat_send_player(IMPOSTOR, TRANSLATE("you can't send public messages because you are muted."))
        else
            minetest.chat_send_player(IMPOSTOR, TRANSLATE("you can't send public messages because you are muted for @1.", STATUS))
        end
        return true
    end
end)
