local KEY_META_INVENTORY = "titou_punish:inventory"
local USUAL_INV_SIZE = 32
local USUAL_CRAFT_SIZE = 9

minetest.register_privilege("inventory_toggle", {
    description = TRANSLATE("this permission serves to toggle the inventory of players.")
})

minetest.register_chatcommand("inventory_toggle", {
    params = "[nickname]",
    description = TRANSLATE("this command serves to enable or disable the inventory of a player."),
    privs = {inventory_toggle = true},
    func = function(COMMAND_AUTHOR, ARGUMENTS)
        local IMPOSTOR = ARGUMENTS:trim()
        local PLAYERDATA = minetest.get_player_by_name(IMPOSTOR)
        if IMPOSTOR ~= ""
        then
            if PLAYERDATA
            then
                local inv = PLAYERDATA:get_inventory()
                local meta = PLAYERDATA:get_meta()
                if meta:get_string(KEY_META_INVENTORY) == "punished"
                then
                    inv:set_size("main", USUAL_INV_SIZE)
                    inv:set_size("craft", USUAL_CRAFT_SIZE)
                    meta:set_string(KEY_META_INVENTORY, "")
                    minetest.chat_send_player(IMPOSTOR, TRANSLATE("your inventory has been enabled but it is clear."))
                    minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the inventory of @1 is now enabled but it is clear.", IMPOSTOR))
                    minetest.log("action", "[titou punish] " .. COMMAND_AUTHOR .. " has enabled the inventory of " .. IMPOSTOR .. ".")
                else
                    inv:set_size("main", 0)
                    inv:set_size("craft", 0)
                    meta:set_string(KEY_META_INVENTORY, "punished")
                    minetest.chat_send_player(IMPOSTOR, TRANSLATE("your inventory has been disabled.the content inside was deleted forever."))
                    minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the inventory of @1 is now disabled.the content inside was deleted forever.", IMPOSTOR))
                    minetest.log("action", "[titou punish] " .. COMMAND_AUTHOR .. " has disabled the inventory of " .. IMPOSTOR .. ".")
                end
            else
                minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the player @1 is not connected.", IMPOSTOR))
            end
        else
            minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("usage : /inventory_toggle [nickname]"))
        end
    end,
})


minetest.register_on_joinplayer(function(player)
    local meta = player:get_meta()
    local inv = player:get_inventory()
    local STATUS = meta:get_string(KEY_META_INVENTORY)
    if STATUS == "punished"
    then
        inv:set_size("main", 0)
        inv:set_size("craft", 0)
    end
end)
