minetest.register_privilege("get_reports", {
    description = TRANSLATE("this permission serves to receive reports from players.")
})

minetest.register_chatcommand("report", {
    params = "[nickname] [reason]",
    description = TRANSLATE("this command serves to send a report to the game staff about a player who breaked the game rules."),
    func = function(COMMAND_AUTHOR, ARGUMENTS)
        local IMPOSTOR, REASON = ARGUMENTS:match("^%s*(%S+)%s*(.*)$")
        if IMPOSTOR and IMPOSTOR ~= "" and REASON ~= ""
	then
	    local RECEIVER_AVAILABLE = false
	    for _, player in ipairs(minetest.get_connected_players())
	    do
                local RECEIVER_NAME = player:get_player_name()
                if minetest.check_player_privs(RECEIVER_NAME, "get_reports")
                then
                    minetest.chat_send_player(RECEIVER_NAME, TRANSLATE("@1 was reported by @2 for @3.", IMPOSTOR, COMMAND_AUTHOR, REASON))
                    RECEIVER_AVAILABLE = true
                end
            end
            if RECEIVER_AVAILABLE
            then
                minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("your report about @1 has been successfully sent to a staff member.", IMPOSTOR))
            else
                minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("sorry but nobody able to manage reports is online.please try later."))
            end
            minetest.log("action", "[titou punish] " .. IMPOSTOR .. " was reported by " .. COMMAND_AUTHOR .. " for " .. REASON .. ".")
	else
	    minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("usage : /report [nickname] [reason]"))
        end
    end,
})
