if minetest.setting_get("titou_teleport:homestp_delay_withoutmove") == nil then
    minetest.setting_set("titou_teleport:homestp_delay_withoutmove", "5")
    minetest.setting_save()
end

if minetest.setting_get("titou_teleport:homestp_max_saved") == nil then
    minetest.setting_set("titou_teleport:homestp_max_saved", "5")
    minetest.setting_save()
end

minetest.register_privilege("homestp_settings", {
    description = S("this permission serves to manage settings of the homes system.")
})

minetest.register_chatcommand("homestp_set_delay_withoutmove", {
    params = "[delay]",
    description = S("this command serves to define the delay that all player will need to wait without moving to go home."),
    privs = {homestp_settings = true},
    func = function(name, param)
        local current_delay = tonumber(minetest.setting_get("titou_teleport:homestp_delay_withoutmove"))
        if not param or param == "" then
            return false, S("the current delay is @1 seconds between each teleportations.", current_delay)
        end
        local delay = tonumber(param)
        if delay == nil or delay < 1 then
            return false, S("please enter a correct value.")
        end
        minetest.setting_set("titou_teleport:homestp_delay_withoutmove", delay)
        minetest.setting_save()
        return true, S("the custom setting has been successfully set."):format(delay)
    end,
})

minetest.register_chatcommand("homestp_set_max_saved", {
    params = "[saved homes limit]",
    description = S("this command serves to define the maximum of homes that a player can save."),
    privs = {homestp_settings = true},
    func = function(name, param)
        local current_max_homes = tonumber(minetest.setting_get("titou_teleport:homestp_max_saved"))
        if not param or param == "" then
            return false, S("the current maximum of saved homes is @1 homes by player.", current_max_homes)
        end
        local max_homes = tonumber(param)
        if max_homes == nil or max_homes < 1 then
            return false, S("please enter a correct value.")
        end
        minetest.setting_set("titou_teleport:homestp_max_saved", max_homes)
        minetest.setting_save()
        return true, S("the custom setting has been successfully set."):format(max_homes)
    end,
})
