local players = {}

if minetest.setting_get("titou_teleport:randomtp_delay_between") == nil then
    minetest.setting_set("titou_teleport:randomtp_delay_between", "20")
    minetest.setting_save()
end

minetest.register_privilege("randomtp_settings", {
    description = S("this permission serves to manage settings of the random teleportation system.")
})

minetest.register_chatcommand("randomtp_set_delay_between", {
    params = "[delay]",
    description = S("this command serves to define the delay between each random teleportation."),
    privs = {randomtp_settings = true},
    func = function(name, param)
        local current_delay = tonumber(minetest.setting_get("titou_teleport:randomtp_delay_between"))
        if not param or param == "" then
            return false, S("the current delay is @1 seconds between each teleportations.", current_delay)
        end
        local delay = tonumber(param)
        if delay == nil or delay < 1 then
            return false, S("please enter a correct value.")
        end
        minetest.setting_set("titou_teleport:randomtp_delay_between", delay)
        minetest.setting_save()
        return true, S("the custom setting has been successfully set."):format(delay)
    end,
})

minetest.register_chatcommand("randomtp_use", {
    description = S("this command serves to teleport to a random location."),
    func = function(name)
        local timer = tonumber(minetest.setting_get("titou_teleport:randomtp_delay_between"))
        local teleporting = false
        for k, v in pairs(players) do
            if v == name then
                teleporting = true
                break
            end
        end
        if teleporting == false then
            table.insert(players, name)
            local player = minetest.get_player_by_name(name)
            local old_pos = player:getpos()
            local x = math.random(-30000, 30000)
            local y = 0
            local z = math.random(-30000, 30000)
            local pos = vector.new(x, y, z)
            local erreur = false
            player:setpos(pos)
            minetest.chat_send_player(name, S("a good location is currently in search for you...please wait."))
            minetest.after(3, function()
                local node_name = minetest.get_node(player:getpos()).name
                while node_name ~= "air" do
                    y = y + 1
                    local pos = vector.new(x, y, z)
                    player:setpos(pos)
                    node_name = minetest.get_node(player:getpos()).name
                    if y > 500 then
                        player:setpos(old_pos)
                        erreur = true
                        break
                    end
                end
                if erreur == true then
                    minetest.chat_send_player(name, S("the random teleportation failed.try again.if the problem persist,maybe the world is not compatible with the mod."))
                else
                    minetest.chat_send_player(name, S("you have been successfully teleported to a random location."))
                end
            end)
            minetest.after(timer, function()
                for k, v in pairs(players) do
                    if v == name then
                        table.remove(players, k)
                        break
                    end
                end
            end)
        else
            minetest.chat_send_player(name, S("you need to wait the delay before use again this command."))
        end
    end,
})
