minetest.register_chatcommand("homes_max", {
    params = "[max homes]",
    description = TRANSLATE("this command serves to define the maximum of homes that a player can save."),
    privs = {tp_settings = true},
    func = function(name, param)
        if param == "" then
            return false, TRANSLATE("the current maximum of saved homes is @1 homes by player.", minetest.settings:get(KEY_SETTING_TELEPORT_HOMESMAX))
        end
        local SELECTION_HOMESMAX = tonumber(param)
        if SELECTION_HOMESMAX == nil or SELECTION_HOMESMAX < 1 then
            return false, TRANSLATE("please enter a correct value.")
        end
        minetest.settings:set(KEY_SETTING_TELEPORT_HOMESMAX, SELECTION_HOMESMAX)
        return true, TRANSLATE("the custom setting has been successfully set.")
    end,
})
