local players = {}

minetest.register_chatcommand("rtp", {
    description = TRANSLATE("this command serves to teleport to a random location."),
    func = function(name)
        local player = minetest.get_player_by_name(name)
        local old_pos = player:getpos()
        local x = math.random(-30000, 30000)
        local y = 0
        local z = math.random(-30000, 30000)
        local pos = vector.new(x, y, z)
        local failed = false
        player:setpos(pos)
        minetest.chat_send_player(name, TRANSLATE("a good location is currently in search for you...please wait."))
        minetest.after(3, function()
            local current_pos = player:getpos()
            local node = minetest.get_node(current_pos)
            while node.name ~= "air" or minetest.get_node({x=x, y=y-1, z=z}).name == "default:water_source" or minetest.get_node({x=x, y=y-1, z=z}).name == "default:river_water_source" do
                y = y + 1
                local pos = vector.new(x, y, z)
                player:setpos(pos)
                node = minetest.get_node(player:getpos())
                if y > 500 then
                    player:setpos(old_pos)
                    failed = true
                    break
                end
            end
            if failed == true then
                minetest.chat_send_player(name, TRANSLATE("the random teleportation failed.try again.if the problem persist,maybe the world is not compatible with the mod."))
            else
                minetest.chat_send_player(name, TRANSLATE("you have been successfully teleported to a random location."))
            end
        end)
    end,
})
