minetest.register_chatcommand("homes_max", {
    params = "[max homes]",
    description = TRANSLATE("this command serves to define the maximum of homes that a player can save."),
    privs = {tp_settings = true},
    func = function(name, param)
        local COMMAND_AUTHOR = name
        local SELECTION_HOMESMAX = tonumber(param)
        if param == ""
        then
            minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the current maximum of saved homes is @1 homes by player.", minetest.settings:get(KEY_SETTING_TELEPORT_HOMESMAX)))
        else
            if SELECTION_HOMESMAX == nil or SELECTION_HOMESMAX < 1
            then
                minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("please enter a correct value."))
            else
                minetest.settings:set(KEY_SETTING_TELEPORT_HOMESMAX, SELECTION_HOMESMAX)
                minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the custom setting has been successfully set."))
            end
        end
    end,
})
