TRANSLATE = minetest.get_translator("titou_teleport")
KEY_SETTING_TELEPORT_DELAY = "titou_teleport:delay"
KEY_SETTING_TELEPORT_HOMESMAX = "titou_teleport:max_homes"

if minetest.settings:get(KEY_SETTING_TELEPORT_DELAY) == nil
then
    minetest.settings:set(KEY_SETTING_TELEPORT_DELAY, "3")
end

if minetest.settings:get(KEY_SETTING_TELEPORT_HOMESMAX) == nil
then
    minetest.settings:set(KEY_SETTING_TELEPORT_HOMESMAX, "5")
end

minetest.register_privilege("tp_settings", {
    description = TRANSLATE("this permission serves to manage settings of the teleport system.")
})

minetest.register_chatcommand("titou_status", {
    description = TRANSLATE("this command serves to know if the TITOU services are working."),
    func = function(name)
        local COMMAND_AUTHOR = name
        minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the TITOU services are correctly running here.thanks to titou4 for the mods."))
    end,
})

minetest.register_chatcommand("tpdelay", {
    params = "[delay]",
    description = TRANSLATE("this command serves to define the delay that all player will need to wait without moving to be teleported."),
    privs = {tp_settings = true},
    func = function(name, param)
        local COMMAND_AUTHOR = name
        local SELECTION_DELAY = tonumber(param)
        if param == ""
        then
            minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the current delay is @1 seconds.", minetest.settings:get(KEY_SETTING_TELEPORT_DELAY)))
        else
            if SELECTION_DELAY == nil or SELECTION_DELAY < 1
            then
                minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("please enter a correct value."))
            else
                minetest.settings:set(KEY_SETTING_TELEPORT_DELAY, SELECTION_DELAY)
                minetest.chat_send_player(COMMAND_AUTHOR, TRANSLATE("the custom setting has been successfully set."))
            end
        end
    end,
})

dofile(minetest.get_modpath(minetest.get_current_modname()) .. "/random_teleport.lua")
dofile(minetest.get_modpath(minetest.get_current_modname()) .. "/homes.lua")
