minetest.register_on_joinplayer(function(player)
    local grey_id = player:hud_add({
        hud_elem_type = "image",
        position  = {x = 0.5, y = 0.5},
        alignment = {x = 0, y = 0},
        scale     = {x = -100, y = -100},
        text      = "null.png^[opacity:0",
        z_index   = 100,
    })
    local time_elapsed = 0
    local total_time = 300
    local interval = 1
    local function fade_step()
        time_elapsed = time_elapsed + interval
        local percentage = time_elapsed / total_time
        local opacity = math.floor(percentage * 255)
        if opacity > 255 then opacity = 255 end
        player:hud_change(grey_id, "text", "null.png^[opacity:" .. opacity)
        if time_elapsed < total_time then
            minetest.after(interval, fade_step)
        end
    end
    minetest.after(interval, fade_step)
end)

local all_nodes = {}
minetest.after(0, function()
    for name, def in pairs(minetest.registered_nodes) do
        if name ~= "air" and name ~= "ignore" and def.drawtype == "normal" then
            table.insert(all_nodes, name)
        end
    end
end)
local time_passed = 0
minetest.register_globalstep(function(dtime)
    time_passed = time_passed + dtime
    local chance = time_passed / 300
    if chance > 0 then
        for _, player in ipairs(minetest.get_connected_players()) do
            local pos = player:get_pos()
            if math.random() < chance then
                local rand_pos = {
                    x = pos.x + math.random(-50, 50),
                    y = pos.y + math.random(-10, 10),
                    z = pos.z + math.random(-50, 50),
                }
                local current_node = minetest.get_node(rand_pos).name
                if current_node == "air" or current_node == "ignore" then
                    local random_name = all_nodes[math.random(#all_nodes)]
                    minetest.set_node(rand_pos, {name = random_name})
                end
            end
        end
    end
end)