local function rotate_and_place(itemstack, placer, pointed_thing)
	local p0 = pointed_thing.under
	local p1 = pointed_thing.above
	local param2 = 0

	local placer_pos = placer:getpos()
	if placer_pos then
		param2 = minetest.dir_to_facedir(vector.subtract(p1, placer_pos))
	end

	local finepos = minetest.pointed_thing_to_face_pos(placer, pointed_thing)
	local fpos = finepos.y % 1

	if p0.y - 1 == p1.y or (fpos > 0 and fpos < 0.5)
			or (fpos < -0.5 and fpos > -0.999999999) then
		param2 = param2 + 20
		if param2 == 21 then
			param2 = 23
		elseif param2 == 23 then
			param2 = 21
		end
	end
	return minetest.item_place(itemstack, placer, pointed_thing, param2)
end

if minetest.settings:get_bool("bridger_enable_trusses", true) then
	local bridge_colors = {
		{"Green", "green"},
		{"Red", "red"},
		{"Steel", "steel"},
		{"White", "white"},
		{"Yellow", "yellow"},
	}

	for _, row in ipairs(bridge_colors) do
		local bridge_desc = row[1]
		local bridge_color = row[2]

		minetest.register_node("bridger:foundation", {
			description = "Bridge Foundation",
			drawtype = "nodebox",
			tiles = {"default_clay.png"},
			paramtype = "light",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.75, 0.5, 0.501, 0.75},
					{-0.501, -0.5, -0.501, 0.501, 0.6876, 0.501},
					{-0.75, -0.5, -0.5, 0.75, 0.501, 0.5},
					{-0.75, -0.5, -0.75, 0.75, 0.499, 0.75},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_stone_defaults(),
		})

		minetest.register_node("bridger:block_" .. bridge_color, {
			description = bridge_desc .. " Block",
			drawtype = "normal",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			paramtype = "light",
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		if minetest.get_modpath("moreblocks") then
			stairsplus:register_all("bridger", "block_" .. bridge_color, "bridger:block_" .. bridge_color, {
				description = bridge_desc,
				tiles = {"bridges_" .. bridge_color .. ".png"},
				groups = {cracky=3},
				sounds = default.node_sound_metal_defaults(),
			})

			minetest.register_alias("bridger:step_" .. bridge_color, "bridger:panel_block_" .. bridge_color)
		elseif minetest.get_modpath("stairs") then
			stairs.register_stair_and_slab(
				"block_" .. bridge_color,
				"bridger:block_" .. bridge_color,
				{cracky=3},
				{"bridges_" .. bridge_color .. ".png"},
				bridge_desc .. " Stair",
				bridge_desc .. " Slab",
				default.node_sound_metal_defaults()
			)

			minetest.register_node("bridger:step_" .. bridge_color, {
				description = bridge_desc .. " Step",
				drawtype = "nodebox",
				tiles = {"bridges_" .. bridge_color .. ".png"},
				paramtype = "light",
				paramtype2 = "facedir",
				node_box = {
					type = "fixed",
					fixed = {
						{-0.5, -0.5, 0, 0.5, 0, 0.5},
					},
				},
				groups = {cracky=3},
				sounds = default.node_sound_metal_defaults(),
				on_place = function(itemstack, placer, pointed_thing)
					if pointed_thing.type ~= "node" then
						return itemstack
					end
					return rotate_and_place(itemstack, placer, pointed_thing)
				end,
			})
		end

		minetest.register_node("bridger:suspension_top_" .. bridge_color, {
			description = bridge_desc .. " Cable Top",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			paramtype = "light",
			paramtype2 = "facedir",
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0.5, 0, 0.5},
					{-0.125, -0.5, -0.125, 0.125, 0.5, 0.125},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
			on_place = function(itemstack, placer, pointed_thing)
				if pointed_thing.type ~= "node" then
					return itemstack
				end
				return rotate_and_place(itemstack, placer, pointed_thing)
			end,
		})

		minetest.register_node("bridger:suspension_cable_" .. bridge_color, {
			description = bridge_desc .. " Cable",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			paramtype = "light",
			node_box = {
				type = "fixed",
				fixed = {
					{-0.125, -0.5, -0.125, 0.125, 0.5, 0.125},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:deck_" .. bridge_color, {
			description = bridge_desc .. " Deck",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			paramtype = "light",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, 0.375, -0.5, 0.5, 0.501, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, 0, -0.5, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:deck_edge_" .. bridge_color, {
			description = bridge_desc .. " Deck Edge",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, 0.375, -0.5, 0.5, 0.501, 0.5},
					{-0.5, 0.375, -0.5, 0.5, 1.0625, -0.625},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, 0, -0.5, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:train_deck_" .. bridge_color, {
			description = bridge_desc .. " Train Deck",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			paramtype = "light",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{0.375, 0.375, 0.375, 0.5, 0.501, 0.5},
					{0.3125, 0.375, 0.3125, 0.4375, 0.501, 0.4375},
					{0.25, 0.375, 0.25, 0.375, 0.501, 0.375},
					{0.1875, 0.375, 0.1875, 0.3125, 0.501, 0.3125},
					{0.125, 0.375, 0.125, 0.25, 0.501, 0.25},
					{0.0625, 0.375, 0.0625, 0.1875, 0.501, 0.1875},
					{0, 0.375, 0, 0.125, 0.501, 0.125},
					{-0.0625, 0.375, -0.0625, 0.0625, 0.501, 0.0625},
					{-0.125, 0.375, -0.125, 0, 0.501, 0},
					{-0.1875, 0.375, -0.1875, -0.0625, 0.501, -0.0625},
					{-0.25, 0.375, -0.25, -0.125, 0.501, -0.125},
					{-0.3125, 0.375, -0.3125, -0.1875, 0.501, -0.1875},
					{-0.4375, 0.375, -0.4375, -0.3125, 0.501, -0.3125},
					{-0.375, 0.375, -0.375, -0.25, 0.501, -0.25},
					{-0.5, 0.375, -0.5, -0.375, 0.501, -0.375},
					{-0.5, 0.375, 0.375, -0.375, 0.501, 0.5},
					{-0.4375, 0.375, 0.3125, -0.3125, 0.501, 0.4375},
					{-0.375, 0.375, 0.25, -0.25, 0.501, 0.375},
					{-0.3125, 0.375, 0.1875, -0.1875, 0.501, 0.3125},
					{-0.25, 0.375, 0.125, -0.125, 0.501, 0.25},
					{-0.1875, 0.375, 0.0625, -0.0625, 0.501, 0.1875},
					{-0.125, 0.375, 0, 0, 0.501, 0.125},
					{0, 0.375, -0.125, 0.125, 0.501, 0},
					{0.0625, 0.375, -0.1875, 0.1875, 0.501, -0.0625},
					{0.125, 0.375, -0.25, 0.25, 0.501, -0.125},
					{0.1875, 0.375, -0.3125, 0.3125, 0.501, -0.1875},
					{0.25, 0.375, -0.375, 0.375, 0.501, -0.25},
					{0.3125, 0.375, -0.4375, 0.4375, 0.501, -0.3125},
					{0.375, 0.375, -0.5, 0.5, 0.501, -0.375},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, 0, -0.5, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:girder_mid_" .. bridge_color, {
			description = bridge_desc .. " Girder Middle",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.4375, 0.5, 0.5, 0.5},
					{-0.5, 0.4375, 0.375, 0.5, 0.5, 0.5},
					{0.46875, -0.5, 0.375, 0.5, 0.5, 0.5},
					{-0.5, -0.5, 0.375, -0.46875, 0.5, 0.5},
					{-0.5, -0.5, 0.375, 0.5, -0.4375, 0.5},
					{-0.5, -0.625, 0.4375, 0.5, -0.5, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:girder_right_" .. bridge_color, {
			description = bridge_desc .. " Girder Right End",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, 0.4375, 0.375, -0.25, 0.5, 0.5},
					{-0.5, -0.5, 0.375, -0.46875, 0.5, 0.5},
					{-0.5, -0.5, 0.375, 0.5, -0.4375, 0.5},
					{-0.3125, 0.375, 0.375, -0.0625, 0.4375, 0.5},
					{-0.125, 0.3125, 0.375, 0.0625, 0.375, 0.5},
					{0, 0.25, 0.375, 0.125, 0.3125, 0.5},
					{0.4375, -0.5, 0.375, 0.5, -0.25, 0.5},
					{0.375, -0.3125, 0.375, 0.4375, -0.0625, 0.5},
					{0.3125, -0.125, 0.375, 0.375, 0.0625, 0.5},
					{0.25, 0, 0.375, 0.3125, 0.125, 0.5},
					{0.1875, 0.0625, 0.375, 0.25, 0.1875, 0.5},
					{0.125, 0.125, 0.375, 0.1875, 0.25, 0.5},
					{0.0625, 0.1875, 0.375, 0.1875, 0.25, 0.5},
					{-0.5, -0.5, 0.4375, -0.0625, 0.4375, 0.5},
					{-0.5, -0.5, 0.4375, 0.4375, -0.0625, 0.5},
					{-0.5, -0.5, 0.4375, 0.125, 0.3125, 0.5},
					{-0.5, -0.5, 0.4375, 0.3125, 0.125, 0.5},
					{-0.5, -0.625, 0.4375, 0.5, -0.5, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:girder_left_" .. bridge_color, {
			description = bridge_desc .. " Girder Left End",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{0.25, 0.4375, 0.375, 0.5, 0.5, 0.5},
					{0.46875, -0.5, 0.375, 0.5, 0.5, 0.5},
					{-0.5, -0.5, 0.375, 0.5, -0.4375, 0.5},
					{0.0625, 0.375, 0.375, 0.3125, 0.4375, 0.5},
					{-0.0625, 0.3125, 0.375, 0.125, 0.375, 0.5},
					{-0.125, 0.25, 0.375, -0, 0.3125, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, -0.25, 0.5},
					{-0.4375, -0.3125, 0.375, -0.375, -0.0625, 0.5},
					{-0.375, -0.125, 0.375, -0.3125, 0.0625, 0.5},
					{-0.3125, 0, 0.375, -0.25, 0.125, 0.5},
					{-0.25, 0.0625, 0.375, -0.1875, 0.1875, 0.5},
					{-0.1875, 0.125, 0.375, -0.125, 0.25, 0.5},
					{-0.1875, 0.1875, 0.375, -0.0625, 0.25, 0.5},
					{0.0625, -0.5, 0.4375, 0.5, 0.4375, 0.5},
					{-0.4375, -0.5, 0.4375, 0.5, -0.0625, 0.5},
					{-0.125, -0.5, 0.4375, 0.5, 0.3125, 0.5},
					{-0.3125, -0.5, 0.4375, 0.5, 0.125, 0.5},
					{-0.5, -0.625, 0.4375, 0.5, -0.5, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_right_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Right Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_right_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_right_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 2.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 2.5, 0.5},
					{-0.5, 2.375, 0.375, 1.5, 2.5, 0.5},
					{-0.4375, 2.25, 0.375, -0.3125, 2.375, 0.5},
					{-0.375, 2.1875, 0.375, -0.25, 2.3125, 0.5},
					{-0.3125, 2.0625, 0.375, -0.1875, 2.25, 0.5},
					{-0.25, 2, 0.375, -0.125, 2.125, 0.5},
					{-0.1875, 1.9375, 0.375, -0.0625, 2.0625, 0.5},
					{-0.125, 1.875, 0.375, 0, 2, 0.5},
					{-0.0625, 1.75, 0.375, 0.0625, 1.9375, 0.5},
					{0, 1.6875, 0.375, 0.125, 1.8125, 0.5},
					{0.0625, 1.625, 0.375, 0.1875, 1.75, 0.5},
					{0.125, 1.5625, 0.375, 0.25, 1.6875, 0.5},
					{0.1875, 1.4375, 0.375, 0.3125, 1.625, 0.5},
					{0.25, 1.375, 0.375, 0.375, 1.5, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.375, 1.25, 0.375, 0.5, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.5, 1.0625, 0.375, 0.625, 1.1875, 0.5},
					{0.5625, 1, 0.375, 0.6875, 1.125, 0.5},
					{0.625, 0.9375, 0.375, 0.75, 1.0625, 0.5},
					{0.6875, 0.8125, 0.375, 0.8125, 1, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.8125, 0.6875, 0.375, 0.9375, 0.8125, 0.5},
					{0.875, 0.625, 0.375, 1, 0.75, 0.5},
					{0.9375, 0.5, 0.375, 1.0625, 0.6875, 0.5},
					{1, 0.4375, 0.375, 1.125, 0.5625, 0.5},
					{1.0625, 0.375, 0.375, 1.1875, 0.5, 0.5},
					{1.125, 0.3125, 0.375, 1.25, 0.4375, 0.5},
					{1.1875, 0.1875, 0.375, 1.3125, 0.375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.25, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
					{1.375, 0, 0.375, 1.5, 0.125, 0.5},
					{-0.4375, 2.3125, 0.375, -0.3125, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_left_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Left Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_left_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_left_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 2.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 2.5, 0.5},
					{-0.5, 2.375, 0.375, 1.5, 2.5, 0.5},
					{1.3125, 2.25, 0.375, 1.4375, 2.375, 0.5},
					{1.25, 2.1875, 0.375, 1.375, 2.3125, 0.5},
					{1.1875, 2.0625, 0.375, 1.3125, 2.25, 0.5},
					{1.125, 2, 0.375, 1.25, 2.125, 0.5},
					{1.0625, 1.9375, 0.375, 1.1875, 2.0625, 0.5},
					{1, 1.875, 0.375, 1.125, 2, 0.5},
					{0.9375, 1.75, 0.375, 1.0625, 1.9375, 0.5},
					{0.875, 1.6875, 0.375, 1, 1.8125, 0.5},
					{0.8125, 1.625, 0.375, 0.9375, 1.75, 0.5},
					{0.75, 1.5625, 0.375, 0.875, 1.6875, 0.5},
					{0.6875, 1.4375, 0.375, 0.8125, 1.625, 0.5},
					{0.625, 1.375, 0.375, 0.75, 1.5, 0.5},
					{0.5625, 1.3125, 0.375, 0.6875, 1.4375, 0.5},
					{0.5, 1.25, 0.375, 0.625, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.375, 1.0625, 0.375, 0.5, 1.1875, 0.5},
					{0.3125, 1, 0.375, 0.4375, 1.125, 0.5},
					{0.25, 0.9375, 0.375, 0.375, 1.0625, 0.5},
					{0.1875, 0.8125, 0.375, 0.3125, 1, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.0625, 0.6875, 0.375, 0.1875, 0.8125, 0.5},
					{0, 0.625, 0.375, 0.125, 0.75, 0.5},
					{-0.0625, 0.5, 0.375, 0.0625, 0.6875, 0.5},
					{-0.125, 0.4375, 0.375, 0, 0.5625, 0.5},
					{-0.1875, 0.375, 0.375, -0.0625, 0.5, 0.5},
					{-0.25, 0.3125, 0.375, -0.125, 0.4375, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.25, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.5, 0, 0.375, -0.375, 0.125, 0.5},
					{1.375, 2.3125, 0.375, 1.5, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_end_right_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure End Right Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_end_right_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_end_right_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 2.5, 0.5},
					{-0.4375, 2.25, 0.375, -0.3125, 2.375, 0.5},
					{-0.375, 2.1875, 0.375, -0.25, 2.3125, 0.5},
					{-0.3125, 2.0625, 0.375, -0.1875, 2.25, 0.5},
					{-0.25, 2, 0.375, -0.125, 2.125, 0.5},
					{-0.1875, 1.9375, 0.375, -0.0625, 2.0625, 0.5},
					{-0.125, 1.875, 0.375, 0, 2, 0.5},
					{-0.0625, 1.75, 0.375, 0.0625, 1.9375, 0.5},
					{0, 1.6875, 0.375, 0.125, 1.8125, 0.5},
					{0.0625, 1.625, 0.375, 0.1875, 1.75, 0.5},
					{0.125, 1.5625, 0.375, 0.25, 1.6875, 0.5},
					{0.1875, 1.4375, 0.375, 0.3125, 1.625, 0.5},
					{0.25, 1.375, 0.375, 0.375, 1.5, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.375, 1.25, 0.375, 0.5, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.5, 1.0625, 0.375, 0.625, 1.1875, 0.5},
					{0.5625, 1, 0.375, 0.6875, 1.125, 0.5},
					{0.625, 0.9375, 0.375, 0.75, 1.0625, 0.5},
					{0.6875, 0.8125, 0.375, 0.8125, 1, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.8125, 0.6875, 0.375, 0.9375, 0.8125, 0.5},
					{0.875, 0.625, 0.375, 1, 0.75, 0.5},
					{0.9375, 0.5, 0.375, 1.0625, 0.6875, 0.5},
					{1, 0.4375, 0.375, 1.125, 0.5625, 0.5},
					{1.0625, 0.375, 0.375, 1.1875, 0.5, 0.5},
					{1.125, 0.3125, 0.375, 1.25, 0.4375, 0.5},
					{1.1875, 0.1875, 0.375, 1.3125, 0.375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.25, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
					{1.375, 0, 0.375, 1.5, 0.125, 0.5},
					{-0.4375, 2.3125, 0.375, -0.3125, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_end_left_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure End Left Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_end_left_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_end_left_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 2.5, 0.5},
					{1.3125, 2.25, 0.375, 1.4375, 2.375, 0.5},
					{1.25, 2.1875, 0.375, 1.375, 2.3125, 0.5},
					{1.1875, 2.0625, 0.375, 1.3125, 2.25, 0.5},
					{1.125, 2, 0.375, 1.25, 2.125, 0.5},
					{1.0625, 1.9375, 0.375, 1.1875, 2.0625, 0.5},
					{1, 1.875, 0.375, 1.125, 2, 0.5},
					{0.9375, 1.75, 0.375, 1.0625, 1.9375, 0.5},
					{0.875, 1.6875, 0.375, 1, 1.8125, 0.5},
					{0.8125, 1.625, 0.375, 0.9375, 1.75, 0.5},
					{0.75, 1.5625, 0.375, 0.875, 1.6875, 0.5},
					{0.6875, 1.4375, 0.375, 0.8125, 1.625, 0.5},
					{0.625, 1.375, 0.375, 0.75, 1.5, 0.5},
					{0.5625, 1.3125, 0.375, 0.6875, 1.4375, 0.5},
					{0.5, 1.25, 0.375, 0.625, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.375, 1.0625, 0.375, 0.5, 1.1875, 0.5},
					{0.3125, 1, 0.375, 0.4375, 1.125, 0.5},
					{0.25, 0.9375, 0.375, 0.375, 1.0625, 0.5},
					{0.1875, 0.8125, 0.375, 0.3125, 1, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.0625, 0.6875, 0.375, 0.1875, 0.8125, 0.5},
					{0, 0.625, 0.375, 0.125, 0.75, 0.5},
					{-0.0625, 0.5, 0.375, 0.0625, 0.6875, 0.5},
					{-0.125, 0.4375, 0.375, 0, 0.5625, 0.5},
					{-0.1875, 0.375, 0.375, -0.0625, 0.5, 0.5},
					{-0.25, 0.3125, 0.375, -0.125, 0.4375, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.25, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.5, 0, 0.375, -0.375, 0.125, 0.5},
					{1.375, 2.3125, 0.375, 1.5, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_mid_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Middle",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_mid.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_mid.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 2.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 2.5, 0.5},
					{-0.5, 2.375, 0.375, 1.5, 2.5, 0.5},
					{-0.4375, 2.25, 0.375, -0.3125, 2.375, 0.5},
					{-0.375, 2.1875, 0.375, -0.25, 2.3125, 0.5},
					{-0.3125, 2.0625, 0.375, -0.1875, 2.25, 0.5},
					{-0.25, 2, 0.375, -0.125, 2.125, 0.5},
					{-0.1875, 1.9375, 0.375, -0.0625, 2.0625, 0.5},
					{-0.125, 1.875, 0.375, 0, 2, 0.5},
					{-0.0625, 1.75, 0.375, 0.0625, 1.9375, 0.5},
					{0, 1.6875, 0.375, 0.125, 1.8125, 0.5},
					{0.0625, 1.625, 0.375, 0.1875, 1.75, 0.5},
					{0.125, 1.5625, 0.375, 0.25, 1.6875, 0.5},
					{0.1875, 1.4375, 0.375, 0.3125, 1.625, 0.5},
					{0.25, 1.375, 0.375, 0.375, 1.5, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.375, 1.25, 0.375, 0.5, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.5, 1.0625, 0.375, 0.625, 1.1875, 0.5},
					{0.5625, 1, 0.375, 0.6875, 1.125, 0.5},
					{0.625, 0.9375, 0.375, 0.75, 1.0625, 0.5},
					{0.6875, 0.8125, 0.375, 0.8125, 1, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.8125, 0.6875, 0.375, 0.9375, 0.8125, 0.5},
					{0.875, 0.625, 0.375, 1, 0.75, 0.5},
					{0.9375, 0.5, 0.375, 1.0625, 0.6875, 0.5},
					{1, 0.4375, 0.375, 1.125, 0.5625, 0.5},
					{1.0625, 0.375, 0.375, 1.1875, 0.5, 0.5},
					{1.125, 0.3125, 0.375, 1.25, 0.4375, 0.5},
					{1.1875, 0.1875, 0.375, 1.3125, 0.375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.25, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
					{1.375, 0, 0.375, 1.5, 0.125, 0.5},
					{-0.4375, 2.3125, 0.375, -0.3125, 2.4375, 0.5},
					{1.3125, 2.25, 0.375, 1.4375, 2.375, 0.5},
					{1.25, 2.1875, 0.375, 1.375, 2.3125, 0.5},
					{1.1875, 2.0625, 0.375, 1.3125, 2.25, 0.5},
					{1.125, 2, 0.375, 1.25, 2.125, 0.5},
					{1.0625, 1.9375, 0.375, 1.1875, 2.0625, 0.5},
					{1, 1.875, 0.375, 1.125, 2, 0.5},
					{0.9375, 1.75, 0.375, 1.0625, 1.9375, 0.5},
					{0.875, 1.6875, 0.375, 1, 1.8125, 0.5},
					{0.8125, 1.625, 0.375, 0.9375, 1.75, 0.5},
					{0.75, 1.5625, 0.375, 0.875, 1.6875, 0.5},
					{0.6875, 1.4375, 0.375, 0.8125, 1.625, 0.5},
					{0.625, 1.375, 0.375, 0.75, 1.5, 0.5},
					{0.5625, 1.3125, 0.375, 0.6875, 1.4375, 0.5},
					{0.5, 1.25, 0.375, 0.625, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.375, 1.0625, 0.375, 0.5, 1.1875, 0.5},
					{0.3125, 1, 0.375, 0.4375, 1.125, 0.5},
					{0.25, 0.9375, 0.375, 0.375, 1.0625, 0.5},
					{0.1875, 0.8125, 0.375, 0.3125, 1, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.0625, 0.6875, 0.375, 0.1875, 0.8125, 0.5},
					{0, 0.625, 0.375, 0.125, 0.75, 0.5},
					{-0.0625, 0.5, 0.375, 0.0625, 0.6875, 0.5},
					{-0.125, 0.4375, 0.375, 0, 0.5625, 0.5},
					{-0.1875, 0.375, 0.375, -0.0625, 0.5, 0.5},
					{-0.25, 0.3125, 0.375, -0.125, 0.4375, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.25, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.5, 0, 0.375, -0.375, 0.125, 0.5},
					{1.375, 2.3125, 0.375, 1.5, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_tall_right_slant_" .. bridge_color, {
			description = bridge_desc .. " Tall Truss Superstructure Right Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_right_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_right_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, 3.375, 0.375, 1.5, 3.5, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 3.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 3.5, 0.5},
					{-0.4375, 3.25, 0.375, -0.3125, 3.375, 0.5},
					{-0.375, 3.125, 0.375, -0.25, 3.3125, 0.5},
					{-0.3125, 3, 0.375, -0.1875, 3.1875, 0.5},
					{-0.25, 2.875, 0.375, -0.125, 3.0625, 0.5},
					{-0.1875, 2.75, 0.375, -0.0625, 2.9375, 0.5},
					{-0.125, 2.625, 0.375, 1.11759e-008, 2.8125, 0.5},
					{-0.0625, 2.5625, 0.375, 0.0625, 2.6875, 0.5},
					{0, 2.4375, 0.375, 0.125, 2.625, 0.5},
					{0.0625, 2.3125, 0.375, 0.1875, 2.5, 0.5},
					{0.125, 2.1875, 0.375, 0.25, 2.375, 0.5},
					{0.1875, 2.0625, 0.375, 0.3125, 2.25, 0.5},
					{0.25, 2, 0.375, 0.375, 2.125, 0.5},
					{0.3125, 1.875, 0.375, 0.4375, 2.0625, 0.5},
					{0.375, 1.75, 0.375, 0.5, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.5, 1.5, 0.375, 0.625, 1.6875, 0.5},
					{0.5625, 1.375, 0.375, 0.6875, 1.5625, 0.5},
					{0.625, 1.3125, 0.375, 0.75, 1.4375, 0.5},
					{0.6875, 1.1875, 0.375, 0.8125, 1.375, 0.5},
					{0.75, 1.0625, 0.375, 0.875, 1.25, 0.5},
					{0.8125, 0.9375, 0.375, 0.9375, 1.125, 0.5},
					{0.875, 0.8125, 0.375, 1, 1, 0.5},
					{0.9375, 0.75, 0.375, 1.0625, 0.875, 0.5},
					{1, 0.625, 0.375, 1.125, 0.8125, 0.5},
					{1.0625, 0.5, 0.375, 1.1875, 0.6875, 0.5},
					{1.125, 0.375, 0.375, 1.25, 0.5625, 0.5},
					{1.1875, 0.25, 0.375, 1.3125, 0.4375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.3125, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_tall_left_slant_" .. bridge_color, {
			description = bridge_desc .. " Tall Truss Superstructure Left Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_left_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_left_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, 3.375, 0.375, 1.5, 3.5, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 3.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 3.5, 0.5},
					{1.3125, 3.25, 0.375, 1.4375, 3.375, 0.5},
					{1.25, 3.125, 0.375, 1.375, 3.3125, 0.5},
					{1.1875, 3, 0.375, 1.3125, 3.1875, 0.5},
					{1.125, 2.875, 0.375, 1.25, 3.0625, 0.5},
					{1.0625, 2.75, 0.375, 1.1875, 2.9375, 0.5},
					{1, 2.625, 0.375, 1.125, 2.8125, 0.5},
					{0.9375, 2.5625, 0.375, 1.0625, 2.6875, 0.5},
					{0.875, 2.4375, 0.375, 1, 2.625, 0.5},
					{0.8125, 2.3125, 0.375, 0.9375, 2.5, 0.5},
					{0.75, 2.1875, 0.375, 0.875, 2.375, 0.5},
					{0.6875, 2.0625, 0.375, 0.8125, 2.25, 0.5},
					{0.625, 2, 0.375, 0.75, 2.125, 0.5},
					{0.5625, 1.875, 0.375, 0.6875, 2.0625, 0.5},
					{0.5, 1.75, 0.375, 0.625, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.375, 1.5, 0.375, 0.5, 1.6875, 0.5},
					{0.3125, 1.375, 0.375, 0.4375, 1.5625, 0.5},
					{0.25, 1.3125, 0.375, 0.375, 1.4375, 0.5},
					{0.1875, 1.1875, 0.375, 0.3125, 1.375, 0.5},
					{0.125, 1.0625, 0.375, 0.25, 1.25, 0.5},
					{0.0625, 0.9375, 0.375, 0.1875, 1.125, 0.5},
					{0, 0.8125, 0.375, 0.125, 1, 0.5},
					{-0.0625, 0.75, 0.375, 0.0625, 0.875, 0.5},
					{-0.125, 0.625, 0.375, -3.35276e-008, 0.8125, 0.5},
					{-0.1875, 0.5, 0.375, -0.0625, 0.6875, 0.5},
					{-0.25, 0.375, 0.375, -0.125, 0.5625, 0.5},
					{-0.3125, 0.25, 0.375, -0.1875, 0.4375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.3125, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_tall_mid_" .. bridge_color, {
			description = bridge_desc .. " Tall Truss Superstructure Middle",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_mid.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_mid.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, 3.375, 0.375, 1.5, 3.5, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 3.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 3.5, 0.5},
					{1.3125, 3.25, 0.375, 1.4375, 3.375, 0.5},
					{1.25, 3.125, 0.375, 1.375, 3.3125, 0.5},
					{1.1875, 3, 0.375, 1.3125, 3.1875, 0.5},
					{1.125, 2.875, 0.375, 1.25, 3.0625, 0.5},
					{1.0625, 2.75, 0.375, 1.1875, 2.9375, 0.5},
					{1, 2.625, 0.375, 1.125, 2.8125, 0.5},
					{0.9375, 2.5625, 0.375, 1.0625, 2.6875, 0.5},
					{0.875, 2.4375, 0.375, 1, 2.625, 0.5},
					{0.8125, 2.3125, 0.375, 0.9375, 2.5, 0.5},
					{0.75, 2.1875, 0.375, 0.875, 2.375, 0.5},
					{0.6875, 2.0625, 0.375, 0.8125, 2.25, 0.5},
					{0.625, 2, 0.375, 0.75, 2.125, 0.5},
					{0.5625, 1.875, 0.375, 0.6875, 2.0625, 0.5},
					{0.5, 1.75, 0.375, 0.625, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.375, 1.5, 0.375, 0.5, 1.6875, 0.5},
					{0.3125, 1.375, 0.375, 0.4375, 1.5625, 0.5},
					{0.25, 1.3125, 0.375, 0.375, 1.4375, 0.5},
					{0.1875, 1.1875, 0.375, 0.3125, 1.375, 0.5},
					{0.125, 1.0625, 0.375, 0.25, 1.25, 0.5},
					{0.0625, 0.9375, 0.375, 0.1875, 1.125, 0.5},
					{0, 0.8125, 0.375, 0.125, 1, 0.5},
					{-0.0625, 0.75, 0.375, 0.0625, 0.875, 0.5},
					{-0.125, 0.625, 0.375, -3.35276e-008, 0.8125, 0.5},
					{-0.1875, 0.5, 0.375, -0.0625, 0.6875, 0.5},
					{-0.25, 0.375, 0.375, -0.125, 0.5625, 0.5},
					{-0.3125, 0.25, 0.375, -0.1875, 0.4375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.3125, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.4375, 3.25, 0.375, -0.3125, 3.375, 0.5},
					{-0.375, 3.125, 0.375, -0.25, 3.3125, 0.5},
					{-0.3125, 3, 0.375, -0.1875, 3.1875, 0.5},
					{-0.25, 2.875, 0.375, -0.125, 3.0625, 0.5},
					{-0.1875, 2.75, 0.375, -0.0625, 2.9375, 0.5},
					{-0.125, 2.625, 0.375, 1.11759e-008, 2.8125, 0.5},
					{-0.0625, 2.5625, 0.375, 0.0625, 2.6875, 0.5},
					{0, 2.4375, 0.375, 0.125, 2.625, 0.5},
					{0.0625, 2.3125, 0.375, 0.1875, 2.5, 0.5},
					{0.125, 2.1875, 0.375, 0.25, 2.375, 0.5},
					{0.1875, 2.0625, 0.375, 0.3125, 2.25, 0.5},
					{0.25, 2, 0.375, 0.375, 2.125, 0.5},
					{0.3125, 1.875, 0.375, 0.4375, 2.0625, 0.5},
					{0.375, 1.75, 0.375, 0.5, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.5, 1.5, 0.375, 0.625, 1.6875, 0.5},
					{0.5625, 1.375, 0.375, 0.6875, 1.5625, 0.5},
					{0.625, 1.3125, 0.375, 0.75, 1.4375, 0.5},
					{0.6875, 1.1875, 0.375, 0.8125, 1.375, 0.5},
					{0.75, 1.0625, 0.375, 0.875, 1.25, 0.5},
					{0.8125, 0.9375, 0.375, 0.9375, 1.125, 0.5},
					{0.875, 0.8125, 0.375, 1, 1, 0.5},
					{0.9375, 0.75, 0.375, 1.0625, 0.875, 0.5},
					{1, 0.625, 0.375, 1.125, 0.8125, 0.5},
					{1.0625, 0.5, 0.375, 1.1875, 0.6875, 0.5},
					{1.125, 0.375, 0.375, 1.25, 0.5625, 0.5},
					{1.1875, 0.25, 0.375, 1.3125, 0.4375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.3125, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_tall_simple_" .. bridge_color, {
			description = bridge_desc .. " Tall Truss Superstructure Middle Simple",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_simple.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_simple.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, 3.375, 0.375, 1.5, 3.5, 0.5},
					{1.3125, 3.25, 0.375, 1.4375, 3.375, 0.5},
					{1.25, 3.125, 0.375, 1.375, 3.3125, 0.5},
					{1.1875, 3, 0.375, 1.3125, 3.1875, 0.5},
					{1.125, 2.875, 0.375, 1.25, 3.0625, 0.5},
					{1.0625, 2.75, 0.375, 1.1875, 2.9375, 0.5},
					{1, 2.625, 0.375, 1.125, 2.8125, 0.5},
					{0.9375, 2.5625, 0.375, 1.0625, 2.6875, 0.5},
					{0.875, 2.4375, 0.375, 1, 2.625, 0.5},
					{0.8125, 2.3125, 0.375, 0.9375, 2.5, 0.5},
					{0.75, 2.1875, 0.375, 0.875, 2.375, 0.5},
					{0.6875, 2.0625, 0.375, 0.8125, 2.25, 0.5},
					{0.625, 2, 0.375, 0.75, 2.125, 0.5},
					{0.5625, 1.875, 0.375, 0.6875, 2.0625, 0.5},
					{0.5, 1.75, 0.375, 0.625, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.375, 1.5, 0.375, 0.5, 1.6875, 0.5},
					{0.3125, 1.375, 0.375, 0.4375, 1.5625, 0.5},
					{0.25, 1.3125, 0.375, 0.375, 1.4375, 0.5},
					{0.1875, 1.1875, 0.375, 0.3125, 1.375, 0.5},
					{0.125, 1.0625, 0.375, 0.25, 1.25, 0.5},
					{0.0625, 0.9375, 0.375, 0.1875, 1.125, 0.5},
					{0, 0.8125, 0.375, 0.125, 1, 0.5},
					{-0.0625, 0.75, 0.375, 0.0625, 0.875, 0.5},
					{-0.125, 0.625, 0.375, -3.35276e-008, 0.8125, 0.5},
					{-0.1875, 0.5, 0.375, -0.0625, 0.6875, 0.5},
					{-0.25, 0.375, 0.375, -0.125, 0.5625, 0.5},
					{-0.3125, 0.25, 0.375, -0.1875, 0.4375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.3125, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.4375, 3.25, 0.375, -0.3125, 3.375, 0.5},
					{-0.375, 3.125, 0.375, -0.25, 3.3125, 0.5},
					{-0.3125, 3, 0.375, -0.1875, 3.1875, 0.5},
					{-0.25, 2.875, 0.375, -0.125, 3.0625, 0.5},
					{-0.1875, 2.75, 0.375, -0.0625, 2.9375, 0.5},
					{-0.125, 2.625, 0.375, 1.11759e-008, 2.8125, 0.5},
					{-0.0625, 2.5625, 0.375, 0.0625, 2.6875, 0.5},
					{0, 2.4375, 0.375, 0.125, 2.625, 0.5},
					{0.0625, 2.3125, 0.375, 0.1875, 2.5, 0.5},
					{0.125, 2.1875, 0.375, 0.25, 2.375, 0.5},
					{0.1875, 2.0625, 0.375, 0.3125, 2.25, 0.5},
					{0.25, 2, 0.375, 0.375, 2.125, 0.5},
					{0.3125, 1.875, 0.375, 0.4375, 2.0625, 0.5},
					{0.375, 1.75, 0.375, 0.5, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.5, 1.5, 0.375, 0.625, 1.6875, 0.5},
					{0.5625, 1.375, 0.375, 0.6875, 1.5625, 0.5},
					{0.625, 1.3125, 0.375, 0.75, 1.4375, 0.5},
					{0.6875, 1.1875, 0.375, 0.8125, 1.375, 0.5},
					{0.75, 1.0625, 0.375, 0.875, 1.25, 0.5},
					{0.8125, 0.9375, 0.375, 0.9375, 1.125, 0.5},
					{0.875, 0.8125, 0.375, 1, 1, 0.5},
					{0.9375, 0.75, 0.375, 1.0625, 0.875, 0.5},
					{1, 0.625, 0.375, 1.125, 0.8125, 0.5},
					{1.0625, 0.5, 0.375, 1.1875, 0.6875, 0.5},
					{1.125, 0.375, 0.375, 1.25, 0.5625, 0.5},
					{1.1875, 0.25, 0.375, 1.3125, 0.4375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.3125, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},

				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_tall_simple_end_left_" .. bridge_color, {
			description = bridge_desc .. " Tall Truss Superstructure Simple Left End",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_simple_end_left.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_simple_end_left.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{0.375, -0.5, 0.375, 0.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_tall_simple_end_right_" .. bridge_color, {
			description = bridge_desc .. " Tall Truss Superstructure Simple Right End",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_simple_end_right.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_tall_simple_end_right.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, -0.375, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_simple_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Middle Simple",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_simple.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_simple.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, 2.375, 0.375, 1.5, 2.5, 0.5},
					{-0.4375, 2.25, 0.375, -0.3125, 2.375, 0.5},
					{-0.375, 2.1875, 0.375, -0.25, 2.3125, 0.5},
					{-0.3125, 2.0625, 0.375, -0.1875, 2.25, 0.5},
					{-0.25, 2, 0.375, -0.125, 2.125, 0.5},
					{-0.1875, 1.9375, 0.375, -0.0625, 2.0625, 0.5},
					{-0.125, 1.875, 0.375, 0, 2, 0.5},
					{-0.0625, 1.75, 0.375, 0.0625, 1.9375, 0.5},
					{0, 1.6875, 0.375, 0.125, 1.8125, 0.5},
					{0.0625, 1.625, 0.375, 0.1875, 1.75, 0.5},
					{0.125, 1.5625, 0.375, 0.25, 1.6875, 0.5},
					{0.1875, 1.4375, 0.375, 0.3125, 1.625, 0.5},
					{0.25, 1.375, 0.375, 0.375, 1.5, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.375, 1.25, 0.375, 0.5, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.5, 1.0625, 0.375, 0.625, 1.1875, 0.5},
					{0.5625, 1, 0.375, 0.6875, 1.125, 0.5},
					{0.625, 0.9375, 0.375, 0.75, 1.0625, 0.5},
					{0.6875, 0.8125, 0.375, 0.8125, 1, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.8125, 0.6875, 0.375, 0.9375, 0.8125, 0.5},
					{0.875, 0.625, 0.375, 1, 0.75, 0.5},
					{0.9375, 0.5, 0.375, 1.0625, 0.6875, 0.5},
					{1, 0.4375, 0.375, 1.125, 0.5625, 0.5},
					{1.0625, 0.375, 0.375, 1.1875, 0.5, 0.5},
					{1.125, 0.3125, 0.375, 1.25, 0.4375, 0.5},
					{1.1875, 0.1875, 0.375, 1.3125, 0.375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.25, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
					{1.375, 0, 0.375, 1.5, 0.125, 0.5},
					{-0.4375, 2.3125, 0.375, -0.3125, 2.4375, 0.5},
					{1.3125, 2.25, 0.375, 1.4375, 2.375, 0.5},
					{1.25, 2.1875, 0.375, 1.375, 2.3125, 0.5},
					{1.1875, 2.0625, 0.375, 1.3125, 2.25, 0.5},
					{1.125, 2, 0.375, 1.25, 2.125, 0.5},
					{1.0625, 1.9375, 0.375, 1.1875, 2.0625, 0.5},
					{1, 1.875, 0.375, 1.125, 2, 0.5},
					{0.9375, 1.75, 0.375, 1.0625, 1.9375, 0.5},
					{0.875, 1.6875, 0.375, 1, 1.8125, 0.5},
					{0.8125, 1.625, 0.375, 0.9375, 1.75, 0.5},
					{0.75, 1.5625, 0.375, 0.875, 1.6875, 0.5},
					{0.6875, 1.4375, 0.375, 0.8125, 1.625, 0.5},
					{0.625, 1.375, 0.375, 0.75, 1.5, 0.5},
					{0.5625, 1.3125, 0.375, 0.6875, 1.4375, 0.5},
					{0.5, 1.25, 0.375, 0.625, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.375, 1.0625, 0.375, 0.5, 1.1875, 0.5},
					{0.3125, 1, 0.375, 0.4375, 1.125, 0.5},
					{0.25, 0.9375, 0.375, 0.375, 1.0625, 0.5},
					{0.1875, 0.8125, 0.375, 0.3125, 1, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.0625, 0.6875, 0.375, 0.1875, 0.8125, 0.5},
					{0, 0.625, 0.375, 0.125, 0.75, 0.5},
					{-0.0625, 0.5, 0.375, 0.0625, 0.6875, 0.5},
					{-0.125, 0.4375, 0.375, 0, 0.5625, 0.5},
					{-0.1875, 0.375, 0.375, -0.0625, 0.5, 0.5},
					{-0.25, 0.3125, 0.375, -0.125, 0.4375, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.25, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.5, 0, 0.375, -0.375, 0.125, 0.5},
					{1.375, 2.3125, 0.375, 1.5, 2.4375, 0.5},
					{-0.5, 2.3125, 0.375, -0.375, 2.4375, 0.5},

				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_simple_end_left_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Simple Left End",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_simple_end_left.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_simple_end_left.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{0.375, -0.5, 0.375, 0.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_simple_end_right_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Simple Right End",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_simple_end_right.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_simple_end_right.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, -0.375, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_up_right_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Up Right Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_up_right_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_up_right_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{1.375, 3.375, 0.375, 1.5, 3.5, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 2.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 3.5, 0.5},
					{1.25, 3.3125, 0.375, 1.375, 3.4375, 0.5},
					{1.125, 3.25, 0.375, 1.25, 3.375, 0.5},
					{1, 3.1875, 0.375, 1.125, 3.3125, 0.5},
					{0.875, 3.125, 0.375, 1, 3.25, 0.5},
					{0.75, 3.0625, 0.375, 0.875, 3.1875, 0.5},
					{0.625, 3, 0.375, 0.75, 3.125, 0.5},
					{0.5, 2.9375, 0.375, 0.625, 3.0625, 0.5},
					{0.375, 2.875, 0.375, 0.5, 3, 0.5},
					{0.25, 2.8125, 0.375, 0.375, 2.9375, 0.5},
					{0.125, 2.75, 0.375, 0.25, 2.875, 0.5},
					{0, 2.6875, 0.375, 0.125, 2.8125, 0.5},
					{-0.125, 2.625, 0.375, -1.2666e-007, 2.75, 0.5},
					{-0.25, 2.5625, 0.375, -0.125, 2.6875, 0.5},
					{-0.375, 2.5, 0.375, -0.25, 2.625, 0.5},
					{-0.5, 2.4375, 0.375, -0.375, 2.5625, 0.5},
					{-0.4375, 2.25, 0.375, -0.3125, 2.375, 0.5},
					{-0.375, 2.1875, 0.375, -0.25, 2.3125, 0.5},
					{-0.3125, 2.0625, 0.375, -0.1875, 2.25, 0.5},
					{-0.25, 2, 0.375, -0.125, 2.125, 0.5},
					{-0.1875, 1.9375, 0.375, -0.0625, 2.0625, 0.5},
					{-0.125, 1.875, 0.375, 0, 2, 0.5},
					{-0.0625, 1.75, 0.375, 0.0625, 1.9375, 0.5},
					{0, 1.6875, 0.375, 0.125, 1.8125, 0.5},
					{0.0625, 1.625, 0.375, 0.1875, 1.75, 0.5},
					{0.125, 1.5625, 0.375, 0.25, 1.6875, 0.5},
					{0.1875, 1.4375, 0.375, 0.3125, 1.625, 0.5},
					{0.25, 1.375, 0.375, 0.375, 1.5, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.375, 1.25, 0.375, 0.5, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.5, 1.0625, 0.375, 0.625, 1.1875, 0.5},
					{0.5625, 1, 0.375, 0.6875, 1.125, 0.5},
					{0.625, 0.9375, 0.375, 0.75, 1.0625, 0.5},
					{0.6875, 0.8125, 0.375, 0.8125, 1, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.8125, 0.6875, 0.375, 0.9375, 0.8125, 0.5},
					{0.875, 0.625, 0.375, 1, 0.75, 0.5},
					{0.9375, 0.5, 0.375, 1.0625, 0.6875, 0.5},
					{1, 0.4375, 0.375, 1.125, 0.5625, 0.5},
					{1.0625, 0.375, 0.375, 1.1875, 0.5, 0.5},
					{1.125, 0.3125, 0.375, 1.25, 0.4375, 0.5},
					{1.1875, 0.1875, 0.375, 1.3125, 0.375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.25, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
					{1.375, 0, 0.375, 1.5, 0.125, 0.5},
					{-0.4375, 2.3125, 0.375, -0.3125, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_up_left_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Up Left Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_up_left_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_up_left_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{1.375, 3.375, 0.375, 1.5, 3.5, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 2.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 3.5, 0.5},
					{1.25, 3.3125, 0.375, 1.375, 3.4375, 0.5},
					{1.125, 3.25, 0.375, 1.25, 3.375, 0.5},
					{1, 3.1875, 0.375, 1.125, 3.3125, 0.5},
					{0.875, 3.125, 0.375, 1, 3.25, 0.5},
					{0.75, 3.0625, 0.375, 0.875, 3.1875, 0.5},
					{0.625, 3, 0.375, 0.75, 3.125, 0.5},
					{0.5, 2.9375, 0.375, 0.625, 3.0625, 0.5},
					{0.375, 2.875, 0.375, 0.5, 3, 0.5},
					{0.25, 2.8125, 0.375, 0.375, 2.9375, 0.5},
					{0.125, 2.75, 0.375, 0.25, 2.875, 0.5},
					{0, 2.6875, 0.375, 0.125, 2.8125, 0.5},
					{-0.125, 2.625, 0.375, -1.2666e-007, 2.75, 0.5},
					{-0.25, 2.5625, 0.375, -0.125, 2.6875, 0.5},
					{-0.375, 2.5, 0.375, -0.25, 2.625, 0.5},
					{-0.5, 2.4375, 0.375, -0.375, 2.5625, 0.5},
					{1.3125, 3.25, 0.375, 1.4375, 3.375, 0.5},
					{1.25, 3.125, 0.375, 1.375, 3.3125, 0.5},
					{1.1875, 3, 0.375, 1.3125, 3.1875, 0.5},
					{1.125, 2.875, 0.375, 1.25, 3.0625, 0.5},
					{1.0625, 2.75, 0.375, 1.1875, 2.9375, 0.5},
					{1, 2.625, 0.375, 1.125, 2.8125, 0.5},
					{0.9375, 2.5625, 0.375, 1.0625, 2.6875, 0.5},
					{0.875, 2.4375, 0.375, 1, 2.625, 0.5},
					{0.8125, 2.3125, 0.375, 0.9375, 2.5, 0.5},
					{0.75, 2.1875, 0.375, 0.875, 2.375, 0.5},
					{0.6875, 2.0625, 0.375, 0.8125, 2.25, 0.5},
					{0.625, 2, 0.375, 0.75, 2.125, 0.5},
					{0.5625, 1.875, 0.375, 0.6875, 2.0625, 0.5},
					{0.5, 1.75, 0.375, 0.625, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.375, 1.5, 0.375, 0.5, 1.6875, 0.5},
					{0.3125, 1.375, 0.375, 0.4375, 1.5625, 0.5},
					{0.25, 1.3125, 0.375, 0.375, 1.4375, 0.5},
					{0.1875, 1.1875, 0.375, 0.3125, 1.375, 0.5},
					{0.125, 1.0625, 0.375, 0.25, 1.25, 0.5},
					{0.0625, 0.9375, 0.375, 0.1875, 1.125, 0.5},
					{0, 0.8125, 0.375, 0.125, 1, 0.5},
					{-0.0625, 0.75, 0.375, 0.0625, 0.875, 0.5},
					{-0.125, 0.625, 0.375, -3.35276e-008, 0.8125, 0.5},
					{-0.1875, 0.5, 0.375, -0.0625, 0.6875, 0.5},
					{-0.25, 0.375, 0.375, -0.125, 0.5625, 0.5},
					{-0.3125, 0.25, 0.375, -0.1875, 0.4375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.3125, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_up_mid_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Up Middle",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_up_mid.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_up_mid.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{1.375, 3.375, 0.375, 1.5, 3.5, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 2.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 3.5, 0.5},
					{1.25, 3.3125, 0.375, 1.375, 3.4375, 0.5},
					{1.125, 3.25, 0.375, 1.25, 3.375, 0.5},
					{1, 3.1875, 0.375, 1.125, 3.3125, 0.5},
					{0.875, 3.125, 0.375, 1, 3.25, 0.5},
					{0.75, 3.0625, 0.375, 0.875, 3.1875, 0.5},
					{0.625, 3, 0.375, 0.75, 3.125, 0.5},
					{0.5, 2.9375, 0.375, 0.625, 3.0625, 0.5},
					{0.375, 2.875, 0.375, 0.5, 3, 0.5},
					{0.25, 2.8125, 0.375, 0.375, 2.9375, 0.5},
					{0.125, 2.75, 0.375, 0.25, 2.875, 0.5},
					{0, 2.6875, 0.375, 0.125, 2.8125, 0.5},
					{-0.125, 2.625, 0.375, -1.2666e-007, 2.75, 0.5},
					{-0.25, 2.5625, 0.375, -0.125, 2.6875, 0.5},
					{-0.375, 2.5, 0.375, -0.25, 2.625, 0.5},
					{-0.5, 2.4375, 0.375, -0.375, 2.5625, 0.5},
					{1.3125, 3.25, 0.375, 1.4375, 3.375, 0.5},
					{1.25, 3.125, 0.375, 1.375, 3.3125, 0.5},
					{1.1875, 3, 0.375, 1.3125, 3.1875, 0.5},
					{1.125, 2.875, 0.375, 1.25, 3.0625, 0.5},
					{1.0625, 2.75, 0.375, 1.1875, 2.9375, 0.5},
					{1, 2.625, 0.375, 1.125, 2.8125, 0.5},
					{0.9375, 2.5625, 0.375, 1.0625, 2.6875, 0.5},
					{0.875, 2.4375, 0.375, 1, 2.625, 0.5},
					{0.8125, 2.3125, 0.375, 0.9375, 2.5, 0.5},
					{0.75, 2.1875, 0.375, 0.875, 2.375, 0.5},
					{0.6875, 2.0625, 0.375, 0.8125, 2.25, 0.5},
					{0.625, 2, 0.375, 0.75, 2.125, 0.5},
					{0.5625, 1.875, 0.375, 0.6875, 2.0625, 0.5},
					{0.5, 1.75, 0.375, 0.625, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.375, 1.5, 0.375, 0.5, 1.6875, 0.5},
					{0.3125, 1.375, 0.375, 0.4375, 1.5625, 0.5},
					{0.25, 1.3125, 0.375, 0.375, 1.4375, 0.5},
					{0.1875, 1.1875, 0.375, 0.3125, 1.375, 0.5},
					{0.125, 1.0625, 0.375, 0.25, 1.25, 0.5},
					{0.0625, 0.9375, 0.375, 0.1875, 1.125, 0.5},
					{0, 0.8125, 0.375, 0.125, 1, 0.5},
					{-0.0625, 0.75, 0.375, 0.0625, 0.875, 0.5},
					{-0.125, 0.625, 0.375, -3.35276e-008, 0.8125, 0.5},
					{-0.1875, 0.5, 0.375, -0.0625, 0.6875, 0.5},
					{-0.25, 0.375, 0.375, -0.125, 0.5625, 0.5},
					{-0.3125, 0.25, 0.375, -0.1875, 0.4375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.3125, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.4375, 2.25, 0.375, -0.3125, 2.375, 0.5},
					{-0.375, 2.1875, 0.375, -0.25, 2.3125, 0.5},
					{-0.3125, 2.0625, 0.375, -0.1875, 2.25, 0.5},
					{-0.25, 2, 0.375, -0.125, 2.125, 0.5},
					{-0.1875, 1.9375, 0.375, -0.0625, 2.0625, 0.5},
					{-0.125, 1.875, 0.375, 0, 2, 0.5},
					{-0.0625, 1.75, 0.375, 0.0625, 1.9375, 0.5},
					{0, 1.6875, 0.375, 0.125, 1.8125, 0.5},
					{0.0625, 1.625, 0.375, 0.1875, 1.75, 0.5},
					{0.125, 1.5625, 0.375, 0.25, 1.6875, 0.5},
					{0.1875, 1.4375, 0.375, 0.3125, 1.625, 0.5},
					{0.25, 1.375, 0.375, 0.375, 1.5, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.375, 1.25, 0.375, 0.5, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.5, 1.0625, 0.375, 0.625, 1.1875, 0.5},
					{0.5625, 1, 0.375, 0.6875, 1.125, 0.5},
					{0.625, 0.9375, 0.375, 0.75, 1.0625, 0.5},
					{0.6875, 0.8125, 0.375, 0.8125, 1, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.8125, 0.6875, 0.375, 0.9375, 0.8125, 0.5},
					{0.875, 0.625, 0.375, 1, 0.75, 0.5},
					{0.9375, 0.5, 0.375, 1.0625, 0.6875, 0.5},
					{1, 0.4375, 0.375, 1.125, 0.5625, 0.5},
					{1.0625, 0.375, 0.375, 1.1875, 0.5, 0.5},
					{1.125, 0.3125, 0.375, 1.25, 0.4375, 0.5},
					{1.1875, 0.1875, 0.375, 1.3125, 0.375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.25, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
					{1.375, 0, 0.375, 1.5, 0.125, 0.5},
					{-0.4375, 2.3125, 0.375, -0.3125, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_up_simple_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Up Simple",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_up_simple.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_up_simple.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{1.375, 3.375, 0.375, 1.5, 3.5, 0.5},
					{1.25, 3.3125, 0.375, 1.375, 3.4375, 0.5},
					{1.125, 3.25, 0.375, 1.25, 3.375, 0.5},
					{1, 3.1875, 0.375, 1.125, 3.3125, 0.5},
					{0.875, 3.125, 0.375, 1, 3.25, 0.5},
					{0.75, 3.0625, 0.375, 0.875, 3.1875, 0.5},
					{0.625, 3, 0.375, 0.75, 3.125, 0.5},
					{0.5, 2.9375, 0.375, 0.625, 3.0625, 0.5},
					{0.375, 2.875, 0.375, 0.5, 3, 0.5},
					{0.25, 2.8125, 0.375, 0.375, 2.9375, 0.5},
					{0.125, 2.75, 0.375, 0.25, 2.875, 0.5},
					{0, 2.6875, 0.375, 0.125, 2.8125, 0.5},
					{-0.125, 2.625, 0.375, -1.2666e-007, 2.75, 0.5},
					{-0.25, 2.5625, 0.375, -0.125, 2.6875, 0.5},
					{-0.375, 2.5, 0.375, -0.25, 2.625, 0.5},
					{-0.5, 2.4375, 0.375, -0.375, 2.5625, 0.5},
					{1.3125, 3.25, 0.375, 1.4375, 3.375, 0.5},
					{1.25, 3.125, 0.375, 1.375, 3.3125, 0.5},
					{1.1875, 3, 0.375, 1.3125, 3.1875, 0.5},
					{1.125, 2.875, 0.375, 1.25, 3.0625, 0.5},
					{1.0625, 2.75, 0.375, 1.1875, 2.9375, 0.5},
					{1, 2.625, 0.375, 1.125, 2.8125, 0.5},
					{0.9375, 2.5625, 0.375, 1.0625, 2.6875, 0.5},
					{0.875, 2.4375, 0.375, 1, 2.625, 0.5},
					{0.8125, 2.3125, 0.375, 0.9375, 2.5, 0.5},
					{0.75, 2.1875, 0.375, 0.875, 2.375, 0.5},
					{0.6875, 2.0625, 0.375, 0.8125, 2.25, 0.5},
					{0.625, 2, 0.375, 0.75, 2.125, 0.5},
					{0.5625, 1.875, 0.375, 0.6875, 2.0625, 0.5},
					{0.5, 1.75, 0.375, 0.625, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.375, 1.5, 0.375, 0.5, 1.6875, 0.5},
					{0.3125, 1.375, 0.375, 0.4375, 1.5625, 0.5},
					{0.25, 1.3125, 0.375, 0.375, 1.4375, 0.5},
					{0.1875, 1.1875, 0.375, 0.3125, 1.375, 0.5},
					{0.125, 1.0625, 0.375, 0.25, 1.25, 0.5},
					{0.0625, 0.9375, 0.375, 0.1875, 1.125, 0.5},
					{0, 0.8125, 0.375, 0.125, 1, 0.5},
					{-0.0625, 0.75, 0.375, 0.0625, 0.875, 0.5},
					{-0.125, 0.625, 0.375, -3.35276e-008, 0.8125, 0.5},
					{-0.1875, 0.5, 0.375, -0.0625, 0.6875, 0.5},
					{-0.25, 0.375, 0.375, -0.125, 0.5625, 0.5},
					{-0.3125, 0.25, 0.375, -0.1875, 0.4375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.3125, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.4375, 2.25, 0.375, -0.3125, 2.375, 0.5},
					{-0.375, 2.1875, 0.375, -0.25, 2.3125, 0.5},
					{-0.3125, 2.0625, 0.375, -0.1875, 2.25, 0.5},
					{-0.25, 2, 0.375, -0.125, 2.125, 0.5},
					{-0.1875, 1.9375, 0.375, -0.0625, 2.0625, 0.5},
					{-0.125, 1.875, 0.375, 0, 2, 0.5},
					{-0.0625, 1.75, 0.375, 0.0625, 1.9375, 0.5},
					{0, 1.6875, 0.375, 0.125, 1.8125, 0.5},
					{0.0625, 1.625, 0.375, 0.1875, 1.75, 0.5},
					{0.125, 1.5625, 0.375, 0.25, 1.6875, 0.5},
					{0.1875, 1.4375, 0.375, 0.3125, 1.625, 0.5},
					{0.25, 1.375, 0.375, 0.375, 1.5, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.375, 1.25, 0.375, 0.5, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.5, 1.0625, 0.375, 0.625, 1.1875, 0.5},
					{0.5625, 1, 0.375, 0.6875, 1.125, 0.5},
					{0.625, 0.9375, 0.375, 0.75, 1.0625, 0.5},
					{0.6875, 0.8125, 0.375, 0.8125, 1, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.8125, 0.6875, 0.375, 0.9375, 0.8125, 0.5},
					{0.875, 0.625, 0.375, 1, 0.75, 0.5},
					{0.9375, 0.5, 0.375, 1.0625, 0.6875, 0.5},
					{1, 0.4375, 0.375, 1.125, 0.5625, 0.5},
					{1.0625, 0.375, 0.375, 1.1875, 0.5, 0.5},
					{1.125, 0.3125, 0.375, 1.25, 0.4375, 0.5},
					{1.1875, 0.1875, 0.375, 1.3125, 0.375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.25, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
					{1.375, 0, 0.375, 1.5, 0.125, 0.5},
					{-0.4375, 2.3125, 0.375, -0.3125, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_down_right_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Down Right Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_down_right_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_down_right_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{1.375, 2.4375, 0.375, 1.5, 2.5625, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 3.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 2.5, 0.5},
					{1.25, 2.5, 0.375, 1.375, 2.625, 0.5},
					{1.125, 2.5625, 0.375, 1.25, 2.6875, 0.5},
					{1, 2.625, 0.375, 1.125, 2.75, 0.5},
					{0.875, 2.6875, 0.375, 1, 2.8125, 0.5},
					{0.75, 2.75, 0.375, 0.875, 2.875, 0.5},
					{0.625, 2.8125, 0.375, 0.75, 2.9375, 0.5},
					{0.5, 2.875, 0.375, 0.625, 3, 0.5},
					{0.375, 2.9375, 0.375, 0.5, 3.0625, 0.5},
					{0.25, 3, 0.375, 0.375, 3.125, 0.5},
					{0.125, 3.0625, 0.375, 0.25, 3.1875, 0.5},
					{0, 3.125, 0.375, 0.125, 3.25, 0.5},
					{-0.125, 3.1875, 0.375, -1.2666e-007, 3.3125, 0.5},
					{-0.25, 3.25, 0.375, -0.125, 3.375, 0.5},
					{-0.375, 3.3125, 0.375, -0.25, 3.4375, 0.5},
					{-0.5, 3.375, 0.375, -0.375, 3.5, 0.5},
					{-0.4375, 3.25, 0.375, -0.3125, 3.375, 0.5},
					{-0.375, 3.125, 0.375, -0.25, 3.3125, 0.5},
					{-0.3125, 3, 0.375, -0.1875, 3.1875, 0.5},
					{-0.25, 2.875, 0.375, -0.125, 3.0625, 0.5},
					{-0.1875, 2.75, 0.375, -0.0625, 2.9375, 0.5},
					{-0.125, 2.625, 0.375, 1.11759e-008, 2.8125, 0.5},
					{-0.0625, 2.5625, 0.375, 0.0625, 2.6875, 0.5},
					{0, 2.4375, 0.375, 0.125, 2.625, 0.5},
					{0.0625, 2.3125, 0.375, 0.1875, 2.5, 0.5},
					{0.125, 2.1875, 0.375, 0.25, 2.375, 0.5},
					{0.1875, 2.0625, 0.375, 0.3125, 2.25, 0.5},
					{0.25, 2, 0.375, 0.375, 2.125, 0.5},
					{0.3125, 1.875, 0.375, 0.4375, 2.0625, 0.5},
					{0.375, 1.75, 0.375, 0.5, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.5, 1.5, 0.375, 0.625, 1.6875, 0.5},
					{0.5625, 1.375, 0.375, 0.6875, 1.5625, 0.5},
					{0.625, 1.3125, 0.375, 0.75, 1.4375, 0.5},
					{0.6875, 1.1875, 0.375, 0.8125, 1.375, 0.5},
					{0.75, 1.0625, 0.375, 0.875, 1.25, 0.5},
					{0.8125, 0.9375, 0.375, 0.9375, 1.125, 0.5},
					{0.875, 0.8125, 0.375, 1, 1, 0.5},
					{0.9375, 0.75, 0.375, 1.0625, 0.875, 0.5},
					{1, 0.625, 0.375, 1.125, 0.8125, 0.5},
					{1.0625, 0.5, 0.375, 1.1875, 0.6875, 0.5},
					{1.125, 0.375, 0.375, 1.25, 0.5625, 0.5},
					{1.1875, 0.25, 0.375, 1.3125, 0.4375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.3125, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_down_left_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Down Left Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_down_left_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_down_left_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{1.375, 2.4375, 0.375, 1.5, 2.5625, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 3.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 2.5, 0.5},
					{1.25, 2.5, 0.375, 1.375, 2.625, 0.5},
					{1.125, 2.5625, 0.375, 1.25, 2.6875, 0.5},
					{1, 2.625, 0.375, 1.125, 2.75, 0.5},
					{0.875, 2.6875, 0.375, 1, 2.8125, 0.5},
					{0.75, 2.75, 0.375, 0.875, 2.875, 0.5},
					{0.625, 2.8125, 0.375, 0.75, 2.9375, 0.5},
					{0.5, 2.875, 0.375, 0.625, 3, 0.5},
					{0.375, 2.9375, 0.375, 0.5, 3.0625, 0.5},
					{0.25, 3, 0.375, 0.375, 3.125, 0.5},
					{0.125, 3.0625, 0.375, 0.25, 3.1875, 0.5},
					{0, 3.125, 0.375, 0.125, 3.25, 0.5},
					{-0.125, 3.1875, 0.375, -1.2666e-007, 3.3125, 0.5},
					{-0.25, 3.25, 0.375, -0.125, 3.375, 0.5},
					{-0.375, 3.3125, 0.375, -0.25, 3.4375, 0.5},
					{-0.5, 3.375, 0.375, -0.375, 3.5, 0.5},
					{1.3125, 2.25, 0.375, 1.4375, 2.375, 0.5},
					{1.25, 2.1875, 0.375, 1.375, 2.3125, 0.5},
					{1.1875, 2.0625, 0.375, 1.3125, 2.25, 0.5},
					{1.125, 2, 0.375, 1.25, 2.125, 0.5},
					{1.0625, 1.9375, 0.375, 1.1875, 2.0625, 0.5},
					{1, 1.875, 0.375, 1.125, 2, 0.5},
					{0.9375, 1.75, 0.375, 1.0625, 1.9375, 0.5},
					{0.875, 1.6875, 0.375, 1, 1.8125, 0.5},
					{0.8125, 1.625, 0.375, 0.9375, 1.75, 0.5},
					{0.75, 1.5625, 0.375, 0.875, 1.6875, 0.5},
					{0.6875, 1.4375, 0.375, 0.8125, 1.625, 0.5},
					{0.625, 1.375, 0.375, 0.75, 1.5, 0.5},
					{0.5625, 1.3125, 0.375, 0.6875, 1.4375, 0.5},
					{0.5, 1.25, 0.375, 0.625, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.375, 1.0625, 0.375, 0.5, 1.1875, 0.5},
					{0.3125, 1, 0.375, 0.4375, 1.125, 0.5},
					{0.25, 0.9375, 0.375, 0.375, 1.0625, 0.5},
					{0.1875, 0.8125, 0.375, 0.3125, 1, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.0625, 0.6875, 0.375, 0.1875, 0.8125, 0.5},
					{0, 0.625, 0.375, 0.125, 0.75, 0.5},
					{-0.0625, 0.5, 0.375, 0.0625, 0.6875, 0.5},
					{-0.125, 0.4375, 0.375, 0, 0.5625, 0.5},
					{-0.1875, 0.375, 0.375, -0.0625, 0.5, 0.5},
					{-0.25, 0.3125, 0.375, -0.125, 0.4375, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.25, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.5, 0, 0.375, -0.375, 0.125, 0.5},
					{1.375, 2.3125, 0.375, 1.5, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_down_mid_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Down Middle",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_down_mid.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_down_mid.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{1.375, 2.4375, 0.375, 1.5, 2.5625, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 3.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 2.5, 0.5},
					{1.25, 2.5, 0.375, 1.375, 2.625, 0.5},
					{1.125, 2.5625, 0.375, 1.25, 2.6875, 0.5},
					{1, 2.625, 0.375, 1.125, 2.75, 0.5},
					{0.875, 2.6875, 0.375, 1, 2.8125, 0.5},
					{0.75, 2.75, 0.375, 0.875, 2.875, 0.5},
					{0.625, 2.8125, 0.375, 0.75, 2.9375, 0.5},
					{0.5, 2.875, 0.375, 0.625, 3, 0.5},
					{0.375, 2.9375, 0.375, 0.5, 3.0625, 0.5},
					{0.25, 3, 0.375, 0.375, 3.125, 0.5},
					{0.125, 3.0625, 0.375, 0.25, 3.1875, 0.5},
					{0, 3.125, 0.375, 0.125, 3.25, 0.5},
					{-0.125, 3.1875, 0.375, -1.2666e-007, 3.3125, 0.5},
					{-0.25, 3.25, 0.375, -0.125, 3.375, 0.5},
					{-0.375, 3.3125, 0.375, -0.25, 3.4375, 0.5},
					{-0.5, 3.375, 0.375, -0.375, 3.5, 0.5},
					{1.3125, 2.25, 0.375, 1.4375, 2.375, 0.5},
					{1.25, 2.1875, 0.375, 1.375, 2.3125, 0.5},
					{1.1875, 2.0625, 0.375, 1.3125, 2.25, 0.5},
					{1.125, 2, 0.375, 1.25, 2.125, 0.5},
					{1.0625, 1.9375, 0.375, 1.1875, 2.0625, 0.5},
					{1, 1.875, 0.375, 1.125, 2, 0.5},
					{0.9375, 1.75, 0.375, 1.0625, 1.9375, 0.5},
					{0.875, 1.6875, 0.375, 1, 1.8125, 0.5},
					{0.8125, 1.625, 0.375, 0.9375, 1.75, 0.5},
					{0.75, 1.5625, 0.375, 0.875, 1.6875, 0.5},
					{0.6875, 1.4375, 0.375, 0.8125, 1.625, 0.5},
					{0.625, 1.375, 0.375, 0.75, 1.5, 0.5},
					{0.5625, 1.3125, 0.375, 0.6875, 1.4375, 0.5},
					{0.5, 1.25, 0.375, 0.625, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.375, 1.0625, 0.375, 0.5, 1.1875, 0.5},
					{0.3125, 1, 0.375, 0.4375, 1.125, 0.5},
					{0.25, 0.9375, 0.375, 0.375, 1.0625, 0.5},
					{0.1875, 0.8125, 0.375, 0.3125, 1, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.0625, 0.6875, 0.375, 0.1875, 0.8125, 0.5},
					{0, 0.625, 0.375, 0.125, 0.75, 0.5},
					{-0.0625, 0.5, 0.375, 0.0625, 0.6875, 0.5},
					{-0.125, 0.4375, 0.375, 0, 0.5625, 0.5},
					{-0.1875, 0.375, 0.375, -0.0625, 0.5, 0.5},
					{-0.25, 0.3125, 0.375, -0.125, 0.4375, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.25, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.5, 0, 0.375, -0.375, 0.125, 0.5},
					{1.375, 2.3125, 0.375, 1.5, 2.4375, 0.5},
					{-0.4375, 3.25, 0.375, -0.3125, 3.375, 0.5},
					{-0.375, 3.125, 0.375, -0.25, 3.3125, 0.5},
					{-0.3125, 3, 0.375, -0.1875, 3.1875, 0.5},
					{-0.25, 2.875, 0.375, -0.125, 3.0625, 0.5},
					{-0.1875, 2.75, 0.375, -0.0625, 2.9375, 0.5},
					{-0.125, 2.625, 0.375, 1.11759e-008, 2.8125, 0.5},
					{-0.0625, 2.5625, 0.375, 0.0625, 2.6875, 0.5},
					{0, 2.4375, 0.375, 0.125, 2.625, 0.5},
					{0.0625, 2.3125, 0.375, 0.1875, 2.5, 0.5},
					{0.125, 2.1875, 0.375, 0.25, 2.375, 0.5},
					{0.1875, 2.0625, 0.375, 0.3125, 2.25, 0.5},
					{0.25, 2, 0.375, 0.375, 2.125, 0.5},
					{0.3125, 1.875, 0.375, 0.4375, 2.0625, 0.5},
					{0.375, 1.75, 0.375, 0.5, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.5, 1.5, 0.375, 0.625, 1.6875, 0.5},
					{0.5625, 1.375, 0.375, 0.6875, 1.5625, 0.5},
					{0.625, 1.3125, 0.375, 0.75, 1.4375, 0.5},
					{0.6875, 1.1875, 0.375, 0.8125, 1.375, 0.5},
					{0.75, 1.0625, 0.375, 0.875, 1.25, 0.5},
					{0.8125, 0.9375, 0.375, 0.9375, 1.125, 0.5},
					{0.875, 0.8125, 0.375, 1, 1, 0.5},
					{0.9375, 0.75, 0.375, 1.0625, 0.875, 0.5},
					{1, 0.625, 0.375, 1.125, 0.8125, 0.5},
					{1.0625, 0.5, 0.375, 1.1875, 0.6875, 0.5},
					{1.125, 0.375, 0.375, 1.25, 0.5625, 0.5},
					{1.1875, 0.25, 0.375, 1.3125, 0.4375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.3125, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_down_simple_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Down Simple",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_down_simple.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_superstructure_down_simple.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{1.375, 2.4375, 0.375, 1.5, 2.5625, 0.5},
					{1.25, 2.5, 0.375, 1.375, 2.625, 0.5},
					{1.125, 2.5625, 0.375, 1.25, 2.6875, 0.5},
					{1, 2.625, 0.375, 1.125, 2.75, 0.5},
					{0.875, 2.6875, 0.375, 1, 2.8125, 0.5},
					{0.75, 2.75, 0.375, 0.875, 2.875, 0.5},
					{0.625, 2.8125, 0.375, 0.75, 2.9375, 0.5},
					{0.5, 2.875, 0.375, 0.625, 3, 0.5},
					{0.375, 2.9375, 0.375, 0.5, 3.0625, 0.5},
					{0.25, 3, 0.375, 0.375, 3.125, 0.5},
					{0.125, 3.0625, 0.375, 0.25, 3.1875, 0.5},
					{0, 3.125, 0.375, 0.125, 3.25, 0.5},
					{-0.125, 3.1875, 0.375, -1.2666e-007, 3.3125, 0.5},
					{-0.25, 3.25, 0.375, -0.125, 3.375, 0.5},
					{-0.375, 3.3125, 0.375, -0.25, 3.4375, 0.5},
					{-0.5, 3.375, 0.375, -0.375, 3.5, 0.5},
					{1.3125, 2.25, 0.375, 1.4375, 2.375, 0.5},
					{1.25, 2.1875, 0.375, 1.375, 2.3125, 0.5},
					{1.1875, 2.0625, 0.375, 1.3125, 2.25, 0.5},
					{1.125, 2, 0.375, 1.25, 2.125, 0.5},
					{1.0625, 1.9375, 0.375, 1.1875, 2.0625, 0.5},
					{1, 1.875, 0.375, 1.125, 2, 0.5},
					{0.9375, 1.75, 0.375, 1.0625, 1.9375, 0.5},
					{0.875, 1.6875, 0.375, 1, 1.8125, 0.5},
					{0.8125, 1.625, 0.375, 0.9375, 1.75, 0.5},
					{0.75, 1.5625, 0.375, 0.875, 1.6875, 0.5},
					{0.6875, 1.4375, 0.375, 0.8125, 1.625, 0.5},
					{0.625, 1.375, 0.375, 0.75, 1.5, 0.5},
					{0.5625, 1.3125, 0.375, 0.6875, 1.4375, 0.5},
					{0.5, 1.25, 0.375, 0.625, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.375, 1.0625, 0.375, 0.5, 1.1875, 0.5},
					{0.3125, 1, 0.375, 0.4375, 1.125, 0.5},
					{0.25, 0.9375, 0.375, 0.375, 1.0625, 0.5},
					{0.1875, 0.8125, 0.375, 0.3125, 1, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.0625, 0.6875, 0.375, 0.1875, 0.8125, 0.5},
					{0, 0.625, 0.375, 0.125, 0.75, 0.5},
					{-0.0625, 0.5, 0.375, 0.0625, 0.6875, 0.5},
					{-0.125, 0.4375, 0.375, 0, 0.5625, 0.5},
					{-0.1875, 0.375, 0.375, -0.0625, 0.5, 0.5},
					{-0.25, 0.3125, 0.375, -0.125, 0.4375, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.25, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.5, 0, 0.375, -0.375, 0.125, 0.5},
					{1.375, 2.3125, 0.375, 1.5, 2.4375, 0.5},
					{-0.4375, 3.25, 0.375, -0.3125, 3.375, 0.5},
					{-0.375, 3.125, 0.375, -0.25, 3.3125, 0.5},
					{-0.3125, 3, 0.375, -0.1875, 3.1875, 0.5},
					{-0.25, 2.875, 0.375, -0.125, 3.0625, 0.5},
					{-0.1875, 2.75, 0.375, -0.0625, 2.9375, 0.5},
					{-0.125, 2.625, 0.375, 1.11759e-008, 2.8125, 0.5},
					{-0.0625, 2.5625, 0.375, 0.0625, 2.6875, 0.5},
					{0, 2.4375, 0.375, 0.125, 2.625, 0.5},
					{0.0625, 2.3125, 0.375, 0.1875, 2.5, 0.5},
					{0.125, 2.1875, 0.375, 0.25, 2.375, 0.5},
					{0.1875, 2.0625, 0.375, 0.3125, 2.25, 0.5},
					{0.25, 2, 0.375, 0.375, 2.125, 0.5},
					{0.3125, 1.875, 0.375, 0.4375, 2.0625, 0.5},
					{0.375, 1.75, 0.375, 0.5, 1.9375, 0.5},
					{0.4375, 1.625, 0.375, 0.5625, 1.8125, 0.5},
					{0.5, 1.5, 0.375, 0.625, 1.6875, 0.5},
					{0.5625, 1.375, 0.375, 0.6875, 1.5625, 0.5},
					{0.625, 1.3125, 0.375, 0.75, 1.4375, 0.5},
					{0.6875, 1.1875, 0.375, 0.8125, 1.375, 0.5},
					{0.75, 1.0625, 0.375, 0.875, 1.25, 0.5},
					{0.8125, 0.9375, 0.375, 0.9375, 1.125, 0.5},
					{0.875, 0.8125, 0.375, 1, 1, 0.5},
					{0.9375, 0.75, 0.375, 1.0625, 0.875, 0.5},
					{1, 0.625, 0.375, 1.125, 0.8125, 0.5},
					{1.0625, 0.5, 0.375, 1.1875, 0.6875, 0.5},
					{1.125, 0.375, 0.375, 1.25, 0.5625, 0.5},
					{1.1875, 0.25, 0.375, 1.3125, 0.4375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.3125, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 3.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_substructure_end_right_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Substructure End Right Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_substructure_end_right_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_substructure_end_right_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, 1.375, 0.375, 1.5, 1.5, 0.5},
					{-0.4375, 1.3125, 0.375, -0.3125, 1.4375, 0.5},
					{-0.375, 1.25, 0.375, -0.25, 1.375, 0.5},
					{-0.3125, 1.1875, 0.375, -0.1875, 1.3125, 0.5},
					{-0.25, 1.125, 0.375, -0.125, 1.25, 0.5},
					{-0.1875, 1.0625, 0.375, -0.0625, 1.1875, 0.5},
					{-0.125, 1, 0.375, 0, 1.125, 0.5},
					{-0.0625, 0.9375, 0.375, 0.0625, 1.0625, 0.5},
					{0, 0.875, 0.375, 0.125, 1, 0.5},
					{0.0625, 0.8125, 0.375, 0.1875, 0.9375, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.1875, 0.6875, 0.375, 0.3125, 0.8125, 0.5},
					{0.25, 0.625, 0.375, 0.375, 0.75, 0.5},
					{0.3125, 0.5625, 0.375, 0.4375, 0.6875, 0.5},
					{0.375, 0.5, 0.375, 0.5, 0.625, 0.5},
					{0.4375, 0.4375, 0.375, 0.5625, 0.5625, 0.5},
					{0.5, 0.375, 0.375, 0.625, 0.5, 0.5},
					{0.5625, 0.3125, 0.375, 0.6875, 0.4375, 0.5},
					{0.625, 0.25, 0.375, 0.75, 0.375, 0.5},
					{0.6875, 0.1875, 0.375, 0.8125, 0.3125, 0.5},
					{0.75, 0.125, 0.375, 0.875, 0.25, 0.5},
					{0.8125, 0.0625, 0.375, 0.9375, 0.1875, 0.5},
					{0.875, 0, 0.375, 1, 0.125, 0.5},
					{0.9375, -0.0625, 0.375, 1.0625, 0.0625, 0.5},
					{1, -0.125, 0.375, 1.125, 0, 0.5},
					{1.0625, -0.1875, 0.375, 1.1875, -0.0625, 0.5},
					{1.125, -0.25, 0.375, 1.25, -0.125, 0.5},
					{1.1875, -0.3125, 0.375, 1.3125, -0.1875, 0.5},
					{1.25, -0.375, 0.375, 1.375, -0.25, 0.5},
					{1.3125, -0.4375, 0.375, 1.4375, -0.3125, 0.5},
					{1.375, -0.5, 0.375, 1.5, -0.375, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_substructure_end_left_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Substructure End Left Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color ..
				".png^bridges_substructure_end_left_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color ..
				".png^bridges_substructure_end_left_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, 1.375, 0.375, 1.5, 1.5, 0.5},
					{1.3125, 1.3125, 0.375, 1.4375, 1.4375, 0.5},
					{1.25, 1.25, 0.375, 1.375, 1.375, 0.5},
					{1.1875, 1.1875, 0.375, 1.3125, 1.3125, 0.5},
					{1.125, 1.125, 0.375, 1.25, 1.25, 0.5},
					{1.0625, 1.0625, 0.375, 1.1875, 1.1875, 0.5},
					{1, 1, 0.375, 1.125, 1.125, 0.5},
					{0.9375, 0.9375, 0.375, 1.0625, 1.0625, 0.5},
					{0.875, 0.875, 0.375, 1, 1, 0.5},
					{0.8125, 0.8125, 0.375, 0.9375, 0.9375, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.6875, 0.6875, 0.375, 0.8125, 0.8125, 0.5},
					{0.625, 0.625, 0.375, 0.75, 0.75, 0.5},
					{0.5625, 0.5625, 0.375, 0.6875, 0.6875, 0.5},
					{0.5, 0.5, 0.375, 0.625, 0.625, 0.5},
					{0.4375, 0.4375, 0.375, 0.5625, 0.5625, 0.5},
					{0.375, 0.375, 0.375, 0.5, 0.5, 0.5},
					{0.3125, 0.3125, 0.375, 0.4375, 0.4375, 0.5},
					{0.25, 0.25, 0.375, 0.375, 0.375, 0.5},
					{0.1875, 0.1875, 0.375, 0.3125, 0.3125, 0.5},
					{0.125, 0.125, 0.375, 0.25, 0.25, 0.5},
					{0.0625, 0.0625, 0.375, 0.1875, 0.1875, 0.5},
					{0, 0, 0.375, 0.125, 0.125, 0.5},
					{-0.0625, -0.0625, 0.375, 0.0625, 0.0625, 0.5},
					{-0.125, -0.125, 0.375, 0, 0, 0.5},
					{-0.1875, -0.1875, 0.375, -0.0625, -0.0625, 0.5},
					{-0.25, -0.25, 0.375, -0.125, -0.125, 0.5},
					{-0.3125, -0.3125, 0.375, -0.1875, -0.1875, 0.5},
					{-0.375, -0.375, 0.375, -0.25, -0.25, 0.5},
					{-0.4375, -0.4375, 0.375, -0.3125, -0.3125, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 1.5, 0.5},
					{-0.5, -0.5, 0.375, -0.375, -0.375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_substructure_right_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Substructure Right Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_substructure_right_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_substructure_right_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, 1.375, 0.375, 1.5, 1.5, 0.5},
					{-0.4375, 1.3125, 0.375, -0.3125, 1.4375, 0.5},
					{-0.375, 1.25, 0.375, -0.25, 1.375, 0.5},
					{-0.3125, 1.1875, 0.375, -0.1875, 1.3125, 0.5},
					{-0.25, 1.125, 0.375, -0.125, 1.25, 0.5},
					{-0.1875, 1.0625, 0.375, -0.0625, 1.1875, 0.5},
					{-0.125, 1, 0.375, 0, 1.125, 0.5},
					{-0.0625, 0.9375, 0.375, 0.0625, 1.0625, 0.5},
					{0, 0.875, 0.375, 0.125, 1, 0.5},
					{0.0625, 0.8125, 0.375, 0.1875, 0.9375, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.1875, 0.6875, 0.375, 0.3125, 0.8125, 0.5},
					{0.25, 0.625, 0.375, 0.375, 0.75, 0.5},
					{0.3125, 0.5625, 0.375, 0.4375, 0.6875, 0.5},
					{0.375, 0.5, 0.375, 0.5, 0.625, 0.5},
					{0.4375, 0.4375, 0.375, 0.5625, 0.5625, 0.5},
					{0.5, 0.375, 0.375, 0.625, 0.5, 0.5},
					{0.5625, 0.3125, 0.375, 0.6875, 0.4375, 0.5},
					{0.625, 0.25, 0.375, 0.75, 0.375, 0.5},
					{0.6875, 0.1875, 0.375, 0.8125, 0.3125, 0.5},
					{0.75, 0.125, 0.375, 0.875, 0.25, 0.5},
					{0.8125, 0.0625, 0.375, 0.9375, 0.1875, 0.5},
					{0.875, 0, 0.375, 1, 0.125, 0.5},
					{0.9375, -0.0625, 0.375, 1.0625, 0.0625, 0.5},
					{1, -0.125, 0.375, 1.125, 0, 0.5},
					{1.0625, -0.1875, 0.375, 1.1875, -0.0625, 0.5},
					{1.125, -0.25, 0.375, 1.25, -0.125, 0.5},
					{1.1875, -0.3125, 0.375, 1.3125, -0.1875, 0.5},
					{1.25, -0.375, 0.375, 1.375, -0.25, 0.5},
					{1.3125, -0.4375, 0.375, 1.4375, -0.3125, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 1.5, 0.5},
					{-0.5, -0.5, 0.375, 1.5, -0.375, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_substructure_left_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Substructure Left Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_substructure_left_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_substructure_left_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, 1.375, 0.375, 1.5, 1.5, 0.5},
					{1.3125, 1.3125, 0.375, 1.4375, 1.4375, 0.5},
					{1.25, 1.25, 0.375, 1.375, 1.375, 0.5},
					{1.1875, 1.1875, 0.375, 1.3125, 1.3125, 0.5},
					{1.125, 1.125, 0.375, 1.25, 1.25, 0.5},
					{1.0625, 1.0625, 0.375, 1.1875, 1.1875, 0.5},
					{1, 1, 0.375, 1.125, 1.125, 0.5},
					{0.9375, 0.9375, 0.375, 1.0625, 1.0625, 0.5},
					{0.875, 0.875, 0.375, 1, 1, 0.5},
					{0.8125, 0.8125, 0.375, 0.9375, 0.9375, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.6875, 0.6875, 0.375, 0.8125, 0.8125, 0.5},
					{0.625, 0.625, 0.375, 0.75, 0.75, 0.5},
					{0.5625, 0.5625, 0.375, 0.6875, 0.6875, 0.5},
					{0.5, 0.5, 0.375, 0.625, 0.625, 0.5},
					{0.4375, 0.4375, 0.375, 0.5625, 0.5625, 0.5},
					{0.375, 0.375, 0.375, 0.5, 0.5, 0.5},
					{0.3125, 0.3125, 0.375, 0.4375, 0.4375, 0.5},
					{0.25, 0.25, 0.375, 0.375, 0.375, 0.5},
					{0.1875, 0.1875, 0.375, 0.3125, 0.3125, 0.5},
					{0.125, 0.125, 0.375, 0.25, 0.25, 0.5},
					{0.0625, 0.0625, 0.375, 0.1875, 0.1875, 0.5},
					{0, 0, 0.375, 0.125, 0.125, 0.5},
					{-0.0625, -0.0625, 0.375, 0.0625, 0.0625, 0.5},
					{-0.125, -0.125, 0.375, 0, 0, 0.5},
					{-0.1875, -0.1875, 0.375, -0.0625, -0.0625, 0.5},
					{-0.25, -0.25, 0.375, -0.125, -0.125, 0.5},
					{-0.3125, -0.3125, 0.375, -0.1875, -0.1875, 0.5},
					{-0.375, -0.375, 0.375, -0.25, -0.25, 0.5},
					{-0.4375, -0.4375, 0.375, -0.3125, -0.3125, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 1.5, 0.5},
					{-0.5, -0.5, 0.375, 1.5, -0.375, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 1.5, 0.5},
					{-0.5, -0.5, 0.375, -0.375, -0.375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_substructure_simple_" .. bridge_color, {
			description = bridge_desc .. " Truss Substructure Simple",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_substructure_simple.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_substructure_simple.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, -0.375, 0.5},
					{-0.5, 1.375, 0.375, 1.5, 1.5, 0.5},
					{-0.4375, 1.3125, 0.375, -0.3125, 1.4375, 0.5},
					{-0.375, 1.25, 0.375, -0.25, 1.375, 0.5},
					{-0.3125, 1.1875, 0.375, -0.1875, 1.3125, 0.5},
					{-0.25, 1.125, 0.375, -0.125, 1.25, 0.5},
					{-0.1875, 1.0625, 0.375, -0.0625, 1.1875, 0.5},
					{-0.125, 1, 0.375, 0, 1.125, 0.5},
					{-0.0625, 0.9375, 0.375, 0.0625, 1.0625, 0.5},
					{0, 0.875, 0.375, 0.125, 1, 0.5},
					{0.0625, 0.8125, 0.375, 0.1875, 0.9375, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.1875, 0.6875, 0.375, 0.3125, 0.8125, 0.5},
					{0.25, 0.625, 0.375, 0.375, 0.75, 0.5},
					{0.3125, 0.5625, 0.375, 0.4375, 0.6875, 0.5},
					{0.375, 0.5, 0.375, 0.5, 0.625, 0.5},
					{0.4375, 0.4375, 0.375, 0.5625, 0.5625, 0.5},
					{0.5, 0.375, 0.375, 0.625, 0.5, 0.5},
					{0.5625, 0.3125, 0.375, 0.6875, 0.4375, 0.5},
					{0.625, 0.25, 0.375, 0.75, 0.375, 0.5},
					{0.6875, 0.1875, 0.375, 0.8125, 0.3125, 0.5},
					{0.75, 0.125, 0.375, 0.875, 0.25, 0.5},
					{0.8125, 0.0625, 0.375, 0.9375, 0.1875, 0.5},
					{0.875, 0, 0.375, 1, 0.125, 0.5},
					{0.9375, -0.0625, 0.375, 1.0625, 0.0625, 0.5},
					{1, -0.125, 0.375, 1.125, 0, 0.5},
					{1.0625, -0.1875, 0.375, 1.1875, -0.0625, 0.5},
					{1.125, -0.25, 0.375, 1.25, -0.125, 0.5},
					{1.1875, -0.3125, 0.375, 1.3125, -0.1875, 0.5},
					{1.25, -0.375, 0.375, 1.375, -0.25, 0.5},
					{1.3125, -0.4375, 0.375, 1.4375, -0.3125, 0.5},
					{1.3125, 1.3125, 0.375, 1.4375, 1.4375, 0.5},
					{1.25, 1.25, 0.375, 1.375, 1.375, 0.5},
					{1.1875, 1.1875, 0.375, 1.3125, 1.3125, 0.5},
					{1.125, 1.125, 0.375, 1.25, 1.25, 0.5},
					{1.0625, 1.0625, 0.375, 1.1875, 1.1875, 0.5},
					{1, 1, 0.375, 1.125, 1.125, 0.5},
					{0.9375, 0.9375, 0.375, 1.0625, 1.0625, 0.5},
					{0.875, 0.875, 0.375, 1, 1, 0.5},
					{0.8125, 0.8125, 0.375, 0.9375, 0.9375, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.6875, 0.6875, 0.375, 0.8125, 0.8125, 0.5},
					{0.625, 0.625, 0.375, 0.75, 0.75, 0.5},
					{0.5625, 0.5625, 0.375, 0.6875, 0.6875, 0.5},
					{0.375, 0.375, 0.375, 0.625, 0.625, 0.5},
					{0.3125, 0.3125, 0.375, 0.4375, 0.4375, 0.5},
					{0.25, 0.25, 0.375, 0.375, 0.375, 0.5},
					{0.1875, 0.1875, 0.375, 0.3125, 0.3125, 0.5},
					{0.125, 0.125, 0.375, 0.25, 0.25, 0.5},
					{0.0625, 0.0625, 0.375, 0.1875, 0.1875, 0.5},
					{0, 0, 0.375, 0.125, 0.125, 0.5},
					{-0.0625, -0.0625, 0.375, 0.0625, 0.0625, 0.5},
					{-0.125, -0.125, 0.375, 0, 0, 0.5},
					{-0.1875, -0.1875, 0.375, -0.0625, -0.0625, 0.5},
					{-0.25, -0.25, 0.375, -0.125, -0.125, 0.5},
					{-0.3125, -0.3125, 0.375, -0.1875, -0.1875, 0.5},
					{-0.375, -0.375, 0.375, -0.25, -0.25, 0.5},
					{-0.4375, -0.4375, 0.375, -0.3125, -0.3125, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_substructure_mid_" .. bridge_color, {
			description = bridge_desc .. " Truss Substructure Middle",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_substructure_mid.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_substructure_mid.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, -0.375, 0.5},
					{-0.5, 1.375, 0.375, 1.5, 1.5, 0.5},
					{-0.4375, 1.3125, 0.375, -0.3125, 1.4375, 0.5},
					{-0.375, 1.25, 0.375, -0.25, 1.375, 0.5},
					{-0.3125, 1.1875, 0.375, -0.1875, 1.3125, 0.5},
					{-0.25, 1.125, 0.375, -0.125, 1.25, 0.5},
					{-0.1875, 1.0625, 0.375, -0.0625, 1.1875, 0.5},
					{-0.125, 1, 0.375, 0, 1.125, 0.5},
					{-0.0625, 0.9375, 0.375, 0.0625, 1.0625, 0.5},
					{0, 0.875, 0.375, 0.125, 1, 0.5},
					{0.0625, 0.8125, 0.375, 0.1875, 0.9375, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.1875, 0.6875, 0.375, 0.3125, 0.8125, 0.5},
					{0.25, 0.625, 0.375, 0.375, 0.75, 0.5},
					{0.3125, 0.5625, 0.375, 0.4375, 0.6875, 0.5},
					{0.375, 0.5, 0.375, 0.5, 0.625, 0.5},
					{0.4375, 0.4375, 0.375, 0.5625, 0.5625, 0.5},
					{0.5, 0.375, 0.375, 0.625, 0.5, 0.5},
					{0.5625, 0.3125, 0.375, 0.6875, 0.4375, 0.5},
					{0.625, 0.25, 0.375, 0.75, 0.375, 0.5},
					{0.6875, 0.1875, 0.375, 0.8125, 0.3125, 0.5},
					{0.75, 0.125, 0.375, 0.875, 0.25, 0.5},
					{0.8125, 0.0625, 0.375, 0.9375, 0.1875, 0.5},
					{0.875, 0, 0.375, 1, 0.125, 0.5},
					{0.9375, -0.0625, 0.375, 1.0625, 0.0625, 0.5},
					{1, -0.125, 0.375, 1.125, 0, 0.5},
					{1.0625, -0.1875, 0.375, 1.1875, -0.0625, 0.5},
					{1.125, -0.25, 0.375, 1.25, -0.125, 0.5},
					{1.1875, -0.3125, 0.375, 1.3125, -0.1875, 0.5},
					{1.25, -0.375, 0.375, 1.375, -0.25, 0.5},
					{1.3125, -0.4375, 0.375, 1.4375, -0.3125, 0.5},
					{1.3125, 1.3125, 0.375, 1.4375, 1.4375, 0.5},
					{1.25, 1.25, 0.375, 1.375, 1.375, 0.5},
					{1.1875, 1.1875, 0.375, 1.3125, 1.3125, 0.5},
					{1.125, 1.125, 0.375, 1.25, 1.25, 0.5},
					{1.0625, 1.0625, 0.375, 1.1875, 1.1875, 0.5},
					{1, 1, 0.375, 1.125, 1.125, 0.5},
					{0.9375, 0.9375, 0.375, 1.0625, 1.0625, 0.5},
					{0.875, 0.875, 0.375, 1, 1, 0.5},
					{0.8125, 0.8125, 0.375, 0.9375, 0.9375, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.6875, 0.6875, 0.375, 0.8125, 0.8125, 0.5},
					{0.625, 0.625, 0.375, 0.75, 0.75, 0.5},
					{0.5625, 0.5625, 0.375, 0.6875, 0.6875, 0.5},
					{0.375, 0.375, 0.375, 0.625, 0.625, 0.5},
					{0.3125, 0.3125, 0.375, 0.4375, 0.4375, 0.5},
					{0.25, 0.25, 0.375, 0.375, 0.375, 0.5},
					{0.1875, 0.1875, 0.375, 0.3125, 0.3125, 0.5},
					{0.125, 0.125, 0.375, 0.25, 0.25, 0.5},
					{0.0625, 0.0625, 0.375, 0.1875, 0.1875, 0.5},
					{0, 0, 0.375, 0.125, 0.125, 0.5},
					{-0.0625, -0.0625, 0.375, 0.0625, 0.0625, 0.5},
					{-0.125, -0.125, 0.375, 0, 0, 0.5},
					{-0.1875, -0.1875, 0.375, -0.0625, -0.0625, 0.5},
					{-0.25, -0.25, 0.375, -0.125, -0.125, 0.5},
					{-0.3125, -0.3125, 0.375, -0.1875, -0.1875, 0.5},
					{-0.375, -0.375, 0.375, -0.25, -0.25, 0.5},
					{-0.4375, -0.4375, 0.375, -0.3125, -0.3125, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 1.5, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 1.5, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 1.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:small_upper_chord_" .. bridge_color, {
			description = bridge_desc .. " Small Upper Chord",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_small_upper_chord.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_small_upper_chord.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, 0.375, 0.4375, 0.5, 0.5, 0.5},
					{0.4375, 0.375, -1.5, 0.5, 0.5, 0.5},
					{-0.5, 0.375, -1.5, 0.5, 0.5, -1.4375},
					{-0.5, 0.375, -1.5, -0.4375, 0.5, 0.5},
					{-0.4375, 0.375, 0.25, -0.3125, 0.5, 0.4375},
					{-0.375, 0.375, 0.125, -0.25, 0.5, 0.3125},
					{-0.3125, 0.375, 0, -0.1875, 0.5, 0.1875},
					{-0.25, 0.375, -0.125, -0.125, 0.5, 0.0625},
					{-0.1875, 0.375, -0.25, -0.0625, 0.5, -0.0625},
					{-0.4375, 0.375, -1.4375, -0.3125, 0.5, -1.25},
					{-0.375, 0.375, -1.3125, -0.25, 0.5, -1.125},
					{-0.3125, 0.375, -1.1875, -0.1875, 0.5, -1},
					{-0.25, 0.375, -1.0625, -0.125, 0.5, -0.875},
					{-0.1875, 0.375, -0.9375, -0.0625, 0.5, -0.75},
					{-0.125, 0.375, -0.8125, 0, 0.5, -0.625},
					{-0.125, 0.375, -0.375, 0, 0.5, -0.1875},
					{0.3125, 0.375, 0.25, 0.4375, 0.5, 0.4375},
					{0.25, 0.375, 0.125, 0.375, 0.5, 0.3125},
					{0.1875, 0.375, 0, 0.3125, 0.5, 0.1875},
					{0.125, 0.375, -0.125, 0.25, 0.5, 0.0625},
					{0.0625, 0.375, -0.25, 0.1875, 0.5, -0.0625},
					{0, 0.375, -0.375, 0.125, 0.5, -0.1875},
					{-0.0625, 0.375, -0.625, 0.0625, 0.5, -0.375},
					{0.3125, 0.375, -1.4375, 0.4375, 0.5, -1.25},
					{0.25, 0.375, -1.3125, 0.375, 0.5, -1.125},
					{0.1875, 0.375, -1.1875, 0.3125, 0.5, -1},
					{0.125, 0.375, -1.0625, 0.25, 0.5, -0.875},
					{0.0625, 0.375, -0.9375, 0.1875, 0.5, -0.75},
					{0, 0.375, -0.8125, 0.125, 0.5, -0.625},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, 0, -1.5, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:small_upper_chord_slanted_" .. bridge_color, {
			description = bridge_desc .. " Small Slanted Upper Chord",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_small_upper_chord_slanted.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_small_upper_chord_slanted.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5625, -1.5, -0.4375, -0.4375, -1.375},
					{-0.5, -0.5625, -1.5, 0.5, -0.4375, -1.4375},
					{0.4375, -0.5625, -1.5, 0.5, -0.4375, -1.375},
					{0.4375, -0.5, -1.375, 0.5, -0.375, -1.25},
					{0.4375, -0.4375, -1.25, 0.5, -0.3125, -1.125},
					{0.4375, -0.375, -1.125, 0.5, -0.25, -1},
					{0.4375, -0.3125, -1, 0.5, -0.1875, -0.875},
					{0.4375, -0.25, -0.875, 0.5, -0.125, -0.75},
					{0.4375, -0.1875, -0.75, 0.5, -0.0625, -0.625},
					{0.4375, -0.125, -0.625, 0.5, -2.23517e-008, -0.5},
					{0.4375, -0.0625, -0.5, 0.5, 0.0625, -0.375},
					{0.4375, 0, -0.375, 0.5, 0.125, -0.25},
					{0.4375, 0.0625, -0.25, 0.5, 0.1875, -0.125},
					{0.4375, 0.125, -0.125, 0.5, 0.25, -1.04308e-007},
					{0.4375, 0.1875, 0, 0.5, 0.3125, 0.125},
					{0.4375, 0.25, 0.125, 0.5, 0.375, 0.25},
					{0.4375, 0.3125, 0.25, 0.5, 0.4375, 0.375},
					{0.4375, 0.375, 0.375, 0.5, 0.5, 0.5},
					{-0.5, 0.375, 0.4375, 0.5, 0.5, 0.5},
					{-0.5, -0.5, -1.375, -0.4375, -0.375, -1.25},
					{-0.5, -0.4375, -1.25, -0.4375, -0.3125, -1.125},
					{-0.5, -0.375, -1.125, -0.4375, -0.25, -1},
					{-0.5, -0.3125, -1, -0.4375, -0.1875, -0.875},
					{-0.5, -0.25, -0.875, -0.4375, -0.125, -0.75},
					{-0.5, -0.1875, -0.75, -0.4375, -0.0625, -0.625},
					{-0.5, -0.125, -0.625, -0.4375, 1.11759e-008, -0.5},
					{-0.5, -0.0625, -0.5, -0.4375, 0.0625, -0.375},
					{-0.5, 0, -0.375, -0.4375, 0.125, -0.25},
					{-0.5, 0.0625, -0.25, -0.4375, 0.1875, -0.125},
					{-0.5, 0.125, -0.125, -0.4375, 0.25, 1.41561e-007},
					{-0.5, 0.1875, 0, -0.4375, 0.3125, 0.125},
					{-0.5, 0.25, 0.125, -0.4375, 0.375, 0.25},
					{-0.5, 0.3125, 0.25, -0.4375, 0.4375, 0.375},
					{-0.5, 0.375, 0.375, -0.4375, 0.5, 0.5},
					{-0.4375, -0.5625, -1.5, -0.3125, -0.4375, -1.375},
					{-0.4375, -0.5, -1.375, -0.3125, -0.375, -1.25},
					{-0.375, -0.5, -1.3125, -0.25, -0.375, -1.25},
					{-0.375, -0.4375, -1.25, -0.25, -0.3125, -1.125},
					{-0.3125, -0.4375, -1.1875, -0.1875, -0.3125, -1.125},
					{-0.3125, -0.375, -1.125, -0.1875, -0.25, -1},
					{-0.25, -0.375, -1.0625, -0.125, -0.25, -1},
					{-0.25, -0.3125, -1, -0.125, -0.1875, -0.875},
					{-0.1875, -0.3125, -0.9375, -0.0625, -0.1875, -0.875},
					{-0.1875, -0.25, -0.875, -0.0624999, -0.125, -0.75},
					{-0.125, -0.25, -0.8125, 0.125, -0.125, -0.75},
					{-0.125, -0.1875, -0.75, 0.125, -0.0624999, -0.625},
					{-0.0625, -0.125, -0.625, 0.0625, 9.31323e-008, -0.5},
					{-0.0625, -0.0625, -0.5, 0.0625, 0.0625001, -0.375},
					{-0.125, 0, -0.375, 0.125, 0.125, -0.25},
					{-0.4375, 0.375, 0.375, -0.3125, 0.5, 0.4375},
					{-0.4375, 0.3125, 0.25, -0.3125, 0.4375, 0.375},
					{-0.375, 0.25, 0.125, -0.25, 0.375, 0.25},
					{-0.375, 0.3125, 0.25, -0.25, 0.4375, 0.3125},
					{-0.3125, 0.25, 0.125, -0.1875, 0.375, 0.1875},
					{-0.3125, 0.1875, 0, -0.1875, 0.3125, 0.125},
					{-0.25, 0.1875, 0, -0.125, 0.3125, 0.0625},
					{-0.25, 0.125, -0.125, -0.125, 0.25, 1.30385e-008},
					{-0.1875, 0.125, -0.125, -0.0625, 0.25, -0.0625},
					{-0.1875, 0.0625, -0.25, -0.0625, 0.1875, -0.125},
					{-0.125, 0.0625, -0.25, 0.125, 0.1875, -0.1875},
					{0.0625, 0.0625, -0.25, 0.1875, 0.1875, -0.125},
					{0.0625, 0.125, -0.125, 0.1875, 0.25, -0.0625},
					{0.125, 0.125, -0.125, 0.25, 0.25, 0},
					{0.125, 0.1875, 0, 0.25, 0.3125, 0.0625},
					{0.1875, 0.1875, 0, 0.3125, 0.3125, 0.125},
					{0.1875, 0.25, 0.125, 0.3125, 0.375, 0.1875},
					{0.25, 0.25, 0.125, 0.375, 0.375, 0.25},
					{0.25, 0.3125, 0.25, 0.375, 0.4375, 0.3125},
					{0.3125, 0.3125, 0.3125, 0.4375, 0.4375, 0.375},
					{0.3125, 0.375, 0.375, 0.4375, 0.5, 0.4375},
					{0.3125, -0.5625, -1.4375, 0.4375, -0.4375, -1.375},
					{0.3125, -0.5, -1.375, 0.4375, -0.375, -1.25},
					{0.25, -0.5, -1.3125, 0.375, -0.375, -1.25},
					{0.25, -0.4375, -1.25, 0.375, -0.3125, -1.125},
					{0.1875, -0.4375, -1.1875, 0.3125, -0.3125, -1.125},
					{0.1875, -0.375, -1.125, 0.3125, -0.25, -1},
					{0.125, -0.375, -1.0625, 0.25, -0.25, -1},
					{0.125, -0.3125, -1, 0.25, -0.1875, -0.875},
					{0.0625, -0.3125, -0.9375, 0.1875, -0.1875, -0.875},
					{0.0625, -0.25, -0.875, 0.1875, -0.125, -0.75},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -1.5, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:medium_upper_chord_" .. bridge_color, {
			description = bridge_desc .. " Medium Upper Chord",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_medium_upper_chord.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_medium_upper_chord.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-1.5, 0.375, 0.4375, 1.5, 0.5, 0.5},
					{1.4375, 0.375, -1.5, 1.5, 0.5, 0.5},
					{-1.5, 0.375, -1.5, 1.5, 0.5, -1.4375},
					{-1.5, 0.375, -1.5, -1.4375, 0.5, 0.5},
					{-1.4375, 0.375, 0.3125, -1.3125, 0.5, 0.4375},
					{-1.375, 0.375, 0.25, -1.1875, 0.5, 0.375},
					{-1.25, 0.375, 0.1875, -1.125, 0.5, 0.3125},
					{-1.1875, 0.375, 0.125, -1, 0.5, 0.25},
					{-1.0625, 0.375, 0.0625, -0.9375, 0.5, 0.1875},
					{-1, 0.375, 0, -0.8125, 0.5, 0.125},
					{-0.875, 0.375, -0.0625, -0.75, 0.5, 0.0625},
					{-0.8125, 0.375, -0.125, -0.625, 0.5, 0},
					{-0.6875, 0.375, -0.1875, -0.5625, 0.5, -0.0625},
					{-0.625, 0.375, -0.25, -0.4375, 0.5, -0.125},
					{-0.5, 0.375, -0.3125, -0.375, 0.5, -0.1875},
					{-0.4375, 0.375, -0.375, -0.25, 0.5, -0.25},
					{-0.3125, 0.375, -0.4375, -0.1875, 0.5, -0.3125},
					{-0.25, 0.375, -0.5, -0.0625, 0.5, -0.375},
					{-0.125, 0.375, -0.5625, 0.125, 0.5, -0.4375},
					{1.3125, 0.375, -1.4375, 1.4375, 0.5, -1.3125},
					{1.1875, 0.375, -1.375, 1.375, 0.5, -1.25},
					{1.125, 0.375, -1.3125, 1.25, 0.5, -1.1875},
					{1, 0.375, -1.25, 1.1875, 0.5, -1.125},
					{0.9375, 0.375, -1.1875, 1.0625, 0.5, -1.0625},
					{0.8125, 0.375, -1.125, 1, 0.5, -1},
					{0.75, 0.375, -1.0625, 0.875, 0.5, -0.9375},
					{0.625, 0.375, -1, 0.8125, 0.5, -0.875},
					{0.5625, 0.375, -0.9375, 0.6875, 0.5, -0.8125},
					{0.4375, 0.375, -0.875, 0.625, 0.5, -0.75},
					{0.375, 0.375, -0.8125, 0.5, 0.5, -0.6875},
					{0.25, 0.375, -0.75, 0.4375, 0.5, -0.625},
					{0.1875, 0.375, -0.6875, 0.3125, 0.5, -0.5625},
					{0.0625, 0.375, -0.625, 0.25, 0.5, -0.5},
					{1.3125, 0.375, 0.3125, 1.4375, 0.5, 0.4375},
					{1.1875, 0.375, 0.25, 1.375, 0.5, 0.375},
					{1.125, 0.375, 0.1875, 1.25, 0.5, 0.3125},
					{1, 0.375, 0.125, 1.1875, 0.5, 0.25},
					{0.9375, 0.375, 0.0625, 1.0625, 0.5, 0.1875},
					{0.8125, 0.375, 0, 1, 0.5, 0.125},
					{0.75, 0.375, -0.0625, 0.875, 0.5, 0.0625},
					{0.625, 0.375, -0.125, 0.8125, 0.5, 0},
					{0.5625, 0.375, -0.1875, 0.6875, 0.5, -0.0625},
					{0.4375, 0.375, -0.25, 0.625, 0.5, -0.125},
					{0.375, 0.375, -0.3125, 0.5, 0.5, -0.1875},
					{0.25, 0.375, -0.375, 0.4375, 0.5, -0.25},
					{0.1875, 0.375, -0.4375, 0.3125, 0.5, -0.3125},
					{0.0625, 0.375, -0.5, 0.25, 0.5, -0.375},
					{-1.4375, 0.375, -1.4375, -1.3125, 0.5, -1.3125},
					{-1.375, 0.375, -1.375, -1.1875, 0.5, -1.25},
					{-1.25, 0.375, -1.3125, -1.125, 0.5, -1.1875},
					{-1.1875, 0.375, -1.25, -1, 0.5, -1.125},
					{-1.0625, 0.375, -1.1875, -0.9375, 0.5, -1.0625},
					{-1, 0.375, -1.125, -0.8125, 0.5, -1},
					{-0.875, 0.375, -1.0625, -0.75, 0.5, -0.9375},
					{-0.8125, 0.375, -1, -0.625, 0.5, -0.875},
					{-0.6875, 0.375, -0.9375, -0.5625, 0.5, -0.8125},
					{-0.625, 0.375, -0.875, -0.4375, 0.5, -0.75},
					{-0.5, 0.375, -0.8125, -0.375, 0.5, -0.6875},
					{-0.4375, 0.375, -0.75, -0.25, 0.5, -0.625},
					{-0.3125, 0.375, -0.6875, -0.1875, 0.5, -0.5625},
					{-0.25, 0.375, -0.625, -0.0625, 0.5, -0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-1.5, 0, -1.5, 1.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:medium_upper_chord_slanted_" .. bridge_color, {
			description = bridge_desc .. " Medium Slanted Upper Chord",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_medium_upper_chord_slanted.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_medium_upper_chord_slanted.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-1.5, -0.5625, -1.5, -1.4375, -0.4375, -1.375},
					{-1.5, -0.5625, -1.5, 1.5, -0.4375, -1.4375},
					{1.4375, -0.5625, -1.5, 1.5, -0.4375, -1.375},
					{1.4375, -0.5, -1.375, 1.5, -0.375, -1.25},
					{1.4375, -0.4375, -1.25, 1.5, -0.3125, -1.125},
					{1.4375, -0.375, -1.125, 1.5, -0.25, -1},
					{1.4375, -0.3125, -1, 1.5, -0.1875, -0.875},
					{1.4375, -0.25, -0.875, 1.5, -0.125, -0.75},
					{1.4375, -0.1875, -0.75, 1.5, -0.0625, -0.625},
					{1.4375, -0.125, -0.625, 1.5, -2.23517e-008, -0.5},
					{1.4375, -0.0625, -0.5, 1.5, 0.0625, -0.375},
					{1.4375, 0, -0.375, 1.5, 0.125, -0.25},
					{1.4375, 0.0625, -0.25, 1.5, 0.1875, -0.125},
					{1.4375, 0.125, -0.125, 1.5, 0.25, -9.68575e-008},
					{1.4375, 0.1875, 0, 1.5, 0.3125, 0.125},
					{1.4375, 0.25, 0.125, 1.5, 0.375, 0.25},
					{1.4375, 0.3125, 0.25, 1.5, 0.4375, 0.375},
					{1.4375, 0.375, 0.375, 1.5, 0.5, 0.5},
					{-1.5, 0.375, 0.4375, 1.5, 0.5, 0.5},
					{-1.5, -0.5, -1.375, -1.4375, -0.375, -1.25},
					{-1.5, -0.4375, -1.25, -1.4375, -0.3125, -1.125},
					{-1.5, -0.375, -1.125, -1.4375, -0.25, -1},
					{-1.5, -0.3125, -1, -1.4375, -0.1875, -0.875},
					{-1.5, -0.25, -0.875, -1.4375, -0.125, -0.75},
					{-1.5, -0.1875, -0.75, -1.4375, -0.0625, -0.625},
					{-1.5, -0.125, -0.625, -1.4375, 1.11759e-008, -0.5},
					{-1.5, -0.0625, -0.5, -1.4375, 0.0625, -0.375},
					{-1.5, 0, -0.375, -1.4375, 0.125, -0.25},
					{-1.5, 0.0625, -0.25, -1.4375, 0.1875, -0.125},
					{-1.5, 0.125, -0.125, -1.4375, 0.25, 1.49012e-007},
					{-1.5, 0.1875, 0, -1.4375, 0.3125, 0.125},
					{-1.5, 0.25, 0.125, -1.4375, 0.375, 0.25},
					{-1.5, 0.3125, 0.25, -1.4375, 0.4375, 0.375},
					{-1.5, 0.375, 0.375, -1.4375, 0.5, 0.5},
					{-1.4375, -0.5625, -1.4375, -1.3125, -0.4375, -1.375},
					{-1.4375, -0.5, -1.375, -1.1875, -0.375, -1.3125},
					{-1.375, -0.5, -1.3125, -1.125, -0.375, -1.25},
					{-1.25, -0.4375, -1.25, -1, -0.3125, -1.1875},
					{-1.1875, -0.4375, -1.1875, -0.9375, -0.3125, -1.125},
					{-1.0625, -0.375, -1.125, -0.8125, -0.25, -1.0625},
					{-1, -0.375, -1.0625, -0.75, -0.25, -1},
					{-0.875, -0.3125, -1, -0.625, -0.1875, -0.9375},
					{-0.8125, -0.3125, -0.9375, -0.5625, -0.1875, -0.875},
					{-0.6875, -0.25, -0.875, -0.4375, -0.125, -0.8125},
					{-0.625, -0.25, -0.8125, -0.375, -0.125, -0.75},
					{-0.5, -0.1875, -0.75, -0.25, -0.0625, -0.6875},
					{-0.4375, -0.1875, -0.6875, -0.1875, -0.0625, -0.625},
					{-0.3125, -0.125, -0.625, -0.0625, 3.35276e-008, -0.5625},
					{-0.25, -0.125, -0.5625, 0.25, 3.35276e-008, -0.5},
					{-0.25, -0.0625, -0.5, 0.25, 0.0625, -0.4375},
					{-0.3125, -0.0625, -0.4375, -0.0625, 0.0625, -0.375},
					{-0.4375, 0, -0.375, -0.1875, 0.125, -0.3125},
					{-0.5, 0, -0.3125, -0.25, 0.125, -0.25},
					{-0.625, 0.0625, -0.25, -0.375, 0.1875, -0.1875},
					{-0.6875, 0.0625, -0.1875, -0.4375, 0.1875, -0.125},
					{-0.8125, 0.125, -0.125, -0.5625, 0.25, -0.0625001},
					{-0.875, 0.125, -0.0625, -0.625, 0.25, -9.87202e-008},
					{-1, 0.1875, 0, -0.75, 0.3125, 0.0624999},
					{-1.0625, 0.1875, 0.0625, -0.8125, 0.3125, 0.125},
					{-1.1875, 0.25, 0.125, -0.9375, 0.375, 0.1875},
					{-1.25, 0.25, 0.1875, -1, 0.375, 0.25},
					{-1.375, 0.3125, 0.25, -1.125, 0.4375, 0.3125},
					{-1.4375, 0.3125, 0.3125, -1.1875, 0.4375, 0.375},
					{-1.4375, 0.375, 0.375, -1.3125, 0.5, 0.4375},
					{1.3125, 0.375, 0.375, 1.4375, 0.5, 0.4375},
					{1.1875, 0.3125, 0.3125, 1.4375, 0.4375, 0.375},
					{1.125, 0.3125, 0.25, 1.375, 0.4375, 0.3125},
					{1, 0.25, 0.1875, 1.25, 0.375, 0.25},
					{0.9375, 0.25, 0.125, 1.1875, 0.375, 0.1875},
					{0.8125, 0.1875, 0.0625, 1.0625, 0.3125, 0.125},
					{0.75, 0.1875, 0, 1, 0.3125, 0.0624999},
					{0.625, 0.125, -0.0625, 0.875, 0.25, -1.2666e-007},
					{0.5625, 0.125, -0.125, 0.8125, 0.25, -0.0625001},
					{0.4375, 0.0625, -0.1875, 0.6875, 0.1875, -0.125},
					{0.375, 0.0625, -0.25, 0.625, 0.1875, -0.1875},
					{0.25, 0, -0.3125, 0.5, 0.125, -0.25},
					{0.1875, 0, -0.375, 0.4375, 0.125, -0.3125},
					{0.0625, -0.0625, -0.4375, 0.3125, 0.0625, -0.375},
					{0.0625, -0.125, -0.625, 0.3125, 3.72529e-009, -0.5625},
					{0.1875, -0.1875, -0.6875, 0.4375, -0.0625, -0.625},
					{0.25, -0.1875, -0.75, 0.5, -0.0625, -0.6875},
					{0.375, -0.25, -0.8125, 0.625, -0.125, -0.75},
					{0.4375, -0.25, -0.875, 0.6875, -0.125, -0.8125},
					{0.5625, -0.3125, -0.9375, 0.8125, -0.1875, -0.875},
					{0.625, -0.3125, -1, 0.875, -0.1875, -0.9375},
					{0.75, -0.375, -1.0625, 1, -0.25, -1},
					{0.8125, -0.375, -1.125, 1.0625, -0.25, -1.0625},
					{0.9375, -0.4375, -1.1875, 1.1875, -0.3125, -1.125},
					{1, -0.4375, -1.25, 1.25, -0.3125, -1.1875},
					{1.125, -0.5, -1.3125, 1.375, -0.375, -1.25},
					{1.1875, -0.5, -1.375, 1.4375, -0.375, -1.3125},
					{1.3125, -0.5625, -1.4375, 1.4375, -0.4375, -1.375},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-1.5, -0.5, -1.5, 1.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:large_upper_chord_" .. bridge_color, {
			description = bridge_desc .. " Large Upper Chord",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_large_upper_chord.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_large_upper_chord.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-2.5, 0.375, 0.4375, 2.5, 0.5, 0.5},
					{2.4375, 0.375, -1.5, 2.5, 0.5, 0.5},
					{-2.5, 0.375, -1.5, 2.5, 0.5, -1.4375},
					{-2.5, 0.375, -1.5, -2.4375, 0.5, 0.5},
					{-2.4375, 0.375, 0.3125, -2.1875, 0.5, 0.4375},
					{-2.3125, 0.375, 0.25, -2, 0.5, 0.375},
					{-2.125, 0.375, 0.1875, -1.875, 0.5, 0.3125},
					{-2, 0.375, 0.125, -1.6875, 0.5, 0.25},
					{-1.875, 0.375, 0.0625, -1.5, 0.5, 0.1875},
					{-1.625, 0.375, 0, -1.375, 0.5, 0.125},
					{-1.5, 0.375, -0.0625, -1.1875, 0.5, 0.0625},
					{-1.3125, 0.375, -0.125, -1, 0.5, 0},
					{-1.125, 0.375, -0.1875, -0.875, 0.5, -0.0625},
					{-1, 0.375, -0.25, -0.6875, 0.5, -0.125},
					{-0.8125, 0.375, -0.3125, -0.5, 0.5, -0.1875},
					{-0.625, 0.375, -0.375, -0.375, 0.5, -0.25},
					{-0.5, 0.375, -0.4375, -0.1875, 0.5, -0.3125},
					{2.1875, 0.375, 0.3125, 2.4375, 0.5, 0.4375},
					{2, 0.375, 0.25, 2.3125, 0.5, 0.375},
					{1.875, 0.375, 0.1875, 2.125, 0.5, 0.3125},
					{1.6875, 0.375, 0.125, 2, 0.5, 0.25},
					{1.5, 0.375, 0.0625, 1.8125, 0.5, 0.1875},
					{1.1875, 0.375, -0.0625, 1.5, 0.5, 0.0625},
					{1.375, 0.375, 0, 1.625, 0.5, 0.125},
					{1, 0.375, -0.125, 1.3125, 0.5, 0},
					{0.875, 0.375, -0.1875, 1.125, 0.5, -0.0625},
					{0.6875, 0.375, -0.25, 1, 0.5, -0.125},
					{0.5, 0.375, -0.3125, 0.8125, 0.5, -0.1875},
					{0.375, 0.375, -0.375, 0.625, 0.5, -0.25},
					{0.1875, 0.375, -0.4375, 0.5, 0.5, -0.3125},
					{-0.375, 0.375, -0.625, 0.3125, 0.5, -0.375},
					{2.1875, 0.375, -1.4375, 2.4375, 0.5, -1.3125},
					{2, 0.375, -1.375, 2.3125, 0.5, -1.25},
					{1.875, 0.375, -1.3125, 2.125, 0.5, -1.1875},
					{1.6875, 0.375, -1.25, 2, 0.5, -1.125},
					{1.5, 0.375, -1.1875, 1.8125, 0.5, -1.0625},
					{1.375, 0.375, -1.125, 1.625, 0.5, -1},
					{1.1875, 0.375, -1.0625, 1.5, 0.5, -0.9375},
					{1, 0.375, -1, 1.3125, 0.5, -0.875},
					{0.875, 0.375, -0.9375, 1.125, 0.5, -0.8125},
					{0.6875, 0.375, -0.875, 1, 0.5, -0.75},
					{0.5, 0.375, -0.8125, 0.8125, 0.5, -0.6875},
					{0.375, 0.375, -0.75, 0.625, 0.5, -0.625},
					{0.1875, 0.375, -0.6875, 0.5, 0.5, -0.5625},
					{-2.4375, 0.375, -1.4375, -2.1875, 0.5, -1.3125},
					{-2.3125, 0.375, -1.375, -2, 0.5, -1.25},
					{-2.125, 0.375, -1.3125, -1.875, 0.5, -1.1875},
					{-2, 0.375, -1.25, -1.6875, 0.5, -1.125},
					{-1.8125, 0.375, -1.1875, -1.5, 0.5, -1.0625},
					{-1.625, 0.375, -1.125, -1.375, 0.5, -1},
					{-1.5, 0.375, -1.0625, -1.1875, 0.5, -0.9375},
					{-1.3125, 0.375, -1, -1, 0.5, -0.875},
					{-1.125, 0.375, -0.9375, -0.875, 0.5, -0.8125},
					{-1, 0.375, -0.875, -0.6875, 0.5, -0.75},
					{-0.8125, 0.375, -0.8125, -0.5, 0.5, -0.6875},
					{-0.625, 0.375, -0.75, -0.375, 0.5, -0.625},
					{-0.5, 0.375, -0.6875, -0.1875, 0.5, -0.5625},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-2.5, 0, -1.5, 2.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:large_upper_chord_slanted_" .. bridge_color, {
			description = bridge_desc .. " Large Slanted Upper Chord",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_large_upper_chord_slanted.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_large_upper_chord_slanted.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-2.5, -0.5625, -1.5, -2.4375, -0.4375, -1.375},
					{-2.5, -0.5625, -1.5, 2.5, -0.4375, -1.4375},
					{2.4375, -0.5625, -1.5, 2.5, -0.4375, -1.375},
					{2.4375, -0.5, -1.375, 2.5, -0.375, -1.25},
					{2.4375, -0.4375, -1.25, 2.5, -0.3125, -1.125},
					{2.4375, -0.375, -1.125, 2.5, -0.25, -1},
					{2.4375, -0.3125, -1, 2.5, -0.1875, -0.875},
					{2.4375, -0.25, -0.875, 2.5, -0.125, -0.75},
					{2.4375, -0.1875, -0.75, 2.5, -0.0625, -0.625},
					{2.4375, -0.125, -0.625, 2.5, -2.23517e-008, -0.5},
					{2.4375, -0.0625, -0.5, 2.5, 0.0625, -0.375},
					{2.4375, 0, -0.375, 2.5, 0.125, -0.25},
					{2.4375, 0.0625, -0.25, 2.5, 0.1875, -0.125},
					{2.4375, 0.125, -0.125, 2.5, 0.25, -9.68575e-008},
					{2.4375, 0.1875, 0, 2.5, 0.3125, 0.125},
					{2.4375, 0.25, 0.125, 2.5, 0.375, 0.25},
					{2.4375, 0.3125, 0.25, 2.5, 0.4375, 0.375},
					{2.4375, 0.375, 0.375, 2.5, 0.5, 0.5},
					{-2.5, 0.375, 0.4375, 2.5, 0.5, 0.5},
					{-2.5, -0.5, -1.375, -2.4375, -0.375, -1.25},
					{-2.5, -0.4375, -1.25, -2.4375, -0.3125, -1.125},
					{-2.5, -0.375, -1.125, -2.4375, -0.25, -1},
					{-2.5, -0.3125, -1, -2.4375, -0.1875, -0.875},
					{-2.5, -0.25, -0.875, -2.4375, -0.125, -0.75},
					{-2.5, -0.1875, -0.75, -2.4375, -0.0625, -0.625},
					{-2.5, -0.125, -0.625, -2.4375, 1.11759e-008, -0.5},
					{-2.5, -0.0625, -0.5, -2.4375, 0.0625, -0.375},
					{-2.5, 0, -0.375, -2.4375, 0.125, -0.25},
					{-2.5, 0.0625, -0.25, -2.4375, 0.1875, -0.125},
					{-2.5, 0.125, -0.125, -2.4375, 0.25, 1.67638e-007},
					{-2.5, 0.1875, 0, -2.4375, 0.3125, 0.125},
					{-2.5, 0.25, 0.125, -2.4375, 0.375, 0.25},
					{-2.5, 0.3125, 0.25, -2.4375, 0.4375, 0.375},
					{-2.5, 0.375, 0.375, -2.4375, 0.5, 0.5},
					{-2.4375, -0.5625, -1.4375, -2.1875, -0.4375, -1.375},
					{-2.4375, -0.5625, -1.375, -2, -0.4375, -1.3125},
					{-2.3125, -0.5625, -1.3125, -1.875, -0.4375, -1.25},
					{-2.125, -0.4375, -1.25, -1.6875, -0.3125, -1.1875},
					{-2, -0.4375, -1.1875, -1.5625, -0.3125, -1.125},
					{-1.8125, -0.375, -1.125, -1.375, -0.25, -1.0625},
					{-1.6875, -0.375, -1.0625, -1.25, -0.25, -1},
					{-1.5, -0.3125, -1, -1.0625, -0.1875, -0.9375},
					{-1.375, -0.3125, -0.9375, -0.937501, -0.1875, -0.875},
					{-1.1875, -0.25, -0.875, -0.750001, -0.125, -0.8125},
					{-1.0625, -0.25, -0.8125, -0.625001, -0.125, -0.75},
					{-0.875, -0.1875, -0.75, -0.437501, -0.0624999, -0.6875},
					{-0.75, -0.1875, -0.6875, -0.312501, -0.0624999, -0.625},
					{-0.5625, -0.125, -0.625, -0.125001, 1.60187e-007, -0.5625},
					{-0.4375, -0.125, -0.5625, 0.4375, 1.56462e-007, -0.5},
					{-0.4375, -0.0625, -0.5, 0.4375, 0.0625001, -0.4375},
					{-0.5625, -0.0625, -0.4375, -0.125, 0.0625001, -0.375},
					{-0.75, 0, -0.375, -0.3125, 0.125, -0.3125},
					{-0.875, 0, -0.3125, -0.4375, 0.125, -0.25},
					{-1.0625, 0.0625, -0.25, -0.625, 0.1875, -0.1875},
					{-1.1875, 0.0625, -0.1875, -0.75, 0.1875, -0.125},
					{-1.375, 0.125, -0.125, -0.9375, 0.25, -0.0625001},
					{-1.5, 0.125, -0.0625, -1.0625, 0.25, -7.07805e-008},
					{-1.6875, 0.1875, 0, -1.25, 0.3125, 0.0624999},
					{-1.8125, 0.1875, 0.0625, -1.375, 0.3125, 0.125},
					{-2, 0.25, 0.125, -1.5625, 0.375, 0.1875},
					{-2.125, 0.25, 0.1875, -1.6875, 0.375, 0.25},
					{-2.3125, 0.3125, 0.25, -1.875, 0.4375, 0.3125},
					{-2.4375, 0.3125, 0.3125, -2, 0.4375, 0.375},
					{-2.4375, 0.375, 0.375, -2.1875, 0.5, 0.4375},
					{2.1875, 0.375, 0.375, 2.4375, 0.5, 0.4375},
					{2, 0.3125, 0.3125, 2.4375, 0.4375, 0.375},
					{1.875, 0.3125, 0.25, 2.3125, 0.4375, 0.3125},
					{1.6875, 0.25, 0.1875, 2.125, 0.375, 0.25},
					{1.5625, 0.25, 0.125, 2, 0.375, 0.1875},
					{1.375, 0.1875, 0.0625, 1.8125, 0.3125, 0.125},
					{1.25, 0.1875, 0, 1.6875, 0.3125, 0.0624999},
					{1.0625, 0.125, -0.0625, 1.5, 0.25, -6.70552e-008},
					{0.9375, 0.125, -0.125, 1.375, 0.25, -0.0625001},
					{0.75, 0.0625, -0.1875, 1.1875, 0.1875, -0.125},
					{0.625, 0.0625, -0.25, 1.0625, 0.1875, -0.1875},
					{0.4375, 0, -0.3125, 0.875, 0.125, -0.25},
					{0.3125, 0, -0.375, 0.75, 0.125, -0.3125},
					{0.125, 0, -0.4375, 0.5625, 0.125, -0.375},
					{0.125, -0.125, -0.625, 0.5625, 1.22935e-007, -0.5625},
					{0.3125, -0.1875, -0.6875, 0.75, -0.0624999, -0.625},
					{0.4375, -0.1875, -0.75, 0.875, -0.0624999, -0.6875},
					{0.625, -0.25, -0.8125, 1.0625, -0.125, -0.75},
					{0.75, -0.25, -0.875, 1.1875, -0.125, -0.8125},
					{0.9375, -0.3125, -0.9375, 1.375, -0.1875, -0.875},
					{1.0625, -0.3125, -1, 1.5, -0.1875, -0.9375},
					{1.25, -0.375, -1.0625, 1.6875, -0.25, -1},
					{1.375, -0.375, -1.125, 1.8125, -0.25, -1.0625},
					{1.5625, -0.4375, -1.1875, 2, -0.3125, -1.125},
					{1.6875, -0.4375, -1.25, 2.125, -0.3125, -1.1875},
					{1.875, -0.5, -1.3125, 2.3125, -0.375, -1.25},
					{2, -0.5, -1.375, 2.4375, -0.375, -1.3125},
					{2.1875, -0.5625, -1.4375, 2.4375, -0.4375, -1.375},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-2.5, -0.5, -1.5, 2.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:small_support_" .. bridge_color, {
			description = bridge_desc .. " Small Support",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_small_support.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_small_support.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{0.375, -0.5, -0.5, 0.5, 0.5, -0.375},
					{-0.5, -0.5, -0.5, -0.375, 0.5, -0.375},
					{-0.4375, -0.4375, -0.5, -0.3125, -0.3125, -0.375},
					{-0.375, -0.375, -0.5, -0.25, -0.25, -0.375},
					{-0.3125, -0.3125, -0.5, -0.1875, -0.1875, -0.375},
					{-0.25, -0.25, -0.5, -0.125, -0.125, -0.375},
					{-0.1875, -0.1875, -0.5, -0.0625, -0.0625, -0.375},
					{-0.125, -0.125, -0.5, 0.125, 0.125, -0.375},
					{0.0625, 0.0625, -0.5, 0.1875, 0.1875, -0.375},
					{0.125, 0.125, -0.5, 0.25, 0.25, -0.375},
					{0.1875, 0.1875, -0.5, 0.3125, 0.3125, -0.375},
					{0.25, 0.25, -0.5, 0.375, 0.375, -0.375},
					{0.3125, 0.3125, -0.5, 0.4375, 0.4375, -0.375},
					{-0.4375, 0.3125, -0.5, -0.3125, 0.4375, -0.375},
					{-0.375, 0.25, -0.5, -0.25, 0.375, -0.375},
					{-0.3125, 0.1875, -0.5, -0.1875, 0.3125, -0.375},
					{-0.25, 0.125, -0.5, -0.125, 0.25, -0.375},
					{-0.1875, 0.0625, -0.5, -0.0625, 0.1875, -0.375},
					{0.0625, -0.1875, -0.5, 0.1875, -0.0625, -0.375},
					{0.125, -0.25, -0.5, 0.25, -0.125, -0.375},
					{0.1875, -0.3125, -0.5, 0.3125, -0.1875, -0.375},
					{0.25, -0.375, -0.5, 0.375, -0.25, -0.375},
					{0.3125, -0.4375, -0.5, 0.4375, -0.3125, -0.375},
					{-0.5, -0.4375, 0.3125, -0.375, -0.3125, 0.4375},
					{-0.5, -0.375, 0.25, -0.375, -0.25, 0.375},
					{-0.5, -0.3125, 0.1875, -0.375, -0.1875, 0.3125},
					{-0.5, -0.25, 0.125, -0.375, -0.125, 0.25},
					{-0.5, -0.1875, 0.0625, -0.375, -0.0625, 0.1875},
					{-0.5, -0.125, -0.125, -0.375, 0.125, 0.125},
					{-0.5, 0.0625, -0.1875, -0.375, 0.1875, -0.0625},
					{-0.5, 0.125, -0.25, -0.375, 0.25, -0.125},
					{-0.5, 0.1875, -0.3125, -0.375, 0.3125, -0.1875},
					{-0.5, 0.25, -0.375, -0.375, 0.375, -0.25},
					{-0.5, 0.3125, -0.4375, -0.375, 0.4375, -0.3125},
					{-0.5, 0.3125, 0.3125, -0.375, 0.4375, 0.4375},
					{-0.5, 0.25, 0.25, -0.375, 0.375, 0.375},
					{-0.5, 0.1875, 0.1875, -0.375, 0.3125, 0.3125},
					{-0.5, 0.125, 0.125, -0.375, 0.25, 0.25},
					{-0.5, 0.0625, 0.0625, -0.375, 0.1875, 0.1875},
					{-0.5, -0.1875, -0.1875, -0.375, -0.0625, -0.0625},
					{-0.5, -0.25, -0.25, -0.375, -0.125, -0.125},
					{-0.5, -0.3125, -0.3125, -0.375, -0.1875, -0.1875},
					{-0.5, -0.375, -0.375, -0.375, -0.25, -0.25},
					{-0.5, -0.4375, -0.4375, -0.375, -0.3125, -0.3125},
					{0.3125, -0.4375, 0.375, 0.4375, -0.3125, 0.5},
					{0.25, -0.375, 0.375, 0.375, -0.25, 0.5},
					{0.1875, -0.3125, 0.375, 0.3125, -0.1875, 0.5},
					{0.125, -0.25, 0.375, 0.25, -0.125, 0.5},
					{0.0625, -0.1875, 0.375, 0.1875, -0.0625, 0.5},
					{-0.125, -0.125, 0.375, 0.125, 0.125, 0.5},
					{-0.1875, 0.0625, 0.375, -0.0625, 0.1875, 0.5},
					{-0.25, 0.125, 0.375, -0.125, 0.25, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.3125, 0.5},
					{-0.375, 0.25, 0.375, -0.25, 0.375, 0.5},
					{-0.4375, 0.3125, 0.375, -0.3125, 0.4375, 0.5},
					{0.3125, 0.3125, 0.375, 0.4375, 0.4375, 0.5},
					{0.25, 0.25, 0.375, 0.375, 0.375, 0.5},
					{0.1875, 0.1875, 0.375, 0.3125, 0.3125, 0.5},
					{0.125, 0.125, 0.375, 0.25, 0.25, 0.5},
					{0.0625, 0.0625, 0.375, 0.1875, 0.1875, 0.5},
					{-0.1875, -0.1875, 0.375, -0.0625, -0.0625, 0.5},
					{-0.25, -0.25, 0.375, -0.125, -0.125, 0.5},
					{-0.3125, -0.3125, 0.375, -0.1875, -0.1875, 0.5},
					{-0.375, -0.375, 0.375, -0.25, -0.25, 0.5},
					{-0.4375, -0.4375, 0.375, -0.3125, -0.3125, 0.5},
					{0.375, -0.4375, -0.4375, 0.5, -0.3125, -0.3125},
					{0.375, -0.375, -0.375, 0.5, -0.25, -0.25},
					{0.375, -0.3125, -0.3125, 0.5, -0.1875, -0.1875},
					{0.375, -0.25, -0.25, 0.5, -0.125, -0.125},
					{0.375, -0.1875, -0.1875, 0.5, -0.0625, -0.0625},
					{0.375, -0.125, -0.125, 0.5, 0.125, 0.125},
					{0.375, 0.0625, 0.0625, 0.5, 0.1875, 0.1875},
					{0.375, 0.125, 0.125, 0.5, 0.25, 0.25},
					{0.375, 0.1875, 0.1875, 0.5, 0.3125, 0.3125},
					{0.375, 0.25, 0.25, 0.5, 0.375, 0.375},
					{0.375, 0.3125, 0.3125, 0.5, 0.4375, 0.4375},
					{0.375, 0.3125, -0.4375, 0.5, 0.4375, -0.3125},
					{0.375, 0.25, -0.375, 0.5, 0.375, -0.25},
					{0.375, 0.1875, -0.3125, 0.5, 0.3125, -0.1875},
					{0.375, 0.125, -0.25, 0.5, 0.25, -0.125},
					{0.375, 0.0625, -0.1875, 0.5, 0.1875, -0.0625},
					{0.375, -0.1875, 0.0625, 0.5, -0.0625, 0.1875},
					{0.375, -0.25, 0.125, 0.5, -0.125, 0.25},
					{0.375, -0.3125, 0.1875, 0.5, -0.1875, 0.3125},
					{0.375, -0.375, 0.25, 0.5, -0.25, 0.375},
					{0.375, -0.4375, 0.3125, 0.5, -0.3125, 0.4375},
					{-0.5, -0.5, 0.375, -0.375, 0.5, 0.5},
					{0.375, -0.5, 0.375, 0.5, 0.5, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:small_support_top_" .. bridge_color, {
			description = bridge_desc .. " Small Support Top",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_small_support_top.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_small_support_top.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{0.375, -0.5, -0.5, 0.5, 1.5, -0.375},
					{-0.5, -0.5, -0.5, -0.375, 1.5, -0.375},
					{0.3125, -0.4375, -0.5, 0.4375, -0.3125, -0.375},
					{0.25, -0.375, -0.5, 0.375, -0.25, -0.375},
					{0.1875, -0.3125, -0.5, 0.3125, -0.1875, -0.375},
					{0.125, -0.25, -0.5, 0.25, -0.125, -0.375},
					{0.0625, -0.1875, -0.5, 0.1875, -0.0625, -0.375},
					{-0.125, -0.125, -0.5, 0.125, 0.125, -0.375},
					{-0.1875, -0.1875, -0.5, -0.0625, -0.0625, -0.375},
					{-0.25, -0.25, -0.5, -0.125, -0.125, -0.375},
					{-0.3125, -0.3125, -0.5, -0.1875, -0.1875, -0.375},
					{-0.375, -0.375, -0.5, -0.25, -0.25, -0.375},
					{-0.4375, -0.4375, -0.5, -0.3125, -0.3125, -0.375},
					{0.0625, 0.0625, -0.5, 0.1875, 0.1875, -0.375},
					{0.125, 0.125, -0.5, 0.25, 0.25, -0.375},
					{0.1875, 0.1875, -0.5, 0.3125, 0.3125, -0.375},
					{0.25, 0.25, -0.5, 0.375, 0.375, -0.375},
					{0.3125, 0.3125, -0.5, 0.4375, 0.4375, -0.375},
					{-0.1875, 0.0625, -0.5, -0.0625, 0.1875, -0.375},
					{-0.25, 0.125, -0.5, -0.125, 0.25, -0.375},
					{-0.3125, 0.1875, -0.5, -0.1875, 0.3125, -0.375},
					{-0.375, 0.25, -0.5, -0.25, 0.375, -0.375},
					{-0.4375, 0.3125, -0.5, -0.3125, 0.4375, -0.375},
					{-0.4375, 0.5625, -0.5, -0.3125, 0.6875, -0.375},
					{-0.375, 0.625, -0.5, -0.25, 0.75, -0.375},
					{-0.3125, 0.6875, -0.5, -0.1875, 0.8125, -0.375},
					{-0.25, 0.75, -0.5, -0.125, 0.875, -0.375},
					{-0.1875, 0.8125, -0.5, -0.0625001, 0.9375, -0.375},
					{0.3125, 0.5625, -0.5, 0.4375, 0.6875, -0.375},
					{0.25, 0.625, -0.5, 0.375, 0.75, -0.375},
					{0.1875, 0.6875, -0.5, 0.3125, 0.8125, -0.375},
					{0.125, 0.75, -0.5, 0.25, 0.875, -0.375},
					{0.0625, 0.8125, -0.5, 0.1875, 0.9375, -0.375},
					{-0.125, 0.875, -0.5, 0.125, 1.125, -0.375},
					{0.0625, 1.0625, -0.5, 0.1875, 1.1875, -0.375},
					{0.125, 1.125, -0.5, 0.25, 1.25, -0.375},
					{0.1875, 1.1875, -0.5, 0.3125, 1.3125, -0.375},
					{0.25, 1.25, -0.5, 0.375, 1.375, -0.375},
					{0.3125, 1.3125, -0.5, 0.4375, 1.4375, -0.375},
					{-0.1875, 1.0625, -0.5, -0.0625, 1.1875, -0.375},
					{-0.25, 1.125, -0.5, -0.125, 1.25, -0.375},
					{-0.3125, 1.1875, -0.5, -0.1875, 1.3125, -0.375},
					{-0.375, 1.25, -0.5, -0.25, 1.375, -0.375},
					{-0.4375, 1.3125, -0.5, -0.3125, 1.4375, -0.375},
					{-0.5, -0.5, 0.375, -0.375, 1.5, 0.5},
					{0.375, -0.5, 0.375, 0.5, 1.5, 0.5},
					{-0.4375, -0.4375, 0.375, -0.3125, -0.3125, 0.5},
					{-0.375, -0.375, 0.375, -0.25, -0.25, 0.5},
					{-0.3125, -0.3125, 0.375, -0.1875, -0.1875, 0.5},
					{-0.25, -0.25, 0.375, -0.125, -0.125, 0.5},
					{-0.1875, -0.1875, 0.375, -0.0625, -0.0625, 0.5},
					{-0.125, -0.125, 0.375, 0.125, 0.125, 0.5},
					{0.0625, -0.1875, 0.375, 0.1875, -0.0625, 0.5},
					{0.125, -0.25, 0.375, 0.25, -0.125, 0.5},
					{0.1875, -0.3125, 0.375, 0.3125, -0.1875, 0.5},
					{0.25, -0.375, 0.375, 0.375, -0.25, 0.5},
					{0.3125, -0.4375, 0.375, 0.4375, -0.3125, 0.5},
					{-0.1875, 0.0625, 0.375, -0.0625, 0.1875, 0.5},
					{-0.25, 0.125, 0.375, -0.125, 0.25, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.3125, 0.5},
					{-0.375, 0.25, 0.375, -0.25, 0.375, 0.5},
					{-0.4375, 0.3125, 0.375, -0.3125, 0.4375, 0.5},
					{0.0625, 0.0625, 0.375, 0.1875, 0.1875, 0.5},
					{0.125, 0.125, 0.375, 0.25, 0.25, 0.5},
					{0.1875, 0.1875, 0.375, 0.3125, 0.3125, 0.5},
					{0.25, 0.25, 0.375, 0.375, 0.375, 0.5},
					{0.3125, 0.3125, 0.375, 0.4375, 0.4375, 0.5},
					{0.3125, 0.5625, 0.375, 0.4375, 0.6875, 0.5},
					{0.25, 0.625, 0.375, 0.375, 0.75, 0.5},
					{0.1875, 0.6875, 0.375, 0.3125, 0.8125, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.0625001, 0.8125, 0.375, 0.1875, 0.9375, 0.5},
					{-0.4375, 0.5625, 0.375, -0.3125, 0.6875, 0.5},
					{-0.375, 0.625, 0.375, -0.25, 0.75, 0.5},
					{-0.3125, 0.6875, 0.375, -0.1875, 0.8125, 0.5},
					{-0.25, 0.75, 0.375, -0.125, 0.875, 0.5},
					{-0.1875, 0.8125, 0.375, -0.0625, 0.9375, 0.5},
					{-0.125, 0.875, 0.375, 0.125, 1.125, 0.5},
					{-0.1875, 1.0625, 0.375, -0.0625, 1.1875, 0.5},
					{-0.25, 1.125, 0.375, -0.125, 1.25, 0.5},
					{-0.3125, 1.1875, 0.375, -0.1875, 1.3125, 0.5},
					{-0.375, 1.25, 0.375, -0.25, 1.375, 0.5},
					{-0.4375, 1.3125, 0.375, -0.3125, 1.4375, 0.5},
					{0.0625, 1.0625, 0.375, 0.1875, 1.1875, 0.5},
					{0.125, 1.125, 0.375, 0.25, 1.25, 0.5},
					{0.1875, 1.1875, 0.375, 0.3125, 1.3125, 0.5},
					{0.25, 1.25, 0.375, 0.375, 1.375, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.375, -0.4375, 0.3125, 0.5, -0.3125, 0.4375},
					{0.375, -0.375, 0.25, 0.5, -0.25, 0.375},
					{0.375, -0.3125, 0.1875, 0.5, -0.1875, 0.3125},
					{0.375, -0.25, 0.125, 0.5, -0.125, 0.25},
					{0.375, -0.1875, 0.0625, 0.5, -0.0625, 0.1875},
					{0.375, -0.125, -0.125, 0.5, 0.125, 0.125},
					{0.375, -0.1875, -0.1875, 0.5, -0.0625, -0.0625},
					{0.375, -0.25, -0.25, 0.5, -0.125, -0.125},
					{0.375, -0.3125, -0.3125, 0.5, -0.1875, -0.1875},
					{0.375, -0.375, -0.375, 0.5, -0.25, -0.25},
					{0.375, -0.4375, -0.4375, 0.5, -0.3125, -0.3125},
					{0.375, 0.0625, 0.0625, 0.5, 0.1875, 0.1875},
					{0.375, 0.125, 0.125, 0.5, 0.25, 0.25},
					{0.375, 0.1875, 0.1875, 0.5, 0.3125, 0.3125},
					{0.375, 0.25, 0.25, 0.5, 0.375, 0.375},
					{0.375, 0.3125, 0.3125, 0.5, 0.4375, 0.4375},
					{0.375, 0.0625, -0.1875, 0.5, 0.1875, -0.0625},
					{0.375, 0.125, -0.25, 0.5, 0.25, -0.125},
					{0.375, 0.1875, -0.3125, 0.5, 0.3125, -0.1875},
					{0.375, 0.25, -0.375, 0.5, 0.375, -0.25},
					{0.375, 0.3125, -0.4375, 0.5, 0.4375, -0.3125},
					{0.375, 0.5625, -0.4375, 0.5, 0.6875, -0.3125},
					{0.375, 0.625, -0.375, 0.5, 0.75, -0.25},
					{0.375, 0.6875, -0.3125, 0.5, 0.8125, -0.1875},
					{0.375, 0.75, -0.25, 0.5, 0.875, -0.125},
					{0.375, 0.8125, -0.1875, 0.5, 0.9375, -0.0625001},
					{0.375, 0.5625, 0.3125, 0.5, 0.6875, 0.4375},
					{0.375, 0.625, 0.25, 0.5, 0.75, 0.375},
					{0.375, 0.6875, 0.1875, 0.5, 0.8125, 0.3125},
					{0.375, 0.75, 0.125, 0.5, 0.875, 0.25},
					{0.375, 0.8125, 0.0625, 0.5, 0.9375, 0.1875},
					{0.375, 0.875, -0.125, 0.5, 1.125, 0.125},
					{0.375, 1.0625, 0.0625, 0.5, 1.1875, 0.1875},
					{0.375, 1.125, 0.125, 0.5, 1.25, 0.25},
					{0.375, 1.1875, 0.1875, 0.5, 1.3125, 0.3125},
					{0.375, 1.25, 0.25, 0.5, 1.375, 0.375},
					{0.375, 1.3125, 0.3125, 0.5, 1.4375, 0.4375},
					{0.375, 1.0625, -0.1875, 0.5, 1.1875, -0.0625},
					{0.375, 1.125, -0.25, 0.5, 1.25, -0.125},
					{0.375, 1.1875, -0.3125, 0.5, 1.3125, -0.1875},
					{0.375, 1.25, -0.375, 0.5, 1.375, -0.25},
					{0.375, 1.3125, -0.4375, 0.5, 1.4375, -0.3125},
					{-0.5, -0.4375, -0.4375, -0.375, -0.3125, -0.3125},
					{-0.5, -0.375, -0.375, -0.375, -0.25, -0.25},
					{-0.5, -0.3125, -0.3125, -0.375, -0.1875, -0.1875},
					{-0.5, -0.25, -0.25, -0.375, -0.125, -0.125},
					{-0.5, -0.1875, -0.1875, -0.375, -0.0625, -0.0625},
					{-0.5, -0.125, -0.125, -0.375, 0.125, 0.125},
					{-0.5, -0.1875, 0.0625, -0.375, -0.0625, 0.1875},
					{-0.5, -0.25, 0.125, -0.375, -0.125, 0.25},
					{-0.5, -0.3125, 0.1875, -0.375, -0.1875, 0.3125},
					{-0.5, -0.375, 0.25, -0.375, -0.25, 0.375},
					{-0.5, -0.4375, 0.3125, -0.375, -0.3125, 0.4375},
					{-0.5, 0.0625, -0.1875, -0.375, 0.1875, -0.0625},
					{-0.5, 0.125, -0.25, -0.375, 0.25, -0.125},
					{-0.5, 0.1875, -0.3125, -0.375, 0.3125, -0.1875},
					{-0.5, 0.25, -0.375, -0.375, 0.375, -0.25},
					{-0.5, 0.3125, -0.4375, -0.375, 0.4375, -0.3125},
					{-0.5, 0.0625, 0.0625, -0.375, 0.1875, 0.1875},
					{-0.5, 0.125, 0.125, -0.375, 0.25, 0.25},
					{-0.5, 0.1875, 0.1875, -0.375, 0.3125, 0.3125},
					{-0.5, 0.25, 0.25, -0.375, 0.375, 0.375},
					{-0.5, 0.3125, 0.3125, -0.375, 0.4375, 0.4375},
					{-0.5, 0.5625, 0.3125, -0.375, 0.6875, 0.4375},
					{-0.5, 0.625, 0.25, -0.375, 0.75, 0.375},
					{-0.5, 0.6875, 0.1875, -0.375, 0.8125, 0.3125},
					{-0.5, 0.75, 0.125, -0.375, 0.875, 0.25},
					{-0.5, 0.8125, 0.0625001, -0.375, 0.9375, 0.1875},
					{-0.5, 0.5625, -0.4375, -0.375, 0.6875, -0.3125},
					{-0.5, 0.625, -0.375, -0.375, 0.75, -0.25},
					{-0.5, 0.6875, -0.3125, -0.375, 0.8125, -0.1875},
					{-0.5, 0.75, -0.25, -0.375, 0.875, -0.125},
					{-0.5, 0.8125, -0.1875, -0.375, 0.9375, -0.0625},
					{-0.5, 0.875, -0.125, -0.375, 1.125, 0.125},
					{-0.5, 1.0625, -0.1875, -0.375, 1.1875, -0.0625},
					{-0.5, 1.125, -0.25, -0.375, 1.25, -0.125},
					{-0.5, 1.1875, -0.3125, -0.375, 1.3125, -0.1875},
					{-0.5, 1.25, -0.375, -0.375, 1.375, -0.25},
					{-0.5, 1.3125, -0.4375, -0.375, 1.4375, -0.3125},
					{-0.5, 1.0625, 0.0625, -0.375, 1.1875, 0.1875},
					{-0.5, 1.125, 0.125, -0.375, 1.25, 0.25},
					{-0.5, 1.1875, 0.1875, -0.375, 1.3125, 0.3125},
					{-0.5, 1.25, 0.25, -0.375, 1.375, 0.375},
					{-0.5, 1.3125, 0.3125, -0.375, 1.4375, 0.4375},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, -0.5, 0.5, 1.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:medium_support_" .. bridge_color, {
			description = bridge_desc .. " Medium Support",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_medium_support.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_medium_support.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-1.5, -0.5, 0.3125, -1.25, 2.5, 0.5625},
					{1.25, -0.5, 0.3125, 1.5, 2.5, 0.5625},
					{-1.4375, 2.3125, 0.375, -1.3125, 2.4375, 0.5},
					{-1.375, 2.25, 0.375, -1.25, 2.375, 0.5},
					{-1.3125, 2.1875, 0.375, -1.1875, 2.3125, 0.5},
					{-1.25, 2.125, 0.375, -1.125, 2.25, 0.5},
					{-1.1875, 2.0625, 0.375, -1.0625, 2.1875, 0.5},
					{-1.125, 2, 0.375, -1, 2.125, 0.5},
					{-1.0625, 1.9375, 0.375, -0.9375, 2.0625, 0.5},
					{-1, 1.875, 0.375, -0.875, 2, 0.5},
					{-0.9375, 1.8125, 0.375, -0.8125, 1.9375, 0.5},
					{-0.875, 1.75, 0.375, -0.75, 1.875, 0.5},
					{-0.8125, 1.6875, 0.375, -0.6875, 1.8125, 0.5},
					{-0.75, 1.625, 0.375, -0.625, 1.75, 0.5},
					{-0.6875, 1.5625, 0.375, -0.5625, 1.6875, 0.5},
					{-0.625, 1.5, 0.375, -0.5, 1.625, 0.5},
					{-0.5625, 1.4375, 0.375, -0.4375, 1.5625, 0.5},
					{-0.5, 1.375, 0.375, -0.375, 1.5, 0.5},
					{-0.4375, 1.3125, 0.375, -0.3125, 1.4375, 0.5},
					{-0.375, 1.25, 0.375, -0.25, 1.375, 0.5},
					{-0.3125, 1.1875, 0.375, -0.1875, 1.3125, 0.5},
					{-0.25, 1.125, 0.375, -0.125, 1.25, 0.5},
					{-0.1875, 1.0625, 0.375, -0.0625, 1.1875, 0.5},
					{-0.125, 0.875, 0.375, 0.125, 1.125, 0.5},
					{0.0625, 0.8125, 0.375, 0.1875, 0.9375, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.1875, 0.6875, 0.375, 0.3125, 0.8125, 0.5},
					{0.25, 0.625, 0.375, 0.375, 0.75, 0.5},
					{0.3125, 0.5625, 0.375, 0.4375, 0.6875, 0.5},
					{0.375, 0.5, 0.375, 0.5, 0.625, 0.5},
					{0.4375, 0.4375, 0.375, 0.5625, 0.5625, 0.5},
					{0.5, 0.375, 0.375, 0.625, 0.5, 0.5},
					{0.5625, 0.3125, 0.375, 0.6875, 0.4375, 0.5},
					{0.625, 0.25, 0.375, 0.75, 0.375, 0.5},
					{0.6875, 0.1875, 0.375, 0.8125, 0.3125, 0.5},
					{0.75, 0.125, 0.375, 0.875, 0.25, 0.5},
					{0.8125, 0.0625, 0.375, 0.9375, 0.1875, 0.5},
					{0.875, 0, 0.375, 1, 0.125, 0.5},
					{0.9375, -0.0625, 0.375, 1.0625, 0.0625, 0.5},
					{1, -0.125, 0.375, 1.125, 0, 0.5},
					{1.0625, -0.1875, 0.375, 1.1875, -0.0625, 0.5},
					{1.125, -0.25, 0.375, 1.25, -0.125, 0.5},
					{1.1875, -0.3125, 0.375, 1.3125, -0.1875, 0.5},
					{1.25, -0.375, 0.375, 1.375, -0.25, 0.5},
					{1.3125, -0.4375, 0.375, 1.4375, -0.3125, 0.5},
					{1.3125, 2.3125, 0.375, 1.4375, 2.4375, 0.5},
					{1.25, 2.25, 0.375, 1.375, 2.375, 0.5},
					{1.1875, 2.1875, 0.375, 1.3125, 2.3125, 0.5},
					{1.125, 2.125, 0.375, 1.25, 2.25, 0.5},
					{1.0625, 2.0625, 0.375, 1.1875, 2.1875, 0.5},
					{1, 2, 0.375, 1.125, 2.125, 0.5},
					{0.9375, 1.9375, 0.375, 1.0625, 2.0625, 0.5},
					{0.875, 1.875, 0.375, 1, 2, 0.5},
					{0.8125, 1.8125, 0.375, 0.9375, 1.9375, 0.5},
					{0.75, 1.75, 0.375, 0.875, 1.875, 0.5},
					{0.6875, 1.6875, 0.375, 0.8125, 1.8125, 0.5},
					{0.625, 1.625, 0.375, 0.75, 1.75, 0.5},
					{0.5625, 1.5625, 0.375, 0.6875, 1.6875, 0.5},
					{0.5, 1.5, 0.375, 0.625, 1.625, 0.5},
					{0.4375, 1.4375, 0.375, 0.5625, 1.5625, 0.5},
					{0.375, 1.375, 0.375, 0.5, 1.5, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.25, 1.25, 0.375, 0.375, 1.375, 0.5},
					{0.1875, 1.1875, 0.375, 0.3125, 1.3125, 0.5},
					{0.125, 1.125, 0.375, 0.25, 1.25, 0.5},
					{0.0625, 1.0625, 0.375, 0.1875, 1.1875, 0.5},
					{-0.1875, 0.8125, 0.375, -0.0625, 0.9375, 0.5},
					{-0.25, 0.75, 0.375, -0.125, 0.875, 0.5},
					{-0.3125, 0.6875, 0.375, -0.1875, 0.8125, 0.5},
					{-0.375, 0.625, 0.375, -0.25, 0.75, 0.5},
					{-0.4375, 0.5625, 0.375, -0.3125, 0.6875, 0.5},
					{-0.5, 0.5, 0.375, -0.375, 0.625, 0.5},
					{-0.5625, 0.4375, 0.375, -0.4375, 0.5625, 0.5},
					{-0.625, 0.375, 0.375, -0.5, 0.5, 0.5},
					{-0.6875, 0.3125, 0.375, -0.5625, 0.4375, 0.5},
					{-0.75, 0.25, 0.375, -0.625, 0.375, 0.5},
					{-0.8125, 0.1875, 0.375, -0.6875, 0.3125, 0.5},
					{-0.875, 0.125, 0.375, -0.75, 0.25, 0.5},
					{-0.9375, 0.0625, 0.375, -0.8125, 0.1875, 0.5},
					{-1, 0, 0.375, -0.875, 0.125, 0.5},
					{-1.0625, -0.0625, 0.375, -0.9375, 0.0625, 0.5},
					{-1.125, -0.125, 0.375, -1, 0, 0.5},
					{-1.1875, -0.1875, 0.375, -1.0625, -0.0625, 0.5},
					{-1.25, -0.25, 0.375, -1.125, -0.125, 0.5},
					{-1.3125, -0.3125, 0.375, -1.1875, -0.1875, 0.5},
					{-1.375, -0.375, 0.375, -1.25, -0.25, 0.5},
					{-1.4375, -0.4375, 0.375, -1.3125, -0.3125, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-1.5, -0.5, 0, 1.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:medium_support_bot_" .. bridge_color, {
			description = bridge_desc .. " Bottom Medium Support",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_medium_support_bot.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_medium_support_bot.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-1.5625, -0.5, 0.25, -1.1875, 0.5, 0.625},
					{1.1875, -0.5, 0.25, 1.5625, 0.5, 0.625},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-1.5, -0.5, 0, 1.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:large_support_" .. bridge_color, {
			description = bridge_desc .. " Large Support",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_large_support.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_large_support.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-2.5, -0.5, 0.3125, -2.25, 2.5, 0.5625},
					{2.25, -0.5, 0.3125, 2.5, 2.5, 0.5625},
					{2.25, 2.375, 0.375, 2.375, 2.5, 0.5},
					{2.125, 2.3125, 0.375, 2.3125, 2.4375, 0.5},
					{2, 2.25, 0.375, 2.1875, 2.375, 0.5},
					{1.9375, 2.1875, 0.375, 2.0625, 2.3125, 0.5},
					{1.8125, 2.125, 0.375, 2, 2.25, 0.5},
					{1.75, 2.0625, 0.375, 1.875, 2.1875, 0.5},
					{1.625, 2, 0.375, 1.8125, 2.125, 0.5},
					{1.5, 1.9375, 0.375, 1.6875, 2.0625, 0.5},
					{1.4375, 1.875, 0.375, 1.5625, 2, 0.5},
					{1.3125, 1.8125, 0.375, 1.5, 1.9375, 0.5},
					{1.25, 1.75, 0.375, 1.375, 1.875, 0.5},
					{1.125, 1.6875, 0.375, 1.3125, 1.8125, 0.5},
					{1, 1.625, 0.375, 1.1875, 1.75, 0.5},
					{0.9375, 1.5625, 0.375, 1.0625, 1.6875, 0.5},
					{0.8125, 1.5, 0.375, 1, 1.625, 0.5},
					{0.75, 1.4375, 0.375, 0.875, 1.5625, 0.5},
					{0.625, 1.375, 0.375, 0.8125, 1.5, 0.5},
					{0.5, 1.3125, 0.375, 0.6875, 1.4375, 0.5},
					{0.4375, 1.25, 0.375, 0.5625, 1.375, 0.5},
					{0.3125, 1.1875, 0.375, 0.5, 1.3125, 0.5},
					{0.25, 1.125, 0.375, 0.375, 1.25, 0.5},
					{0.125, 1.0625, 0.375, 0.3125, 1.1875, 0.5},
					{0, 1, 0.375, 0.1875, 1.125, 0.5},
					{-2.375, -0.5, 0.375, -2.25, -0.375, 0.5},
					{-2.3125, -0.4375, 0.375, -2.125, -0.3125, 0.5},
					{-2.1875, -0.375, 0.375, -2, -0.25, 0.5},
					{-2.0625, -0.3125, 0.375, -1.9375, -0.1875, 0.5},
					{-2, -0.25, 0.375, -1.8125, -0.125, 0.5},
					{-1.875, -0.1875, 0.375, -1.75, -0.0625, 0.5},
					{-1.8125, -0.125, 0.375, -1.625, 0, 0.5},
					{-1.6875, -0.0625, 0.375, -1.5, 0.0625, 0.5},
					{-1.5625, 0, 0.375, -1.4375, 0.125, 0.5},
					{-1.5, 0.0625, 0.375, -1.3125, 0.1875, 0.5},
					{-1.375, 0.125, 0.375, -1.25, 0.25, 0.5},
					{-1.3125, 0.1875, 0.375, -1.125, 0.3125, 0.5},
					{-1.1875, 0.25, 0.375, -1, 0.375, 0.5},
					{-1.0625, 0.3125, 0.375, -0.9375, 0.4375, 0.5},
					{-1, 0.375, 0.375, -0.8125, 0.5, 0.5},
					{-0.875, 0.4375, 0.375, -0.75, 0.5625, 0.5},
					{-0.8125, 0.5, 0.375, -0.625, 0.625, 0.5},
					{-0.6875, 0.5625, 0.375, -0.5, 0.6875, 0.5},
					{-0.5625, 0.625, 0.375, -0.4375, 0.75, 0.5},
					{-0.5, 0.6875, 0.375, -0.3125, 0.8125, 0.5},
					{-0.375, 0.75, 0.375, -0.25, 0.875, 0.5},
					{-0.3125, 0.8125, 0.375, -0.125, 0.9375, 0.5},
					{-0.1875, 0.875, 0.375, 0, 1, 0.5},
					{-2.375, 2.375, 0.375, -2.25, 2.5, 0.5},
					{-2.3125, 2.3125, 0.375, -2.125, 2.4375, 0.5},
					{-2.1875, 2.25, 0.375, -2, 2.375, 0.5},
					{-2.0625, 2.1875, 0.375, -1.9375, 2.3125, 0.5},
					{-2, 2.125, 0.375, -1.8125, 2.25, 0.5},
					{-1.875, 2.0625, 0.375, -1.75, 2.1875, 0.5},
					{-1.8125, 2, 0.375, -1.625, 2.125, 0.5},
					{-1.6875, 1.9375, 0.375, -1.5, 2.0625, 0.5},
					{-1.5625, 1.875, 0.375, -1.4375, 2, 0.5},
					{-1.5, 1.8125, 0.375, -1.3125, 1.9375, 0.5},
					{-1.375, 1.75, 0.375, -1.25, 1.875, 0.5},
					{-1.3125, 1.6875, 0.375, -1.125, 1.8125, 0.5},
					{-1.1875, 1.625, 0.375, -1, 1.75, 0.5},
					{-1.0625, 1.5625, 0.375, -0.9375, 1.6875, 0.5},
					{-1, 1.5, 0.375, -0.8125, 1.625, 0.5},
					{-0.875, 1.4375, 0.375, -0.75, 1.5625, 0.5},
					{-0.8125, 1.375, 0.375, -0.625, 1.5, 0.5},
					{-0.6875, 1.3125, 0.375, -0.5, 1.4375, 0.5},
					{-0.5625, 1.25, 0.375, -0.4375, 1.375, 0.5},
					{-0.5, 1.1875, 0.375, -0.3125, 1.3125, 0.5},
					{-0.375, 1.125, 0.375, -0.25, 1.25, 0.5},
					{-0.3125, 1.0625, 0.375, -0.125, 1.1875, 0.5},
					{-0.1875, 1, 0.375, -0, 1.125, 0.5},
					{2.25, -0.5, 0.375, 2.375, -0.375, 0.5},
					{2.125, -0.4375, 0.375, 2.3125, -0.3125, 0.5},
					{2, -0.375, 0.375, 2.1875, -0.25, 0.5},
					{1.9375, -0.3125, 0.375, 2.0625, -0.1875, 0.5},
					{1.8125, -0.25, 0.375, 2, -0.125, 0.5},
					{1.75, -0.1875, 0.375, 1.875, -0.0625, 0.5},
					{1.625, -0.125, 0.375, 1.8125, 0, 0.5},
					{1.5, -0.0625, 0.375, 1.6875, 0.0625, 0.5},
					{1.4375, 0, 0.375, 1.5625, 0.125, 0.5},
					{1.3125, 0.0625, 0.375, 1.5, 0.1875, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.25, 0.5},
					{1.125, 0.1875, 0.375, 1.3125, 0.3125, 0.5},
					{1, 0.25, 0.375, 1.1875, 0.375, 0.5},
					{0.9375, 0.3125, 0.375, 1.0625, 0.4375, 0.5},
					{0.8125, 0.375, 0.375, 1, 0.5, 0.5},
					{0.75, 0.4375, 0.375, 0.875, 0.5625, 0.5},
					{0.625, 0.5, 0.375, 0.8125, 0.625, 0.5},
					{0.5, 0.5625, 0.375, 0.6875, 0.6875, 0.5},
					{0.4375, 0.625, 0.375, 0.5625, 0.75, 0.5},
					{0.3125, 0.6875, 0.375, 0.5, 0.8125, 0.5},
					{0.25, 0.75, 0.375, 0.375, 0.875, 0.5},
					{0.125, 0.8125, 0.375, 0.3125, 0.9375, 0.5},
					{-0, 0.875, 0.375, 0.1875, 1, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-2.5, -0.5, 0, 2.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:large_support_bot_" .. bridge_color, {
			description = bridge_desc .. " Bottom Large Support",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_large_support_bot.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_large_support_bot.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-2.5625, -0.5, 0.25, -2.1875, 0.5, 0.625},
					{2.1875, -0.5, 0.25, 2.5625, 0.5, 0.625},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-2.5, -0.5, 0, 2.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_right_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Right Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_superstructure_right_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_superstructure_right_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 2.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 2.5, 0.5},
					{-0.5, 2.375, 0.375, 1.5, 2.5, 0.5},
					{-0.4375, 2.25, 0.375, -0.3125, 2.375, 0.5},
					{-0.375, 2.1875, 0.375, -0.25, 2.3125, 0.5},
					{-0.3125, 2.0625, 0.375, -0.1875, 2.25, 0.5},
					{-0.25, 2, 0.375, -0.125, 2.125, 0.5},
					{-0.1875, 1.9375, 0.375, -0.0625, 2.0625, 0.5},
					{-0.125, 1.875, 0.375, 0, 2, 0.5},
					{-0.0625, 1.75, 0.375, 0.0625, 1.9375, 0.5},
					{0, 1.6875, 0.375, 0.125, 1.8125, 0.5},
					{0.0625, 1.625, 0.375, 0.1875, 1.75, 0.5},
					{0.125, 1.5625, 0.375, 0.25, 1.6875, 0.5},
					{0.1875, 1.4375, 0.375, 0.3125, 1.625, 0.5},
					{0.25, 1.375, 0.375, 0.375, 1.5, 0.5},
					{0.3125, 1.3125, 0.375, 0.4375, 1.4375, 0.5},
					{0.375, 1.25, 0.375, 0.5, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.5, 1.0625, 0.375, 0.625, 1.1875, 0.5},
					{0.5625, 1, 0.375, 0.6875, 1.125, 0.5},
					{0.625, 0.9375, 0.375, 0.75, 1.0625, 0.5},
					{0.6875, 0.8125, 0.375, 0.8125, 1, 0.5},
					{0.75, 0.75, 0.375, 0.875, 0.875, 0.5},
					{0.8125, 0.6875, 0.375, 0.9375, 0.8125, 0.5},
					{0.875, 0.625, 0.375, 1, 0.75, 0.5},
					{0.9375, 0.5, 0.375, 1.0625, 0.6875, 0.5},
					{1, 0.4375, 0.375, 1.125, 0.5625, 0.5},
					{1.0625, 0.375, 0.375, 1.1875, 0.5, 0.5},
					{1.125, 0.3125, 0.375, 1.25, 0.4375, 0.5},
					{1.1875, 0.1875, 0.375, 1.3125, 0.375, 0.5},
					{1.25, 0.125, 0.375, 1.375, 0.25, 0.5},
					{1.3125, 0.0625, 0.375, 1.4375, 0.1875, 0.5},
					{1.375, 0, 0.375, 1.5, 0.125, 0.5},
					{-0.4375, 2.3125, 0.375, -0.3125, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:truss_superstructure_left_slant_" .. bridge_color, {
			description = bridge_desc .. " Truss Superstructure Left Slant",
			drawtype = "nodebox",
			tiles = {"bridges_" .. bridge_color .. ".png"},
			inventory_image = "bridges_" .. bridge_color .. ".png^bridges_superstructure_left_slant.png^[makealpha:255,126,126",
			wield_image = "bridges_" .. bridge_color .. ".png^bridges_superstructure_left_slant.png^[makealpha:255,126,126",
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 0.0625, 0.5},
					{-0.5, -0.5, 0.375, -0.4375, 2.5, 0.5},
					{1.4375, -0.5, 0.375, 1.5, 2.5, 0.5},
					{-0.5, 2.375, 0.375, 1.5, 2.5, 0.5},
					{1.3125, 2.25, 0.375, 1.4375, 2.375, 0.5},
					{1.25, 2.1875, 0.375, 1.375, 2.3125, 0.5},
					{1.1875, 2.0625, 0.375, 1.3125, 2.25, 0.5},
					{1.125, 2, 0.375, 1.25, 2.125, 0.5},
					{1.0625, 1.9375, 0.375, 1.1875, 2.0625, 0.5},
					{1, 1.875, 0.375, 1.125, 2, 0.5},
					{0.9375, 1.75, 0.375, 1.0625, 1.9375, 0.5},
					{0.875, 1.6875, 0.375, 1, 1.8125, 0.5},
					{0.8125, 1.625, 0.375, 0.9375, 1.75, 0.5},
					{0.75, 1.5625, 0.375, 0.875, 1.6875, 0.5},
					{0.6875, 1.4375, 0.375, 0.8125, 1.625, 0.5},
					{0.625, 1.375, 0.375, 0.75, 1.5, 0.5},
					{0.5625, 1.3125, 0.375, 0.6875, 1.4375, 0.5},
					{0.5, 1.25, 0.375, 0.625, 1.375, 0.5},
					{0.4375, 1.125, 0.375, 0.5625, 1.3125, 0.5},
					{0.375, 1.0625, 0.375, 0.5, 1.1875, 0.5},
					{0.3125, 1, 0.375, 0.4375, 1.125, 0.5},
					{0.25, 0.9375, 0.375, 0.375, 1.0625, 0.5},
					{0.1875, 0.8125, 0.375, 0.3125, 1, 0.5},
					{0.125, 0.75, 0.375, 0.25, 0.875, 0.5},
					{0.0625, 0.6875, 0.375, 0.1875, 0.8125, 0.5},
					{0, 0.625, 0.375, 0.125, 0.75, 0.5},
					{-0.0625, 0.5, 0.375, 0.0625, 0.6875, 0.5},
					{-0.125, 0.4375, 0.375, 0, 0.5625, 0.5},
					{-0.1875, 0.375, 0.375, -0.0625, 0.5, 0.5},
					{-0.25, 0.3125, 0.375, -0.125, 0.4375, 0.5},
					{-0.3125, 0.1875, 0.375, -0.1875, 0.375, 0.5},
					{-0.375, 0.125, 0.375, -0.25, 0.25, 0.5},
					{-0.4375, 0.0625, 0.375, -0.3125, 0.1875, 0.5},
					{-0.5, 0, 0.375, -0.375, 0.125, 0.5},
					{1.375, 2.3125, 0.375, 1.5, 2.4375, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			collision_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 1.5, 2.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:corrugated_steel_" .. bridge_color, {
			description = bridge_desc .. " Corrugated Steel",
			drawtype = "nodebox",
			tiles = {"bridges_corrugated_steel_" .. bridge_color .. ".png"},
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0.375, 0.5, 0.5, 0.5},
				},
			},
			selection_box = {
				type = "fixed",
				fixed = {
					{-0.5, -0.5, 0, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})

		minetest.register_node("bridger:corrugated_steel_ceiling_" .. bridge_color, {
			description = bridge_desc .. " Corrugated Steel Deck",
			drawtype = "nodebox",
			tiles = {"bridges_corrugated_steel_" .. bridge_color .. ".png^[transformR90"},
			paramtype = "light",
			paramtype2 = "facedir",
			sunlight_propagates = true,
			node_box = {
				type = "fixed",
				fixed = {
					{-0.5, 0.375, -0.5, 0.5, 0.5, 0.5},
				},
			},
			groups = {cracky=3},
			sounds = default.node_sound_metal_defaults(),
		})
	end
end

if minetest.settings:get_bool("bridger_enable_trestles", true) then
	minetest.register_node("bridger:trestle_support", {
		description = "Trestle Support",
		drawtype = "nodebox",
		tiles = {"default_junglewood.png"},
		inventory_image = "default_junglewood.png^bridges_trestle_support.png^[makealpha:255,126,126",
		wield_image = "default_junglewood.png^bridges_trestle_support.png^[makealpha:255,126,126",
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-1, -0.5, -0.125, -0.75, 1.5, 0.125},
				{0.75, -0.5, -0.125, 1, 1.5, 0.125},
				{0.625, 1.375, -0.0625, 0.75, 1.5, 0.0625},
				{0.5625, 1.25, -0.0625, 0.6875, 1.4375, 0.0625},
				{0.5, 1.1875, -0.0625, 0.625, 1.3125, 0.0625},
				{0.4375, 1.125, -0.0625, 0.5625, 1.25, 0.0625},
				{0.375, 1, -0.0625, 0.5, 1.1875, 0.0625},
				{0.3125, 0.9375, -0.0625, 0.4375, 1.0625, 0.0625},
				{0.25, 0.875, -0.0625, 0.375, 1, 0.0625},
				{0.1875, 0.75, -0.0625, 0.3125, 0.9375, 0.0625},
				{0.125, 0.6875, -0.0625, 0.25, 0.8125, 0.0625},
				{0.0625, 0.625, -0.0625, 0.1875, 0.75, 0.0625},
				{0, 0.5, -0.0625, 0.125, 0.6875, 0.0625},
				{-0.0625, 0.4375, -0.0625, 0.0625, 0.5625, 0.0625},
				{-0.125, 0.3125, -0.0625, 0, 0.5, 0.0625},
				{-0.1875, 0.25, -0.0625, -0.0625, 0.375, 0.0625},
				{-0.25, 0.1875, -0.0625, -0.125, 0.3125, 0.0625},
				{-0.3125, 0.0625, -0.0625, -0.1875, 0.25, 0.0625},
				{-0.375, 0, -0.0625, -0.25, 0.125, 0.0625},
				{-0.4375, -0.0625, -0.0625, -0.3125, 0.0625, 0.0625},
				{-0.5, -0.1875, -0.0625, -0.375, 0, 0.0625},
				{-0.5625, -0.25, -0.0625, -0.4375, -0.125, 0.0625},
				{-0.625, -0.3125, -0.0625, -0.5, -0.1875, 0.0625},
				{-0.6875, -0.4375, -0.0625, -0.5625, -0.25, 0.0625},
				{-0.75, -0.5, -0.0625, -0.625, -0.375, 0.0625},
				{-0.75, 1.375, -0.0625, -0.625, 1.5, 0.0625},
				{-0.6875, 1.25, -0.0625, -0.5625, 1.4375, 0.0625},
				{-0.625, 1.1875, -0.0625, -0.5, 1.3125, 0.0625},
				{-0.5625, 1.125, -0.0625, -0.4375, 1.25, 0.0625},
				{-0.5, 1, -0.0625, -0.375, 1.1875, 0.0625},
				{-0.4375, 0.9375, -0.0625, -0.3125, 1.0625, 0.0625},
				{-0.375, 0.875, -0.0625, -0.25, 1, 0.0625},
				{-0.3125, 0.75, -0.0625, -0.1875, 0.9375, 0.0625},
				{-0.25, 0.6875, -0.0625, -0.125, 0.8125, 0.0625},
				{-0.1875, 0.625, -0.0625, -0.0625, 0.75, 0.0625},
				{-0.125, 0.5, -0.0625, -0, 0.6875, 0.0625},
				{-0, 0.3125, -0.0625, 0.125, 0.5, 0.0625},
				{0.0625, 0.25, -0.0625, 0.1875, 0.375, 0.0625},
				{0.125, 0.1875, -0.0625, 0.25, 0.3125, 0.0625},
				{0.1875, 0.0625, -0.0625, 0.3125, 0.25, 0.0625},
				{0.25, 0, -0.0625, 0.375, 0.125, 0.0625},
				{0.3125, -0.0625, -0.0625, 0.4375, 0.0625, 0.0625},
				{0.375, -0.1875, -0.0625, 0.5, 0, 0.0625},
				{0.4375, -0.25, -0.0625, 0.5625, -0.125, 0.0625},
				{0.5, -0.3125, -0.0625, 0.625, -0.1875, 0.0625},
				{0.5625, -0.4375, -0.0625, 0.6875, -0.25, 0.0625},
				{0.625, -0.5, -0.0625, 0.75, -0.375, 0.0625},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-1, -0.5, -0.1875, 1, 1.5, 0.1875},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:trestle_support_small", {
		description = "Small Trestle Support",
		drawtype = "nodebox",
		tiles = {"default_junglewood.png"},
		inventory_image = "default_junglewood.png^bridges_trestle_support_small.png^[makealpha:255,126,126",
		wield_image = "default_junglewood.png^bridges_trestle_support_small.png^[makealpha:255,126,126",
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-1, -0.5, -0.125, -0.75, 0.5, 0.125},
				{0.75, -0.5, -0.125, 1, 0.5, 0.125},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-1, -0.5, -0.1875, 1, 0.5, 0.1875},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:trestle_side", {
		description = "Trestle Siding",
		drawtype = "nodebox",
		tiles = {"default_junglewood.png"},
		inventory_image = "default_junglewood.png^bridges_trestle_side.png^[makealpha:255,126,126",
		wield_image = "default_junglewood.png^bridges_trestle_side.png^[makealpha:255,126,126",
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.875, -0.5, -0.0625, 0.875, -0.375, 0.0625},
				{-0.875, 1.375, -0.0625, 0.875, 1.5, 0.0625},
				{-1, 1.375, -0.0625, 1, 1.5, 0},
				{-1, -0.5, -0.0625, 1, -0.375, 0},
				{-0.9375, 1.3125, -0.0625, -0.8125, 1.4375, 0.0625},
				{-0.875, 1.25, -0.0625, -0.75, 1.375, 0.0625},
				{0.25, 0.125, -0.0625, 0.375, 0.25, 0.0625},
				{-0.8125, 1.1875, -0.0625, -0.6875, 1.3125, 0.0625},
				{-0.75, 1.125, -0.0625, -0.625, 1.25, 0.0625},
				{-0.6875, 1.0625, -0.0625, -0.5625, 1.1875, 0.0625},
				{-0.625, 1, -0.0625, -0.5, 1.125, 0.0625},
				{-0.5625, 0.9375, -0.0625, -0.4375, 1.0625, 0.0625},
				{-0.5, 0.875, -0.0625, -0.375, 1, 0.0625},
				{-0.4375, 0.8125, -0.0625, -0.3125, 0.9375, 0.0625},
				{-0.375, 0.75, -0.0625, -0.25, 0.875, 0.0625},
				{-0.3125, 0.6875, -0.0625, -0.1875, 0.8125, 0.0625},
				{-0.25, 0.625, -0.0625, -0.125, 0.75, 0.0625},
				{-0.1875, 0.5625, -0.0625, -0.0625, 0.6875, 0.0625},
				{-0.125, 0.375, -0.0625, 0.125, 0.625, 0.0625},
				{0.0625, 0.3125, -0.0625, 0.1875, 0.4375, 0.0625},
				{0.125, 0.25, -0.0625, 0.25, 0.375, 0.0625},
				{0.1875, 0.1875, -0.0625, 0.3125, 0.3125, 0.0625},
				{0.3125, 0.0625, -0.0625, 0.4375, 0.1875, 0.0625},
				{0.375, 0, -0.0625, 0.5, 0.125, 0.0625},
				{0.4375, -0.0625, -0.0625, 0.5625, 0.0625, 0.0625},
				{0.5, -0.125, -0.0625, 0.625, 0, 0.0625},
				{0.5625, -0.1875, -0.0625, 0.6875, -0.0625, 0.0625},
				{0.625, -0.25, -0.0625, 0.75, -0.125, 0.0625},
				{0.6875, -0.3125, -0.0625, 0.8125, -0.1875, 0.0625},
				{0.75, -0.375, -0.0625, 0.875, -0.25, 0.0625},
				{0.8125, -0.4375, -0.0625, 0.9375, -0.3125, 0.0625},
				{0.8125, 1.3125, -0.0625, 0.9375, 1.4375, 0.0625},
				{0.75, 1.25, -0.0625, 0.875, 1.375, 0.0625},
				{-0.375, 0.125, -0.0625, -0.25, 0.25, 0.0625},
				{0.6875, 1.1875, -0.0625, 0.8125, 1.3125, 0.0625},
				{0.625, 1.125, -0.0625, 0.75, 1.25, 0.0625},
				{0.5625, 1.0625, -0.0625, 0.6875, 1.1875, 0.0625},
				{0.5, 1, -0.0625, 0.625, 1.125, 0.0625},
				{0.4375, 0.9375, -0.0625, 0.5625, 1.0625, 0.0625},
				{0.375, 0.875, -0.0625, 0.5, 1, 0.0625},
				{0.3125, 0.8125, -0.0625, 0.4375, 0.9375, 0.0625},
				{0.25, 0.75, -0.0625, 0.375, 0.875, 0.0625},
				{0.1875, 0.6875, -0.0625, 0.3125, 0.8125, 0.0625},
				{0.125, 0.625, -0.0625, 0.25, 0.75, 0.0625},
				{0.0625, 0.5625, -0.0625, 0.1875, 0.6875, 0.0625},
				{-0.1875, 0.3125, -0.0625, -0.0625, 0.4375, 0.0625},
				{-0.25, 0.25, -0.0625, -0.125, 0.375, 0.0625},
				{-0.3125, 0.1875, -0.0625, -0.1875, 0.3125, 0.0625},
				{-0.4375, 0.0625, -0.0625, -0.3125, 0.1875, 0.0625},
				{-0.5, 0, -0.0625, -0.375, 0.125, 0.0625},
				{-0.5625, -0.0625, -0.0625, -0.4375, 0.0625, 0.0625},
				{-0.625, -0.125, -0.0625, -0.5, 0, 0.0625},
				{-0.6875, -0.1875, -0.0625, -0.5625, -0.0625, 0.0625},
				{-0.75, -0.25, -0.0625, -0.625, -0.125, 0.0625},
				{-0.8125, -0.3125, -0.0625, -0.6875, -0.1875, 0.0625},
				{-0.875, -0.375, -0.0625, -0.75, -0.25, 0.0625},
				{-0.9375, -0.4375, -0.0625, -0.8125, -0.3125, 0.0625},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-1, -0.5, -0.1875, 1, 1.5, 0.1875},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:trestle_deck", {
		description = "Trestle Deck",
		drawtype = "nodebox",
		tiles = {"default_junglewood.png"},
		inventory_image = "default_junglewood.png^bridges_trestle_deck.png^[makealpha:255,126,126",
		wield_image = "default_junglewood.png^bridges_trestle_deck.png^[makealpha:255,126,126",
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.625, 0.25, -0.5, -0.5, 0.375, 0.5},
				{0.5, 0.25, -0.5, 0.625, 0.375, 0.5},
				{-1.125, 0.374, 0.3125, 1.125, 0.501, 0.4375},
				{-1.125, 0.374, 0.0625, 1.125, 0.501, 0.1875},
				{-1.125, 0.374, -0.1875, 1.125, 0.501, -0.0625},
				{-1.125, 0.374, -0.4375, 1.125, 0.501, -0.3125},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-1.125, 0, -0.5, 1.125, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:trestle_substructure_small", {
		description = "Small Trestle Substructure",
		drawtype = "nodebox",
		tiles = {"default_junglewood.png"},
		inventory_image = "default_junglewood.png^bridges_trestle_small.png^[makealpha:255,126,126",
		wield_image = "default_junglewood.png^bridges_trestle_small.png^[makealpha:255,126,126",
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-1.5, 1.375, -0.0625, 0.5, 1.499, 0.0625},
				{-1.4375, 1.3125, -0.0625, -1.3125, 1.4375, 0.0625},
				{-1.375, 1.25, -0.0625, -1.25, 1.375, 0.0625},
				{-1.3125, 1.1875, -0.0625, -1.125, 1.3125, 0.0625},
				{-1.1875, 1.125, -0.0625, -1.0625, 1.25, 0.0625},
				{-1.125, 1.0625, -0.0625, -1, 1.1875, 0.0625},
				{-1.0625, 1, -0.0625, -0.875, 1.125, 0.0625},
				{-0.9375, 0.9375, -0.0625, -0.8125, 1.0625, 0.0625},
				{-0.875, 0.875, -0.0625, -0.75, 1, 0.0625},
				{-0.8125, 0.8125, -0.0625, -0.625, 0.9375, 0.0625},
				{-0.6875, 0.75, -0.0625, -0.5625, 0.875, 0.0625},
				{-0.625, 0.6875, -0.0625, -0.5, 0.8125, 0.0625},
				{-0.5625, 0.625, -0.0625, -0.375, 0.75, 0.0625},
				{-0.4375, 0.5625, -0.0625, -0.3125, 0.6875, 0.0625},
				{-0.375, 0.5, -0.0625, -0.25, 0.625, 0.0625},
				{-0.3125, 0.4375, -0.0625, -0.125, 0.5625, 0.0625},
				{-0.1875, 0.375, -0.0625, -0.0625, 0.5, 0.0625},
				{-0.125, 0.3125, -0.0625, 0, 0.4375, 0.0625},
				{-0.0625, 0.25, -0.0625, 0.125, 0.375, 0.0625},
				{0.0625, 0.1875, -0.0625, 0.1875, 0.3125, 0.0625},
				{0.125, 0.125, -0.0625, 0.25, 0.25, 0.0625},
				{0.1875, 0.0625, -0.0625, 0.375, 0.1875, 0.0625},
				{0.3125, 0, -0.0625, 0.4375, 0.125, 0.0625},
				{0.4375, 0, -0.0625, 0.5, 1.5, 0.0625},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-1.5, 0, -0.0625, 0.5, 1.5, 0.0625},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:trestle_substructure_large", {
		description = "Large Trestle Substructure",
		drawtype = "nodebox",
		tiles = {"default_junglewood.png"},
		inventory_image = "default_junglewood.png^bridges_trestle_large.png^[makealpha:255,126,126",
		wield_image = "default_junglewood.png^bridges_trestle_large.png^[makealpha:255,126,126",
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{0.4375, -0.5, -0.0625, 0.5, 1.5, 0.0625},
				{0.25, -0.5, -0.0625, 0.4375, -0.375, 0.0625},
				{0.125, -0.4375, -0.0625, 0.3125, -0.3125, 0.0625},
				{0, -0.375, -0.0625, 0.1875, -0.25, 0.0625},
				{-0.125, -0.3125, -0.0625, 0.0625, -0.1875, 0.0625},
				{-0.25, -0.25, -0.0625, -0.0625, -0.125, 0.0625},
				{-0.375, -0.1875, -0.0625, -0.1875, -0.0625, 0.0625},
				{-0.5, -0.125, -0.0625, -0.3125, 0, 0.0625},
				{-0.625, -0.0625, -0.0625, -0.4375, 0.0625, 0.0625},
				{-0.75, 0, -0.0625, -0.5625, 0.125, 0.0625},
				{-0.875, 0.0625, -0.0625, -0.6875, 0.1875, 0.0625},
				{-1, 0.125, -0.0625, -0.8125, 0.25, 0.0625},
				{-1.125, 0.1875, -0.0625, -0.9375, 0.3125, 0.0625},
				{-1.25, 0.25, -0.0625, -1.0625, 0.375, 0.0625},
				{-1.375, 0.3125, -0.0625, -1.1875, 0.4375, 0.0625},
				{-1.5, 0.375, -0.0625, -1.3125, 0.5, 0.0625},
				{-1.625, 0.4375, -0.0625, -1.4375, 0.5625, 0.0625},
				{-1.75, 0.5, -0.0625, -1.5625, 0.625, 0.0625},
				{-1.875, 0.5625, -0.0625, -1.6875, 0.6875, 0.0625},
				{-2, 0.625, -0.0625, -1.8125, 0.75, 0.0625},
				{-2.125, 0.6875, -0.0625, -1.9375, 0.8125, 0.0625},
				{-2.25, 0.75, -0.0625, -2.0625, 0.875, 0.0625},
				{-2.375, 0.8125, -0.0625, -2.1875, 0.9375, 0.0625},
				{-2.5, 0.875, -0.0625, -2.3125, 1, 0.0625},
				{-2.625, 0.9375, -0.0625, -2.4375, 1.0625, 0.0625},
				{-2.75, 1, -0.0625, -2.5625, 1.125, 0.0625},
				{-2.875, 1.0625, -0.0625, -2.6875, 1.1875, 0.0625},
				{-3, 1.125, -0.0625, -2.8125, 1.25, 0.0625},
				{-3.125, 1.1875, -0.0625, -2.9375, 1.3125, 0.0625},
				{-3.25, 1.25, -0.0625, -3.0625, 1.375, 0.0625},
				{-3.375, 1.3125, -0.0625, -3.1875, 1.4375, 0.0625},
				{-3.5, 1.375, -0.0625, -3.3125, 1.5, 0.0625},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-3.5, -0.5, -0.0625, 0.5, 1.5, 0.0625},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:lattice_truss_side", {
		description = "Lattice Truss",
		drawtype = "nodebox",
		tiles = {"default_junglewood.png"},
		inventory_image = "default_junglewood.png^bridges_lattice_truss_side.png^[makealpha:255,126,126",
		wield_image = "default_junglewood.png^bridges_lattice_truss_side.png^[makealpha:255,126,126",
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.0625, -0.25, -0.25, 0.0625},
				{-0.4375, -0.4375, -0.0625, -0.1875, -0.1875, 0.0625},
				{-0.375, -0.375, -0.0625, -0.125, -0.125, 0.0625},
				{-0.3125, -0.3125, -0.0625, -0.0625, -0.0625, 0.0625},
				{0.0625, 0.0625, -0.0625, 0.3125, 0.3125, 0.0625},
				{0.125, 0.125, -0.0625, 0.375, 0.375, 0.0625},
				{0.1875, 0.1875, -0.0625, 0.4375, 0.4375, 0.0625},
				{0.25, 0.25, -0.0625, 0.5, 0.5, 0.0625},
				{0.25, -0.5, -0.0625, 0.5, -0.25, 0.0625},
				{0.1875, -0.4375, -0.0625, 0.4375, -0.1875, 0.0625},
				{-0.25, -0.25, -0.0625, 0.25, 0.25, 0.0625},
				{0.125, -0.375, -0.0625, 0.375, -0.125, 0.0625},
				{0.0625, -0.3125, -0.0625, 0.3125, -0.0625, 0.0625},
				{-0.5, 0.25, -0.0625, -0.25, 0.5, 0.0625},
				{-0.4375, 0.1875, -0.0625, -0.1875, 0.4375, 0.0625},
				{-0.375, 0.125, -0.0625, -0.125, 0.375, 0.0625},
				{-0.3125, 0.0625, -0.0625, -0.0625, 0.3125, 0.0625},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.125, 0.5, 0.5, 0.125},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:lattice_truss_top", {
		description = "Lattice Truss Upper Chord",
		drawtype = "nodebox",
		tiles = {"default_junglewood.png"},
		inventory_image = "default_junglewood.png^bridges_lattice_truss_top.png^[makealpha:255,126,126",
		wield_image = "default_junglewood.png^bridges_lattice_truss_top.png^[makealpha:255,126,126",
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-1, 0.375, 0.25, -0.75, 0.501, 0.5},
				{-0.25, 0.375, 0.25, 0.25, 0.501, 0.5},
				{-0.25, 0.375, -0.5, 0.25, 0.501, -0.25},
				{-1, 0.375, -0.5, -0.75, 0.501, -0.25},
				{-0.9375, 0.375, -0.4375, -0.6875, 0.501, -0.1875},
				{-0.875, 0.375, -0.375, -0.625, 0.501, -0.125},
				{-0.8125, 0.375, -0.3125, -0.5625, 0.501, -0.0625},
				{-0.3125, 0.375, -0.4375, -0.0625, 0.501, -0.1875},
				{-0.375, 0.375, -0.375, -0.125, 0.501, -0.125},
				{-0.4375, 0.375, -0.3125, -0.1875, 0.501, -0.0625},
				{-0.75, 0.375, -0.25, -0.25, 0.501, 0.25},
				{-0.9375, 0.375, 0.1875, -0.6875, 0.501, 0.4375},
				{-0.875, 0.375, 0.125, -0.625, 0.501, 0.375},
				{-0.8125, 0.375, 0.0625, -0.5625, 0.501, 0.3125},
				{-0.4375, 0.375, 0.0625, -0.1875, 0.501, 0.3125},
				{-0.375, 0.375, 0.125, -0.125, 0.501, 0.375},
				{-0.3125, 0.375, 0.1875, -0.0625, 0.501, 0.4375},
				{0.75, 0.375, -0.5, 1, 0.501, -0.25},
				{0.75, 0.375, 0.25, 1, 0.501, 0.5},
				{0.6875, 0.375, 0.1875, 0.9375, 0.501, 0.4375},
				{0.625, 0.375, 0.125, 0.875, 0.501, 0.375},
				{0.5625, 0.375, 0.0625, 0.8125, 0.501, 0.3125},
				{0.0625, 0.375, 0.1875, 0.3125, 0.501, 0.4375},
				{0.125, 0.375, 0.125, 0.375, 0.501, 0.375},
				{0.1875, 0.375, 0.0625, 0.4375, 0.501, 0.3125},
				{0.25, 0.375, -0.25, 0.75, 0.501, 0.25},
				{0.6875, 0.375, -0.4375, 0.9375, 0.501, -0.1875},
				{0.625, 0.375, -0.375, 0.875, 0.501, -0.125},
				{0.5625, 0.375, -0.3125, 0.8125, 0.501, -0.0625},
				{0.1875, 0.375, -0.3125, 0.4375, 0.501, -0.0625},
				{0.125, 0.375, -0.375, 0.375, 0.501, -0.125},
				{0.0625, 0.375, -0.4375, 0.3125, 0.501, -0.1875},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-1, 0.375, -0.5, 1, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})
end

if minetest.settings:get_bool("bridger_enable_wooden_bridges", true) then
	minetest.register_node("bridger:small_beam", {
		description = "Small Wooden Beam Bridge",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -0.5, 0.4375, -0.4375, 0.5},
				{-0.5, -0.5, 0.40625, -0.40625, 0.5, 0.5},
				{-0.5, -0.5, -0.5, -0.40625, 0.5, -0.40625},
				{-0.5, 0.375, -0.5, -0.40625, 0.4375, 0.5},
				{0.40625, 0.375, -0.5, 0.5, 0.4375, 0.5},
				{0.40625, -0.5, -0.5, 0.5, 0.5, -0.40625},
				{0.40625, -0.5, 0.40625, 0.5, 0.5, 0.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:small_beam_mid", {
		description = "Small Wooden Beam Bridge Middle",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -0.5, 0.4375, -0.4375, 0.5},
				{-0.5, 0.375, -0.5, -0.40625, 0.4375, 0.5},
				{0.40625, 0.375, -0.5, 0.5, 0.4375, 0.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:small_beam_end", {
		description = "Small Wooden Beam Bridge End",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -0.5, 0.4375, -0.4375, 0.4375},
				{-0.5, -0.5, 0.40625, -0.40625, 0.5, 0.5},
				{-0.5, -0.5, -0.5, -0.40625, 0.5, -0.40625},
				{-0.5, 0.375, -0.5, -0.40625, 0.4375, 0.5},
				{0.40625, 0.375, -0.5, 0.5, 0.4375, 0.5},
				{0.40625, -0.5, -0.5, 0.5, 0.5, -0.40625},
				{0.40625, -0.5, 0.40625, 0.5, 0.5, 0.5},
				{-0.5, 0.375, 0.40625, 0.5, 0.4375, 0.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:small_beam_corner", {
		description = "Small Wooden Beam Bridge Corner",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -0.5, 0.5, -0.4375, 0.4375},
				{-0.5, -0.5, 0.40625, -0.40625, 0.5, 0.5},
				{-0.5, -0.5, -0.5, -0.40625, 0.5, -0.40625},
				{-0.5, 0.375, -0.5, -0.40625, 0.4375, 0.5},
				{0.40625, -0.5, -0.5, 0.5, 0.5, -0.40625},
				{0.40625, -0.5, 0.40625, 0.5, 0.5, 0.5},
				{-0.5, 0.375, 0.40625, 0.5, 0.4375, 0.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:small_beam_3", {
		description = "Small Wooden Beam Bridge Crossing",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, -0.4375, 0.4375},
				{-0.5, -0.5, 0.40625, -0.40625, 0.5, 0.5},
				{-0.5, -0.5, -0.5, -0.40625, 0.5, -0.40625},
				{0.40625, -0.5, -0.5, 0.5, 0.5, -0.40625},
				{0.40625, -0.5, 0.40625, 0.5, 0.5, 0.5},
				{-0.5, 0.375, 0.40625, 0.5, 0.4375, 0.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:small_beam_4", {
		description = "Small Wooden Beam Bridge Crossing",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, -0.4375, 0.5},
				{-0.5, -0.5, 0.40625, -0.40625, 0.5, 0.5},
				{-0.5, -0.5, -0.5, -0.40625, 0.5, -0.40625},
				{0.40625, -0.5, -0.5, 0.5, 0.5, -0.40625},
				{0.40625, -0.5, 0.40625, 0.5, 0.5, 0.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:small_beam_stair", {
		description = "Small Wooden Beam Bridge Stair",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.0625, -0.5, 0.4375, 0, 0},
				{-0.4375, 0.4375, 0, 0.4375, 0.5, 0.5},
				{0.40625, 0.4375, 0.40625, 0.5, 1.5, 0.5},
				{0.40625, -0.5, -0.5, 0.5, 0.625, -0.40625},
				{-0.5, -0.5, -0.5, -0.40625, 0.625, -0.40625},
				{-0.5, 0.4375, 0.40625, -0.40625, 1.5, 0.5},
				{-0.5, 1.3125, 0.375, -0.40625, 1.375, 0.5},
				{-0.5, 1.25, 0.3125, -0.40625, 1.3125, 0.4375},
				{-0.5, 1.1875, 0.25, -0.40625, 1.25, 0.375},
				{-0.5, 1.125, 0.1875, -0.40625, 1.1875, 0.3125},
				{-0.5, 1.0625, 0.125, -0.40625, 1.125, 0.25},
				{-0.5, 1, 0.0625, -0.40625, 1.0625, 0.1875},
				{-0.5, 0.9375, 0, -0.40625, 1, 0.125},
				{-0.5, 0.875, -0.0625, -0.40625, 0.9375, 0.0625},
				{-0.5, 0.8125, -0.125, -0.40625, 0.875, 0},
				{-0.5, 0.75, -0.1875, -0.40625, 0.8125, -0.0625},
				{-0.5, 0.6875, -0.25, -0.40625, 0.75, -0.125},
				{-0.5, 0.625, -0.3125, -0.40625, 0.6875, -0.1875},
				{-0.5, 0.5625, -0.375, -0.40625, 0.625, -0.25},
				{-0.5, 0.5, -0.4375, -0.40625, 0.5625, -0.3125},
				{-0.5, 0.4375, -0.5, -0.40625, 0.5, -0.375},
				{0.40625, 0.4375, -0.5, 0.5, 0.5, -0.375},
				{0.40625, 0.5, -0.4375, 0.5, 0.5625, -0.3125},
				{0.40625, 0.5625, -0.375, 0.5, 0.625, -0.25},
				{0.40625, 0.625, -0.3125, 0.5, 0.6875, -0.1875},
				{0.40625, 0.6875, -0.25, 0.5, 0.75, -0.125},
				{0.40625, 0.75, -0.1875, 0.5, 0.8125, -0.0625},
				{0.40625, 0.8125, -0.125, 0.5, 0.875, 0},
				{0.40625, 0.875, -0.0625, 0.5, 0.9375, 0.0625},
				{0.40625, 0.9375, 0, 0.5, 1, 0.125},
				{0.40625, 1, 0.0625, 0.5, 1.0625, 0.1875},
				{0.40625, 1.0625, 0.125, 0.5, 1.125, 0.25},
				{0.40625, 1.125, 0.1875, 0.5, 1.1875, 0.3125},
				{0.40625, 1.1875, 0.25, 0.5, 1.25, 0.375},
				{0.40625, 1.25, 0.3125, 0.5, 1.3125, 0.4375},
				{0.40625, 1.3125, 0.375, 0.5, 1.375, 0.5},
				{0.40625, -0.5, -0.5, 0.5, -0.4375, -0.375},
				{0.40625, -0.4375, -0.4375, 0.5, -0.375, -0.3125},
				{0.40625, -0.375, -0.375, 0.5, -0.3125, -0.25},
				{0.40625, -0.3125, -0.3125, 0.5, -0.25, -0.1875},
				{0.40625, -0.25, -0.25, 0.5, -0.1875, -0.125},
				{0.40625, -0.1875, -0.1875, 0.5, -0.125, -0.0625},
				{0.40625, -0.125, -0.125, 0.5, -0.0625, 0},
				{0.40625, -0.0625, -0.0625, 0.5, 0, 0.0625},
				{0.40625, 0, 0, 0.5, 0.0625, 0.125},
				{0.40625, 0.0625, 0.0625, 0.5, 0.125, 0.1875},
				{0.40625, 0.125, 0.125, 0.5, 0.1875, 0.25},
				{0.40625, 0.1875, 0.1875, 0.5, 0.25, 0.3125},
				{0.40625, 0.25, 0.25, 0.5, 0.3125, 0.375},
				{0.40625, 0.3125, 0.3125, 0.5, 0.375, 0.4375},
				{0.40625, 0.375, 0.375, 0.5, 0.4375, 0.5},
				{-0.5, -0.5, -0.5, -0.40625, -0.4375, -0.375},
				{-0.5, -0.4375, -0.4375, -0.40625, -0.375, -0.3125},
				{-0.5, -0.375, -0.375, -0.40625, -0.3125, -0.25},
				{-0.5, -0.3125, -0.3125, -0.40625, -0.25, -0.1875},
				{-0.5, -0.25, -0.25, -0.40625, -0.1875, -0.125},
				{-0.5, -0.1875, -0.1875, -0.40625, -0.125, -0.0625},
				{-0.5, -0.125, -0.125, -0.40625, -0.0625, 0},
				{-0.5, -0.0625, -0.0625, -0.40625, 0, 0.0625},
				{-0.5, 0, 0, -0.40625, 0.0625, 0.125},
				{-0.5, 0.0625, 0.0625, -0.40625, 0.125, 0.1875},
				{-0.5, 0.125, 0.125, -0.40625, 0.1875, 0.25},
				{-0.5, 0.1875, 0.1875, -0.40625, 0.25, 0.3125},
				{-0.5, 0.25, 0.25, -0.40625, 0.3125, 0.375},
				{-0.5, 0.3125, 0.3125, -0.40625, 0.375, 0.4375},
				{-0.5, 0.375, 0.375, -0.40625, 0.4375, 0.5},
				{-0.5, -0.5625, -0.5, -0.40625, -0.5, -0.4375},
				{0.40625, -0.5625, -0.5, 0.5, -0.5, -0.4375},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:large_beam", {
		description = "Large Wooden Beam Bridge",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -1.5, 0.4375, -0.4375, 1.5},
				{0.40625, -0.5, -0.6875, 0.5, 0.5, -0.59375},
				{0.40625, -0.5, 0.59375, 0.5, 0.5, 0.6875},
				{-0.5, -0.5, 0.59375, -0.40625, 0.5, 0.6875},
				{-0.5, -0.5, -0.6875, -0.40625, 0.5, -0.59375},
				{-0.5, 0.375, -1.5, -0.40625, 0.4375, 1.5},
				{0.40625, 0.375, -1.5, 0.5, 0.4375, 1.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -1.5, 0.5, 0.5, 1.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	minetest.register_node("bridger:large_fancy_beam", {
		description = "Large Fancy Wooden Beam Bridge",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -1.5, 0.4375, -0.4375, -1.375},
				{0.40625, -0.125, -0.6875, 0.5, 0.875, -0.59375},
				{0.40625, -0.125, 0.59375, 0.5, 0.875, 0.6875},
				{-0.5, -0.125, 0.59375, -0.40625, 0.875, 0.6875},
				{-0.5, -0.125, -0.6875, -0.40625, 0.875, -0.59375},
				{-0.5, 0.375, -1.5, -0.40625, 0.4375, -1.375},
				{0.40625, 0.375, -1.5, 0.5, 0.4375, -1.375},
				{-0.4375, -0.4375, -1.4375, 0.4375, -0.375, -1.3125},
				{-0.4375, -0.375, -1.375, 0.4375, -0.3125, -1.25},
				{-0.4375, -0.3125, -1.3125, 0.4375, -0.25, -1.125},
				{-0.4375, -0.25, -1.1875, 0.4375, -0.1875, -1},
				{-0.4375, -0.1875, -1.0625, 0.4375, -0.125, -0.75},
				{-0.4375, -0.125, -0.8125, 0.4375, -0.0625, -0.4375},
				{-0.4375, -0.125, 0.4375, 0.4375, -0.0625, 0.8125},
				{-0.4375, -0.0625, -0.5, 0.4375, 0, 0.5},
				{-0.4375, -0.1875, 0.75, 0.4375, -0.125, 1.0625},
				{-0.4375, -0.25, 1, 0.4375, -0.1875, 1.1875},
				{-0.4375, -0.3125, 1.125, 0.4375, -0.25, 1.3125},
				{-0.4375, -0.375, 1.25, 0.4375, -0.3125, 1.375},
				{-0.4375, -0.4375, 1.3125, 0.4375, -0.375, 1.4375},
				{-0.4375, -0.5, 1.375, 0.4375, -0.4375, 1.5},
				{-0.5, 0.4375, -1.4375, -0.40625, 0.5, -1.3125},
				{-0.5, 0.5, -1.375, -0.40625, 0.5625, -1.25},
				{-0.5, 0.5625, -1.3125, -0.40625, 0.625, -1.125},
				{-0.5, 0.625, -1.1875, -0.40625, 0.6875, -1},
				{-0.5, 0.6875, -1.0625, -0.40625, 0.75, -0.75},
				{-0.5, 0.75, -0.8125, -0.40625, 0.8125, -0.4375},
				{-0.5, 0.8125, -0.5, -0.40625, 0.875, 0.5},
				{-0.5, 0.75, 0.4375, -0.40625, 0.8125, 0.8125},
				{-0.5, 0.6875, 0.75, -0.40625, 0.75, 1.0625},
				{-0.5, 0.625, 1, -0.40625, 0.6875, 1.1875},
				{-0.5, 0.5625, 1.125, -0.40625, 0.625, 1.3125},
				{-0.5, 0.5, 1.25, -0.40625, 0.5625, 1.375},
				{-0.5, 0.4375, 1.3125, -0.40625, 0.5, 1.4375},
				{-0.5, 0.375, 1.375, -0.40625, 0.4375, 1.5},
				{0.40625, 0.4375, -1.4375, 0.5, 0.5, -1.3125},
				{0.40625, 0.5, -1.375, 0.5, 0.5625, -1.25},
				{0.40625, 0.5625, -1.3125, 0.5, 0.625, -1.125},
				{0.40625, 0.625, -1.1875, 0.5, 0.6875, -1},
				{0.40625, 0.6875, -1.0625, 0.5, 0.75, -0.75},
				{0.40625, 0.75, -0.8125, 0.5, 0.8125, -0.4375},
				{0.40625, 0.8125, -0.5, 0.5, 0.875, 0.5},
				{0.40625, 0.75, 0.4375, 0.5, 0.8125, 0.8125},
				{0.40625, 0.6875, 0.75, 0.5, 0.75, 1.0625},
				{0.40625, 0.625, 1, 0.5, 0.6875, 1.1875},
				{0.40625, 0.5625, 1.125, 0.5, 0.625, 1.3125},
				{0.40625, 0.5, 1.25, 0.5, 0.5625, 1.375},
				{0.40625, 0.4375, 1.3125, 0.5, 0.5, 1.4375},
				{0.40625, 0.375, 1.375, 0.5, 0.4375, 1.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -1.5, 0.5, 0.5, 1.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})

	local mesecon_on_blastnode = nil
	if minetest.get_modpath("mesecons") then
		mesecon_on_blastnode = mesecon.on_blastnode
	end

	minetest.register_node("bridger:large_beam_swivel_normal", {
		description = "Large Wooden Swivel Bridge",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -1.5, 0.4375, -0.4375, 1.5},
				{0.40625, -0.5, -0.6875, 0.5, 0.5, -0.59375},
				{0.40625, -0.5, 0.59375, 0.5, 0.5, 0.6875},
				{-0.5, -0.5, 0.59375, -0.40625, 0.5, 0.6875},
				{-0.5, -0.5, -0.6875, -0.40625, 0.5, -0.59375},
				{-0.5, 0.375, -1.5, -0.40625, 0.4375, 1.5},
				{0.40625, 0.375, -1.5, 0.5, 0.4375, 1.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -1.5, 0.5, 0.5, 1.5},
			},
		},
		on_rightclick = function(pos, node)
			minetest.set_node(pos, {name = "bridger:large_beam_swivel_open", param2 = node.param2})
		end,
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
		mesecons = {effector = {
			action_on = function(pos, node)
				minetest.swap_node(pos, {name = "bridger:large_beam_swivel_open", param2 = node.param2})
			end,
		}},
		on_blast = mesecon_on_blastnode,
	})

	minetest.register_node("bridger:large_beam_swivel_open", {
		description = "Large Wooden Swivel Bridge",
		drawtype = "nodebox",
		tiles = {"default_wood.png^[transformR90"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-1.5, -0.5, -0.4375, 1.5, -0.4375, 0.4375},
				{-0.6875, -0.5, -0.5, -0.59375, 0.5, -0.40625},
				{0.59375, -0.5, -0.5, 0.6875, 0.5, -0.40625},
				{0.59375, -0.5, 0.40625, 0.6875, 0.5, 0.5},
				{-0.6875, -0.5, 0.40625, -0.59375, 0.5, 0.5},
				{-1.5, 0.375, 0.40625, 1.5, 0.4375, 0.5},
				{-1.5, 0.375, -0.5, 1.5, 0.4375, -0.40625},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-1.5, -0.5, -0.5, 1.5, 0.5, 0.5},
			},
		},
		on_rightclick = function(pos, node)
			minetest.set_node(pos, {name = "bridger:large_beam_swivel_normal", param2 = node.param2})
		end,
		drop = "bridger:large_beam_swivel_normal",
		groups = {choppy=3, not_in_creative_inventory=1},
		sounds = default.node_sound_wood_defaults(),
		mesecons = {effector = {
			action_off = function(pos, node)
				minetest.swap_node(pos, {name = "bridger:large_beam_swivel_normal", param2 = node.param2})
			end,
		}},
		on_blast = mesecon_on_blastnode,
	})

	minetest.register_node("bridger:large_drawbridge_normal", {
		description = "Large Wooden Drawbridge",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -0.5, 0.4375, -0.4375, 1.5},
				{0.40625, -0.5, -0.5, 0.5, 0.5, -0.40625},
				{0.40625, -0.5, 0.59375, 0.5, 0.5, 0.6875},
				{-0.5, -0.5, 0.59375, -0.40625, 0.5, 0.6875},
				{-0.5, -0.5, -0.5, -0.40625, 0.5, -0.40625},
				{-0.5, 0.375, -0.5, -0.40625, 0.4375, 1.5},
				{0.40625, 0.375, -0.5, 0.5, 0.4375, 1.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 1.5},
			},
		},
		on_rightclick = function(pos, node)
			minetest.set_node(pos, {name = "bridger:large_drawbridge_open", param2 = node.param2})
		end,
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
		mesecons = {effector = {
			action_on = function(pos, node)
				minetest.swap_node(pos, {name = "bridger:large_drawbridge_open", param2 = node.param2})
			end,
		}},
	})

	minetest.register_node("bridger:large_drawbridge_open", {
		description = "Large Wooden Drawbridge",
		drawtype = "nodebox",
		tiles = {"default_wood.png"},
		paramtype = "light",
		paramtype2 = "facedir",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -0.5, 0.4375, -0.3125, -0.4375},
				{0.40625, -0.5, -0.5, 0.5, 0.5, -0.40625},
				{0.40625, 0.875, 0.15625, 0.5, 2.125, 0.25},
				{-0.5, 0.875, 0.15625, -0.40625, 2.125, 0.25},
				{-0.5, -0.5, -0.5, -0.40625, 0.5, -0.40625},
				{-0.5, 0.375, -0.5, -0.40625, 0.5625, -0.4375},
				{0.40625, 0.375, -0.5, 0.5, 0.5625, -0.4375},
				{-0.4375, -0.375, -0.4375, 0.4375, -0.1875, -0.375},
				{-0.4375, -0.25, -0.375, 0.4375, -0.0625, -0.3125},
				{-0.4375, -0.125, -0.3125, 0.4375, 0.0625, -0.25},
				{-0.4375, 0, -0.25, 0.4375, 0.1875, -0.1875},
				{-0.4375, 0.125, -0.1875, 0.4375, 0.3125, -0.125},
				{-0.4375, 0.25, -0.125, 0.4375, 0.4375, -0.0625},
				{-0.4375, 0.375, -0.0625, 0.4375, 0.5625, 0},
				{-0.4375, 0.5, 0, 0.4375, 0.6875, 0.0625},
				{-0.4375, 0.625, 0.0625, 0.4375, 0.8125, 0.125},
				{-0.4375, 0.75, 0.125, 0.4375, 0.9375, 0.1875},
				{-0.4375, 0.875, 0.1875, 0.4375, 1.0625, 0.25},
				{-0.4375, 1, 0.25, 0.4375, 1.1875, 0.3125},
				{-0.4375, 1.125, 0.3125, 0.4375, 1.3125, 0.375},
				{-0.5, 0.5, -0.4375, -0.40625, 0.6875, -0.375},
				{-0.5, 0.625, -0.375, -0.40625, 0.8125, -0.3125},
				{-0.5, 0.75, -0.3125, -0.40625, 0.9375, -0.25},
				{-0.5, 0.875, -0.25, -0.40625, 1.0625, -0.1875},
				{-0.5, 1, -0.1875, -0.40625, 1.1875, -0.125},
				{-0.5, 1.125, -0.125, -0.40625, 1.3125, -0.0625},
				{-0.5, 1.25, -0.0625, -0.40625, 1.4375, 0},
				{-0.5, 1.375, 0, -0.40625, 1.5625, 0.0625},
				{-0.5, 1.5, 0.0625, -0.40625, 1.6875, 0.125},
				{-0.5, 1.625, 0.125, -0.40625, 1.8125, 0.1875},
				{-0.5, 1.75, 0.1875, -0.40625, 1.9375, 0.25},
				{-0.5, 1.875, 0.25, -0.40625, 2.0625, 0.3125},
				{-0.5, 2, 0.3125, -0.40625, 2.1875, 0.375},
				{0.40625, 0.5, -0.4375, 0.5, 0.6875, -0.375},
				{0.40625, 0.625, -0.375, 0.5, 0.8125, -0.3125},
				{0.40625, 0.75, -0.3125, 0.5, 0.9375, -0.25},
				{0.40625, 0.875, -0.25, 0.5, 1.0625, -0.1875},
				{0.40625, 1, -0.1875, 0.5, 1.1875, -0.125},
				{0.40625, 1.125, -0.125, 0.5, 1.3125, -0.0625},
				{0.40625, 1.25, -0.0625, 0.5, 1.4375, 0},
				{0.40625, 1.375, 0, 0.5, 1.5625, 0.0625},
				{0.40625, 1.5, 0.0625, 0.5, 1.6875, 0.125},
				{0.40625, 1.625, 0.125, 0.5, 1.8125, 0.1875},
				{0.40625, 1.75, 0.1875, 0.5, 1.9375, 0.25},
				{0.40625, 1.875, 0.25, 0.5, 2.0625, 0.3125},
				{0.40625, 2, 0.3125, 0.5, 2.1875, 0.375},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, 2.1875, 0.5},
			},
		},
		on_rightclick = function(pos, node)
			minetest.set_node(pos, {name = "bridger:large_drawbridge_normal", param2 = node.param2})
		end,
		drop = "bridger:large_drawbridge_normal",
		groups = {choppy=3, not_in_creative_inventory=1},
		sounds = default.node_sound_wood_defaults(),
		mesecons = {effector = {
			action_off = function(pos, node)
				minetest.swap_node(pos, {name = "bridger:large_drawbridge_normal", param2 = node.param2})
			end,
		}},
		on_blast = mesecon_on_blastnode,
	})

	minetest.register_node("bridger:deck_wood", {
		description = "Wooden Deck",
		drawtype = "nodebox",
		tiles = {"default_junglewood.png"},
		paramtype = "light",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.5, 0.375, -0.5, 0.5, 0.501, 0.5},
			},
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, 0, -0.5, 0.5, 0.5, 0.5},
			},
		},
		groups = {choppy=3},
		sounds = default.node_sound_wood_defaults(),
	})
end
