local MT = minetest
local vMod = vm_lighting_wand
local modname = vMod.modname

vMod.tool = modname .. ":lighting_wand"
-- the light "placer/remover" wand
MT.register_tool(
  vMod.tool,
  {
    description = vMod.locale("Lighting Wand"),
    inventory_image = vMod.modname .. "_lighting_wand.png",
    wield_scale = {x = 2, y = 2, z = 2},
    range = 0,
    tool_capabilities = {
      full_punch_interval = 1,
      max_drop_level = 0,
      groupcaps = {},
      damage_groups = {}
    },
    on_use = function(itemstack, player, pointed_thing)
      vMod.cast_wand(player)
      return itemstack
    end,
    on_secondary_use = function(itemstack, player, pointed_thing)
      vMod.open_gui(player)
      return itemstack
    end
  }
)
