local MT = minetest
local vMod = vm_lighting_wand

vMod.detached_list = "burntime_slot"
vMod.detached_name = function(player_name)
  return vMod.modname .. "_" .. player_name .. "_detached_inv"
end
--replacements
local get_burntime = function(stack, player)
  local fuel_efficiency = vMod.get_level(player).fuel_efficiency
  local fuel, afterfuel = MT.get_craft_result({ method = "fuel", width = 1, items = { stack } })
  fuel = fuel.time or 0
  return (fuel * fuel_efficiency), afterfuel
end

local stack_to_burntime = function(stack, player)
  local fuel, afterfuel = get_burntime(stack, player)
  return fuel * stack:get_count(), afterfuel
end

local make_detached_inv = function(player)
  if not player then
    return
  end
  local player_name = player:get_player_name()
  return MT.create_detached_inventory(
    vMod.detached_name(player_name),
    {
      on_put = function(inv, listname, index, stack, player2)
        -- as allow_put does, test for non nil
        if not vMod.get_gui_player(player2) or listname ~= vMod.detached_list then
          vMod.close_gui(player2)
          return
        end
        -- allow_put does the check as to what can be put into the slot, so here we just pass all to add_power()
        local stack_burntime, afterfuel = stack_to_burntime(stack, player2)
        vMod.add_power(player2, stack_burntime)
        -- Clear the input slot
        inv:set_stack(listname, index, nil)

        -- check for any returns
        if afterfuel and type(afterfuel.items) == "table" then
          for _, itemstack in ipairs(afterfuel.items) do
            if not itemstack:is_empty() then
              -- if this stack matches the given stack then fix the count
              if itemstack:get_name() == stack:get_name() then
                itemstack:set_count(itemstack:get_count() - (stack:get_count() + 1))
              end
              -- if this stack still has items then give it to the player
              if itemstack:get_count() > 0 then
                local player_inv = player2:get_inventory()
                if player_inv:room_for_item("main", itemstack) then
                  player_inv:add_item("main", itemstack)
                else
                  MT.add_item(player:get_pos(), itemstack)
                end
              end
            end
          end
        end
        -- Update the players GUI
        vMod.open_gui(player2, vMod.get_gui_player(player2))
      end,
      allow_put = function(inv, listname, index, stack, player2)
        -- we cant compare the gui_id here but it should atleast be set and not nil
        if not vMod.get_gui_player(player2) or listname ~= vMod.detached_list then
          vMod.close_gui(player2)
          return 0
        end

        local burntime = get_burntime(stack, player2)
        local stack_burntime = stack_to_burntime(stack, player2)
        local can_input_power = vMod.can_input_power(player2, stack_burntime)

        -- return
        if burntime <= 0 or can_input_power <= 0 then
          return 0
        end

        -- Player has room for full stack supplied
        if can_input_power == stack_burntime then
          return stack:get_count()
        else
          -- only allow enough items to fill the players power
          local sum = vMod.round(can_input_power / burntime)
          if sum > 0 then
            return sum
          end
        end

        -- by default dont allow input
        return 0
      end,
      allow_take = function(inv, listname, index, stack, player2)
        return 0
      end,
      allow_move = function(inv, from_list, from_index, to_list, to_index, count, player2)
        return 0
      end
    },
    player_name
  )
end

MT.register_on_joinplayer(
  function(player)
    local detached_inv = make_detached_inv(player)
    if not detached_inv then
      return
    end
    detached_inv:set_size(vMod.detached_list, 1)
  end
)

MT.register_on_leaveplayer(
  function(player)
    MT.remove_detached_inventory(vMod.detached_name(player:get_player_name()))
  end
)
