local levels = {}

local vMod = vm_lighting_wand
local efficiency_multiplier = minetest.settings:get("vm_lighting_wand_multiplier") or 1
local level_counter = 0

-- Add a new level (see config.lua)
vMod.add_level = function(name, def)
  if not name or vMod.loaded then
    return
  end
  def = def or {}
  local level_before_id = level_counter

  --bump the levels id
  level_counter = level_counter + 1

  local amount_start = def.amount_start or 0
  -- first id should always have a amount_start of 0
  if level_counter == 1 then
    -- ensure levels is clean
    levels = {}
    amount_start = 0
    if vMod.get_max_power() < 1000 then
      vMod.set_max_power(1000) -- set a default max_power
    end
  else
    -- this levels ammout_start should always be greater then the last
    local level_before = levels[level_before_id]
    if amount_start <= 0 or level_before.amount_start >= amount_start then
      -- reject this level
      level_counter = level_before
      vMod.logger("Failed to add level named: " .. name .. " invalid amount_start given")
      return false
    end
    -- ensure this level can be reached and add a buffer of (amount_start * 1.25)
    if vMod.get_max_power() < amount_start * 1.25 then
      vMod.set_max_power(amount_start * 1.25)
    end
  end
  def = {
    cost_per_use = def.cost_per_node and def.cost_per_node > 0 and def.cost_per_node or 15,
    cost_per_node = def.cost_per_use and def.cost_per_use > 0 and def.cost_per_use or 1,
    removal_reduction = def.removal_reduction and def.removal_reduction > 0 and def.removal_reduction or 2,
    max_range = def.max_range and def.max_range > 0 and def.max_range or 8,
    fuel_efficiency = def.fuel_efficiency and def.fuel_efficiency > 0 and def.fuel_efficiency or 0.5
  }
  -- Define this level
  levels[level_counter] = {
    id = level_counter,
    name = name,
    amount_start = amount_start,
    cost_per_use = def.cost_per_use,
    cost_per_node = def.cost_per_node,
    removal_reduction = def.removal_reduction,
    max_range = def.max_range,
    fuel_efficiency = vMod.round((def.fuel_efficiency) * efficiency_multiplier, 2)
  }

  -- return level id as mark of success
  return level_counter
end

-- Gets a players level
vMod.get_level = function(player)
  if not player then
    return nil
  end

  -- return last_level if player is in creative mode
  if vMod.is_creative_mode(player) then
    return vMod.get_last_level()
  end

  -- by default the player is in the first level
  local level_before = vMod.get_first_level()
  local power = vMod.get_power(player)

  -- Loop all levels and test the amount_start
  for _, level in ipairs(levels) do
    -- if the player doesnt reach this level break
    if power < level.amount_start then
      break
    end
    -- this level is now the last
    level_before = level
  end

  return level_before
end

-- get all levels
vMod.get_all_levels = function()
  return levels
end

vMod.get_last_level = function()
  return levels[level_counter]
end

vMod.get_first_level = function()
  return levels[1]
end

vMod.clear_all_levels = function()
  if vMod.loaded then
    return
  end
  levels = {}
  level_counter = 0
end

-- get a level by its id
vMod.get_level_by_id = function(id)
  if not id or id < 0 or id > level_counter then
    return nil
  end
  return levels[id] or nil
end
