-- do not change this file directly
-- copy and paste it to
--
-- 	/config.lua
--
-- in the root folder and then alter it.

-- Local access to wands functions
local vMod = vm_lighting_wand

-- To set a custom recipe change the values below to valid items
--! NOTE it does not care if these are valid or not, it only feeds the values to register_craft()
vMod.set_crafting_items("LIGHT_ITEM", "HANDLE_ITEM")

-- Adding to ignored examples
-- vMod.add_ignored_name("NODENAME")
-- vMod.add_ignored_drawtype("DRAWTYPE")
-- vMod.add_ignored_group("GROUP")
-- vMod.add_ignored_onlighting("NODENAME")

-- Define each level (based on the players currently stored burntime amount)
-- 1 coal = 40 burntime
-- It takes around 5.8k coal (burntime) to reach the last level

-- set the max power to 600k burntime
vMod.set_max_power(600000)

--*Level ID: 1
-- 0 -> 9000 = 9000 / 30 = 300 coal to level up
-- coal burntime is worth 30
vMod.add_level(
  "Apprentice", -- Name
  {
    amount_start = 0, -- power amount needed to reach level (will rise max_power to value*1.25)
    cost_per_use = 14, -- raw cost per use - (4 torches from one coal 40/4 = 10)
    cost_per_node = 1.5, -- cost per node travelled
    removal_reduction = 1.25, -- reduction cost to remove (division)
    max_range = 7, -- max range
    fuel_efficiency = 0.75 -- (item_burntime * fuel_efficiency) (1 coal = 30 @ 0.75)
  }
)

--*Level ID: 2
-- 9000 -> 26000 = 17000 / 34 = 500 coal (800 total)
-- coal burntime is worth 34
vMod.add_level(
  "Warming up",
  {
    amount_start = 9000,
    cost_per_use = 12,
    cost_per_node = 1.4,
    removal_reduction = 1.5,
    max_range = 14,
    fuel_efficiency = 0.85
  }
)

--*Level ID: 3
-- 26000 -> 48500 = 22500 / 36 = 625 coal (1425 total)
-- coal is worth 36
vMod.add_level(
  "On Fire",
  {
    amount_start = 26000,
    cost_per_use = 10,
    cost_per_node = 1.2,
    removal_reduction = 2,
    max_range = 30,
    fuel_efficiency = 0.9
  }
)

--*Level ID: 4
-- 48500 -> 79500 = 31000 / 40 = 775 coal (2200 total)
-- coal is worth 40
vMod.add_level(
  "Pyro Apprentice",
  {
    amount_start = 48500,
    cost_per_use = 9,
    cost_per_node = 1,
    removal_reduction = 2.5,
    max_range = 45,
    fuel_efficiency = 1
  }
)

--*Level ID: 5
-- 79500 -> 151500 = 72000 / 60 = 1200 coal (3400 total)
-- coal is worth 60
vMod.add_level(
  "Pryo Master",
  {
    amount_start = 79500,
    cost_per_use = 8,
    cost_per_node = 0.75,
    removal_reduction = 3,
    max_range = 70,
    fuel_efficiency = 1.5
  }
)

--*Level ID: 6
-- 151500 -> 343500 = 192000 / 80 = 2400 coal (5800 total)
-- coal is worth 80
vMod.add_level(
  "Sun Master",
  {
    amount_start = 151500,
    cost_per_use = 6,
    cost_per_node = 0.5,
    removal_reduction = 4,
    max_range = 100,
    fuel_efficiency = 2
  }
)

--*Level ID: 7
-- 343500 -> 600000 = 256,500 / 240 = 2,565 coal (8365 to max)
-- Super OP BROKEN mode
-- coal is worth 320
vMod.add_level(
  "Sun Slinger",
  {
    amount_start = 343500,
    cost_per_use = 4,
    cost_per_node = 0.25,
    removal_reduction = 5,
    max_range = 150,
    fuel_efficiency = 2.5
  }
)

--[[
Example of an 8th level

-- up the max power to 1 million (default is 600k)
vMod.set_max_power(1000000)

vMod.add_level(
	"My Level Name",
	{
		amount_start = 600000, -- the old max level
		cost_per_use = 1,
		cost_per_node = 0.1,
		removal_reduction = 10,
		max_range = 250,
		fuel_efficiency = 10
	}
)
]]
