local MT = minetest
local vMod = vm_lighting_wand
local locale = vMod.locale

vMod.air_light = vMod.modname .. ":air_light"
vMod.water_light = vMod.modname .. ":water_light"

-- fake air node with a light.
MT.register_node(vMod.air_light, {
    description = locale("Air Light"),
    drawtype = "airlike",
    walkable = false,
    pointable = false,
    diggable = false,
    paramtype = "light",
    drop = {},
    groups = {
        not_in_creative_inventory = 1,
        [vMod.modname .. "_air_light"] = 1
    },
    sunlight_propagates = true,
    can_dig = false,
    buildable_to = true,
    light_source = 14,
    selection_box = {
        type = "fixed",
        fixed = {0, 0, 0, 0, 0, 0}
    }
})

-- fake water node with a light, it doesnt flow
MT.register_node(vMod.water_light, {
    description = locale("Water Light"),
    drawtype = "liquid",
    waving = 3,
    tiles = {{
        name = "default_water_source_animated.png",
        backface_culling = false,
        animation = {
            type = "vertical_frames",
            aspect_w = 16,
            aspect_h = 16,
            length = 2.0
        }
    }, {
        name = "default_water_source_animated.png",
        backface_culling = true,
        animation = {
            type = "vertical_frames",
            aspect_w = 16,
            aspect_h = 16,
            length = 2.0
        }
    }},
    groups = {
        not_in_creative_inventory = 1,
        [vMod.modname .. "_water_light"] = 1,
        liquid = 1
    },
    liquid_renewable = false,
    paramtype = "light",
    light_source = 14,
    walkable = false,
    pointable = false,
    diggable = false,
    buildable_to = true,
    is_ground_content = false,
    drop = "",
    drowning = 1,
    liquidtype = "none",
    post_effect_color = {
        a = 103,
        r = 30,
        g = 60,
        b = 90
    }
})
