local MT = minetest
local vMod = vm_lighting_wand

local crafting = {}

vMod.set_crafting_items = function(light, handle)
  if not light or not handle or light == "LIGHT_ITEM" or handle == "HANDLE_ITEM" then
    return
  end
  crafting = {
    light = light,
    handle = handle
  }
end

vMod.clear_crafting_items = function()
  crafting = {}
end

vMod.has_valid_recipe = function()
  if not crafting or not crafting.light or not crafting.handle then
    return false
  end
  return true
end

vMod.add_crafting_recipe = function()
  if vMod.loaded then
    vMod.logger("add_crafting_recipe() called but game is already loaded")
    return
  end
  if not vMod.has_valid_recipe() then
    vMod.logger("crafting recipe not registered.")
  else
    MT.register_craft({
      output = vMod.tool,
      recipe = { { crafting.light }, { crafting.handle }, { crafting.handle } }
    })
    vMod.logger("crafting recipe registered.")
  end
end
