local path = core.get_modpath("priority_queue")
print("Running tests for " .. path)

local IS_BUGGY = false
local ERROR = ""

local tests = {
    function()
        local pq = priority_queue:new()
        local list = {}

        local test_items = 100

        for i = 1, test_items do
            local r = math.random() * 1000
            pq:insert(i, r)
            list[i] = r
        end

        for i = 1, test_items do
            local smallest = list[1]
            local idx = 1
            for j = 1, #list do
                if list[j] < smallest then
                    smallest = list[j]
                    idx = j
                end
            end
            list[idx] = 42

            local _, pq_priority = pq:extract()

            --print(smallest, pq_priority)

            if smallest ~= pq_priority then
                return false, "wrong order"
            end
        end

        return true
    end
    -- Maybe more tests in the future?
}

for i = 1, #tests do
    local is_valid, msg = tests[i]()
    if is_valid == false then
        IS_BUGGY = true
        ERROR = msg
        break
    end
end

if IS_BUGGY then
    print("    There is an error: " .. ERROR .. ". Fix it!")
else
    print("    Everything is (likely) working.")
end
