Priority queues can be used for various tasks, such as for pathfinding (in Dijkstra-like algorithms) or simple decision making (which action to perform next). This implementation aims to be sufficiently fast for such tasks without compromising in useful functionality.

> TIP: For heavy tasks, uncomment the line loading `test_perf.lua` from `init.lua` and run `init.lua` from the command line, preferably with LuaJIT, to check whether the mod performs with adequate speed.

## API:

#### `priority_queue:new(type)`

Returns a priority queue of a specified `type`:
- `0`: smaller priorities are more important
- `1`: larger priorities are more important

If `type` is not specified, it defaults to `0`.

#### `instance:insert(value, priority)`

Inserts a `value` into the queue with the given `priority`.  If the `value` already exists, its priority is updated instead.

Returns:
- `true` if the `value` is new
- `false` if the `value` already exists


#### `instance:extract()`

Returns the `value` and `priority` of the most important element, in that order, removing the element from the queue. If the queue is empty, `nil` is returned instead.

#### `instance:peek()`

Acts like `extract()`, with the distinction that the element is not removed.

#### `instance:search(value)`

Tests whether the queue contains an element with the given `value`. If yes, returns `true`; otherwise returns `false`.

#### `instance:delete(value)`

Removes the element with the given `value`. Returns `true` on success, and `false` if the queue does not contain the given `value`.

#### `instance:clear()`

Removes all stored elements from the queue.

## Examples

#### Basic usage

`local min_queue = priority_queue:new(0)`

`min_queue:insert("A", 2)`  
`min_queue:insert("B", 1)`  
`min_queue:insert("C", 3)`

`local value, priority = min_queue:extract()`  
`print(value) -- prints "B"`