local function clone(table, template)
    local clone = template or {}
    for k, v in pairs(table) do
        clone[k] = v
    end
    return clone
end

function Class()
    local class = {}
    function class:new(...)
        local i = clone(self)
        i:_init(...)
        i.new, i._init = nil, nil
        return i
    end
    return class
end

function Extend(parent)
    local class = {}
    class._super = parent._init
    function class:new(...)
        local i = clone(parent)
        i = clone(self, i)
        i:_init(...)
        i.new, i._init, i._super = nil, nil, nil
        return i
    end
    return class
end

return Class, Extend
