if core ~= nil then
    print("To test performance, please run init.lua directly from the terminal.")
    return
end

local floor = math.floor
local random = math.random

local function test(repeats, size)
    local pq = priority_queue:new(0)
    local time = os.clock()
    for i = 1, repeats do
        for j = 1, size do
            pq:insert(j, random())
        end
        for j = 1, size do
            pq:extract()
        end
    end
    return os.clock() - time
end

local repeats = 1000
local size = 1000

if not jit then
    print("Please use LuaJIT for optimal results.")
    repeats = 500
    size = 1000
else
    -- JIT warmup
    test(1000, 1000)
end

local elapsed = test(repeats, size)
local op = (elapsed) / (repeats * 2 * size)
local ops = 1 / op

print("Performance evaluation:")
print("    One operation took ~" .. floor(1e9 * op) .. "ns.")
print("    ~" .. floor(ops) .. " operations can be done during one second.")
