local path = ""
if core then
    path = core.get_modpath("priority_queue")
else
    path = "."
end

local Class, Extend = dofile(path .. "/main/classes.lua")

local floor = math.floor
local SimpleMinHeap = Class()

local function _up_heap(self, idx)
    local values = self._values
    local priorities = self._priorities

    while idx > 1 do
        local parent_idx = floor(idx / 2)

        local vp = values[parent_idx]
        local vi = values[idx]
        local pp = priorities[parent_idx]
        local pi = priorities[idx]

        if pp <= pi then
            break
        end

        values[idx], values[parent_idx], priorities[idx], priorities[parent_idx] = vp, vi, pp, pi

        idx = parent_idx
    end
end

local function _down_heap(self, idx)
    local s = self
    local values = s._values
    local priorities = s._priorities

    while true do
        local left_child_idx = 2 * idx
        local right_child_idx = 2 * idx + 1
        local smallest = idx
        local pi = priorities[idx]
        local ps = pi

        if left_child_idx <= s._size and priorities[left_child_idx] < priorities[smallest] then
            smallest = left_child_idx
        end

        if smallest == left_child_idx then
            ps = priorities[smallest]
        end

        if right_child_idx <= s._size and priorities[right_child_idx] < ps then
            smallest = right_child_idx
        end

        if smallest == idx then break end

        local vs = values[smallest]
        local vi = values[idx]

        if smallest == right_child_idx then
            ps = priorities[smallest]
        end

        values[idx], values[smallest], priorities[idx], priorities[smallest] = vs, vi, ps, pi

        idx = smallest
    end
end

function SimpleMinHeap:_init()
    local s = self
    s._values = {}
    s._priorities = {}
    s._size = 0
end

function SimpleMinHeap:insert(value, priority)
    local s = self
    local values = s._values
    local priorities = s._priorities

    s._size = s._size + 1
    values[s._size] = value
    priorities[s._size] = priority
    _up_heap(s, s._size)
    return true
end

function SimpleMinHeap:extract()
    local s = self
    local values = s._values
    local priorities = s._priorities

    if s._size == 0 then
        return nil
    end

    if s._size == 1 then
        local value = values[1]
        local priority = priorities[1]
        values[1] = nil
        priorities[1] = nil
        s._size = 0
        return value, priority
    end

    local value = values[1]
    local priority = priorities[1]

    values[1] = values[s._size]
    values[s._size] = nil
    priorities[1] = priorities[s._size]
    priorities[s._size] = nil
    s._size = s._size - 1
    _down_heap(s, 1)
    return value, priority
end

function SimpleMinHeap:peek()
    local value = self._values[1]
    if value == nil then
        return nil
    end
    local priority = self._priorities[1]
    return value, priority
end

function SimpleMinHeap:clear()
    self._values = {}
    self._priorities = {}
    self._size = 0
end

function SimpleMinHeap:size()
    return self._size
end

--------------------------------------------------------------------------------

local SimpleMaxHeap = Extend(SimpleMinHeap)

function SimpleMaxHeap:_init()
    self:_super()
end

function SimpleMaxHeap:insert(value, priority)
    SimpleMinHeap.insert(self, value, -priority)
end

function SimpleMaxHeap:extract(value, priority)
    local value, priority = SimpleMinHeap.extract(self)
    return value, -priority
end

function SimpleMaxHeap:peek(value, priority)
    local value, priority = SimpleMinHeap.peek(self)
    return value, -priority
end

return SimpleMinHeap, SimpleMaxHeap
