local path = core.get_modpath("star")
local generator = dofile(path .. "/main/generator.lua")
local function_cache = {}

local function get_fn(w, h)
    if function_cache[w] == nil then
        function_cache[w] = {}
    end
    if function_cache[w][h] == nil then
        function_cache[w][h] = generator(w, h)
    end
    return function_cache[w][h]
end

return get_fn
