local path = core.get_modpath("star")
local ptn, ntp = dofile(path .. "/util/pos_to_num.lua")
local MinHeap = priority_queue
local floor, sqrt = math.floor, math.sqrt

local get_fn = dofile(path .. "/main/get.lua")

local function h(sx, sy, sz, ex, ey, ez)
    -- Grossly overestimate distance for performance gains. (Returned paths may be suboptimal.)
    return 2 * sqrt(
        (sx - ex)^2 +
        (sy - ey)^2 +
        (sz - ez)^2 )
end

Pathfinder = {}
Pathfinder.__index = Pathfinder

function Pathfinder:new()
    local instance = setmetatable({}, Pathfinder)
    instance.heap = MinHeap:new()
    return instance
end

function Pathfinder:find_path(start_pos, end_pos, settings)
    local start = core.get_us_time()

    local sx, sy, sz = start_pos.x, start_pos.y, start_pos.z
    local ex, ey, ez = end_pos.x, end_pos.y, end_pos.z

    print("Distance is " .. sqrt((sx - ex)^2 + (sy - ey)^2 + (sz - ez)^2) .. " m.")



    ----------------
    local WIDTH = 2
    local HEIGHT = 2
    ----------------



    local AS = get_fn(WIDTH, HEIGHT)

    local id = ptn(sx, sy, sz)

    local open_set = self.heap
    open_set:clear()

    open_set:insert(id, 0)
    local g_values = {}
    g_values[id] = 0
    local parent_nodes = {}
    local elevations = {}

    local limit = 5000
    local total = 0

    while true do
        limit = limit - 1
        if limit == 0 then break end

        local id, cost = open_set:extract()
        if id == nil then
            break
        end
        local x, y, z = ntp(id)
        local px, py, pz = x, y, z
        local pid = parent_nodes[id]
        if pid then
            px, py, pz = ntp(pid)
        end

        if x == ex and y == ey and z == ez then
            print("End reached.")

            local stop = core.get_us_time()
            local time = stop - start
            print("Time: " .. time / 1000 .. " ms")

            local parent_id = ptn(ex, ey, ez)
            local nodes = 0
            while true do
                nodes = nodes + 1
                local x, y, z = ntp(parent_id)
                star.p_red(x,y,z)

                parent_id = parent_nodes[parent_id]
                if parent_id == nil then
                    print("NODES: " .. nodes)
                    print("TOTAL: " .. total)
                    break
                end
            end

            break
        end

        ------------------------------------------------------------------------

        local elevation = elevations[id]

        if true then end

        -- FIXME: Not very good...

        local N, E, S, W = AS(x, y, z, px, py, pz)
        local g = g_values[id]

        if N then
            local nid = ptn(x, y, z + 1)
            local ng = g_values[nid]

            if (ng == nil) or (ng > (g + 1)) then
                g_values[nid] = g + 1
                open_set:insert(nid, g + 1 + h(x, y, z + 1, ex, ey, ez))
                total = total + 1
                parent_nodes[nid] = id

            end
        end

        if E then
            local nid = ptn(x + 1, y, z)
            local ng = g_values[nid]

            if (ng == nil) or (ng > (g + 1)) then
                g_values[nid] = g + 1
                open_set:insert(nid, g + 1 + h(x + 1, y, z, ex, ey, ez))
                total = total + 1
                parent_nodes[nid] = id

            end
        end

        if S then
            local nid = ptn(x, y, z - 1)
            local ng = g_values[nid]

            if (ng == nil) or (ng > (g + 1)) then
                g_values[nid] = g + 1
                open_set:insert(nid, g + 1 + h(x, y, z - 1, ex, ey, ez))
                total = total + 1
                parent_nodes[nid] = id

            end
        end

        if W then
            local nid = ptn(x - 1, y, z)
            local ng = g_values[nid]

            if (ng == nil) or (ng > (g + 1)) then
                g_values[nid] = g + 1
                open_set:insert(nid, g + 1 + h(x - 1, y, z, ex, ey, ez))
                total = total + 1
                parent_nodes[nid] = id

            end
        end
    end
end

return Pathfinder
