local floor = math.floor

function pos_to_num(x, y, z)
    return(
        (x + 2^15) * 2^32 +
        (y + 2^15) * 2^16 +
        (z + 2^15)
    )
end

function num_to_pos(n)
    local x = floor(n / 2^32)
    n = n - x * 2^32
    local y = floor(n / 2^16)
    n = n - y * 2^16
    return x - 2^15, y - 2^15, n - 2^15
end

return pos_to_num, num_to_pos
