local function generate(w, h)
    local code = {}
    local c = 1
    local function add(str)
        code[c] = str
        c = c + 1
    end
    local c2 = 0
    local function loader()
        c2 = c2 + 1
        return code[c2]
    end
    local areas = {
        --        x1     y1     z1     x2     y2     z2
        ["N"] = { 0,     0,     w,     w - 1, h - 1, w    },
        ["E"] = { w,     0,     0,     w    , h - 1, w - 1},
        ["S"] = { 0,     0,    -1,     w - 1, h - 1,-1    },
        ["W"] = {-1,     0,     0,    -1    , h - 1, w - 1},

        ["_N"]= { 0,    -1,     w,     w - 1,-1    , w    },
        ["_E"]= { w,    -1,     0,     w    ,-1    , w - 1},
        ["_S"]= { 0,    -1,    -1,     w - 1,-1    ,-1    },
        ["_W"]= {-1,    -1,     0,    -1    ,-1    , w - 1},

        ["D"] = { 0,    -1,     0,     w - 1,-1    , w - 1},
        ["U"] = { 0,     h,     0,     w - 1, h    , w - 1},

        ["L"] = { 0,     0,     0,     w - 1, 0    , w - 1},
        ["L_"]= { 0,    -1,     0,     w - 1,-1    , w - 1},
    }
    local function area_nodes(a)
        local out = {}
        local x1, y1, z1, x2, y2, z2 = a[1], a[2], a[3], a[4], a[5], a[6]
        for y = y1, y2 do
            for x = x1, x2 do
                for z = z1, z2 do
                    out[#out+1] = x
                    out[#out+1] = y
                    out[#out+1] = z
                end
            end
        end
        return out
    end
    local function area_str(...)
        local args = {...}
        local area = args[1]

        local str = ""
        for _, v in pairs(args) do
            if v ~= "L" and v ~= "L_" then
                str = str .. v .. " = "
                local nodes = area_nodes(areas[v])
                for i = 1, #nodes - 3, 3 do
                    str = str .. "passable[node_raw(" .. nodes[i] .. " + x1, " .. nodes[i+1] .. " + y1, " .. nodes[i+2] .. " + z1)] + "
                end
                str = str .. "passable[node_raw(" .. nodes[#nodes-2] .. " + x1, " .. nodes[#nodes-1] .. " + y1, " .. nodes[#nodes] .. " + z1)]\n"
            else
                str = str .. v .. " = "
                local nodes = area_nodes(areas[v])
                for i = 1, #nodes - 3, 3 do
                    str = str .. "climbable[node_raw(" .. nodes[i] .. " + x1, " .. nodes[i+1] .. " + y1, " .. nodes[i+2] .. " + z1)] + "
                end
                str = str .. "climbable[node_raw(" .. nodes[#nodes-2] .. " + x1, " .. nodes[#nodes-1] .. " + y1, " .. nodes[#nodes] .. " + z1)]\n"
            end
        end
        return str
    end

    local function area_str2(...)
        local args = {...}
        local area = args[1]

        local str = ""
        for _, v in pairs(args) do
            str = str .. v .. " = "
            local nodes = area_nodes(areas["_" .. v])
            for i = 1, #nodes - 3, 3 do
                str = str .. "passable[node_raw(" .. nodes[i] .. " + x1, " .. nodes[i+1] .. " + y1, " .. nodes[i+2] .. " + z1)] + "
            end
            str = str .. "passable[node_raw(" .. nodes[#nodes-2] .. " + x1, " .. nodes[#nodes-1] .. " + y1, " .. nodes[#nodes] .. " + z1)]\n"

            str = str .. "if " .. v .. " <= -99 then\n"

            str = str .. v .. " = "
            nodes = area_nodes(areas[v])
            for i = 1, #nodes - 3, 3 do
                str = str .. "passable[node_raw(" .. nodes[i] .. " + x1, " .. nodes[i+1] .. " + y1, " .. nodes[i+2] .. " + z1)] + "
            end
            str = str .. "passable[node_raw(" .. nodes[#nodes-2] .. " + x1, " .. nodes[#nodes-1] .. " + y1, " .. nodes[#nodes] .. " + z1)]\n"
            str = str .. "else " .. v .. " = -99 end\n"
        end
        return str
    end

    add([[

local passable = star.d_passable
local climbable = star.d_ladder
local node_raw = core.get_node_raw

return function(x1, y1, z1, x2, y2, z2, climb, elevation, MAX_DROP)
]])
    add([[
local N, E, S, W, D, U, NE, SE, NW, SW, L = -99, -99, -99, -99, -99, -99, -99, -99, -99, -99, -99
local dx, dy, dz = x1 - x2, y1 - y2, z1 - z2

if climb then
]])
add(area_str("L"))
add([[

end

if dy < 1 then
]])
add(area_str("D"))
add([[

    if climb and (elevation == MAX_DROP) then
]])
    add("local " .. area_str("L_"))
    add([[

        if L_ >= 0 then L = 0 end
    end
    if D >= 0 then return N, E, S, W, D, U, L end
end

if dy > -1 then
]])
add(area_str("U"))
add([[

end
if dy < 1 then
    if dx < 0 then
        if dz < 0 then
            --
        elseif dz == 0 then
    ]])
        add(area_str("W","S","N"))
        add([[

        else
            --
        end
    elseif dx == 0 then
        if dz < 0 then
    ]])
        add(area_str("S","E","W"))
        add([[

        elseif dz == 0 then
    ]])
        add(area_str("N","E","S","W")) -- //
        add([[

        else
    ]])
        add(area_str("N","W","E"))
        add([[

        end
    else
        if dz < 0 then
            --
        elseif dz == 0 then
    ]])
        add(area_str("E","N","S"))
        add([[

        else
            --
        end
    end
else
    if dx < 0 then
        if dz < 0 then
            --
        elseif dz == 0 then
    ]])
        add(area_str2("W","S","N"))
        add([[

        else
            --
        end
    elseif dx == 0 then
        if dz < 0 then
    ]])
        add(area_str2("S","E","W"))
        add([[

        elseif dz == 0 then
    ]])
        add(area_str2("N","E","S","W")) -- //
        add([[

        else
    ]])
        add(area_str2("N","W","E"))
        add([[

        end
    else
        if dz < 0 then
            --
        elseif dz == 0 then
    ]])
        add(area_str2("E","N","S"))
        add([[

        else
            --
        end
    end
end
return N, E, S, W, D, U, L
]])
    add("end")
    return load(loader)()
end

return generate
