## API

#### `star.find_path(pos1, pos2, settings)`

Returns a path as a flat array (from end to start): `{x1, y1, z1, x2, y2, z2, ...}`

Arguments:

- `pos1`, `pos2`: `{x = ..., y = ..., z = ...}`
    + `pos1` is the starting position and `pos2` the target position.
- `settings`: `{height = ..., etc.}`

Settings (values must be positive natural numbers):

- `width`: Specifies the object size along x- and z-axes. Defaults to `1`.
- `height`: Specifies the object size along the y-axis. Defaults to `2`.
- `max_jump`: Specifies the maximum jump height. Defaults to `1`.
- `max_drop`: Specifies the maximum drop height. Defaults to `1`.
- `max_iter`: Specifies the maximum number of main loop iterations before quitting. Defaults to `256`. For now, has a hard limit of `1024`.
- `climb`: Sets the ability to climb ladders (`true` or `false`). Defaults to `false`.

TODO:
- Diagonal movement is missing
- Weighted terrain
