local path = core.get_modpath("star")
local ptn, ntp = dofile(path .. "/util/pos_to_num.lua")
local PQ = priority_queue
local floor, sqrt = math.floor, math.sqrt

local get_fn = dofile(path .. "/main/get.lua")

local open_set = PQ:new()

function find_path(start_pos, end_pos, settings)
    local start = core.get_us_time()

    local sx, sy, sz = start_pos.x, start_pos.y, start_pos.z
    local ex, ey, ez = end_pos.x, end_pos.y, end_pos.z

    print("Distance is " .. sqrt((sx - ex)^2 + (sy - ey)^2 + (sz - ez)^2) .. " m.")

    local WIDTH = settings.width or 1
    local HEIGHT = settings.height or 2
    local MAX_JUMP = settings.max_jump or 1
    local MAX_DROP = -(settings.max_drop or 1)
    local MAX_ITER = settings.max_iterations or 256
    local CLIMB = settings.climb or false

    -- Hard limit (for now).
    if MAX_ITER > 1024 then MAX_ITER = 1024 end

    local AS = get_fn(WIDTH, HEIGHT)

    local id = ptn(sx, sy, sz)

    open_set:clear()

    open_set:insert(id, 0)
    local g_values = {}
    g_values[id] = 0
    local parent_nodes = {}
    local elevations = {}

    --local total = 0

    while true do
        MAX_ITER = MAX_ITER - 1
        if MAX_ITER == 0 then return nil end

        local id, cost = open_set:extract()
        if id == nil then
            break
        end
        local x, y, z = ntp(id)
        local px, py, pz = x, y, z
        local pid = parent_nodes[id]
        if pid then
            px, py, pz = ntp(pid)
        end

        --star.p_white(x, y, z)

        if x == ex and y == ey and z == ez then
            print("End reached.")
            local stop = core.get_us_time()
            local time = stop - start
            print("Time: " .. time / 1000 .. " ms")

            local parent_id = ptn(ex, ey, ez)
            local c = 1
            local path = {}

            while true do
                path[c], path[c + 1], path[c + 2] = ntp(parent_id)
                c = c + 3
                parent_id = parent_nodes[parent_id]
                if parent_id == nil then
                    print("NODES: " .. #path/3)
                    --print("TOTAL: " .. total)
                    return path
                end
            end
        end

        ------------------------------------------------------------------------

        local elevation = elevations[id] or 0
        local N, E, S, W, D, U, L = AS(x, y, z, px, py, pz, CLIMB, elevation, MAX_DROP)
        local g = g_values[id]

        if D >= 0 and (elevation > MAX_DROP or L == 0) then
            local nid = ptn(x, y - 1, z)
            local ng = g_values[nid]

            if (ng == nil) or (ng > (g + 1)) then
                g_values[nid] = g + 1
                open_set:insert(nid, g + 1 + 2 * sqrt((x - ex)^2 + (y - 1 - ey)^2 + (z - ez)^2))
                --total = total + 1
                parent_nodes[nid] = id

                if L == 0 then
                    elevations[nid] = 0
                else
                    elevations[nid] = elevation - 1
                end
            end
        elseif D <= -99 then
            if U >= 0 and elevation < MAX_JUMP then
                local nid = ptn(x, y + 1, z)
                local ng = g_values[nid]

                if (ng == nil) or (ng > (g + 1)) then
                    g_values[nid] = g + 1
                    open_set:insert(nid, g + 1 + 2 * sqrt((x - ex)^2 + (y + 1 - ey)^2 + (z - ez)^2))
                    --total = total + 1
                    parent_nodes[nid] = id

                    if L == 0 then
                        elevations[nid] = MAX_JUMP - 1
                    else
                        elevations[nid] = elevation + 1
                    end
                end
            end

            if N >= 0 then
                local nid = ptn(x, y, z + 1)
                local ng = g_values[nid]

                if (ng == nil) or (ng > (g + 1)) then
                    g_values[nid] = g + 1
                    open_set:insert(nid, g + 1 + 2 * sqrt((x - ex)^2 + (y - ey)^2 + (z + 1 - ez)^2))
                    --total = total + 1
                    parent_nodes[nid] = id

                end
            end

            if E >= 0 then
                local nid = ptn(x + 1, y, z)
                local ng = g_values[nid]

                if (ng == nil) or (ng > (g + 1)) then
                    g_values[nid] = g + 1
                    open_set:insert(nid, g + 1 + 2 * sqrt((x + 1 - ex)^2 + (y - ey)^2 + (z - ez)^2))
                    --total = total + 1
                    parent_nodes[nid] = id

                end
            end

            if S >= 0 then
                local nid = ptn(x, y, z - 1)
                local ng = g_values[nid]

                if (ng == nil) or (ng > (g + 1)) then
                    g_values[nid] = g + 1
                    open_set:insert(nid, g + 1 + 2 * sqrt((x - ex)^2 + (y - ey)^2 + (z - 1 - ez)^2))
                    --total = total + 1
                    parent_nodes[nid] = id

                end
            end

            if W >= 0 then
                local nid = ptn(x - 1, y, z)
                local ng = g_values[nid]

                if (ng == nil) or (ng > (g + 1)) then
                    g_values[nid] = g + 1
                    open_set:insert(nid, g + 1 + 2 * sqrt((x - 1 - ex)^2 + (y - ey)^2 + (z - ez)^2))
                    --total = total + 1
                    parent_nodes[nid] = id

                end
            end
        end
    end
end

return find_path
