local particle_template_1 = {
    pos = {x=0, y=0, z=0},
    velocity = {x=0, y=0, z=0},
    acceleration = {x=0, y=0, z=0},
    expirationtime = 1,
    size = 2,
    collisiondetection = false,
    texture = "particle1.png",
    glow = 14
}

local particle_template_2 = {
    pos = {x=0, y=0, z=0},
    velocity = {x=0, y=0, z=0},
    acceleration = {x=0, y=0, z=0},
    expirationtime = 2,
    size = 4,
    collisiondetection = false,
    texture = "particle2.png",
    glow = 14
}

core.register_tool("star:testing_tool", {
    description = "A testing tool for pathfinder.",
    on_use = function(itemstack, user, pointed_thing)
        if pointed_thing.type == "node" then
            local pos = pointed_thing.above
            star.TEST_START_POS = pos
            local x, y, z = pos[1], pos[2], pos[3]
            core.chat_send_all(string.format("Start: %d, %d, %d", x, y, z))

            local pdef = particle_template_1
            pdef.pos = {x = x, y = y, z = z}
            core.add_particle(pdef)
        end
    end,
    on_place = function(itemstack, placer, pointed_thing)
        if pointed_thing.type == "node" then
            local pos = pointed_thing.above
            star.TEST_END_POS = pos
            local x, y, z = pos[1], pos[2], pos[3]
            core.chat_send_all(string.format("End: %d, %d, %d", x, y, z))

            local pdef = particle_template_1
            pdef.pos = {x = x, y = y, z = z}
            core.add_particle(pdef)
        end
    end,
})

core.register_tool("star:initiate", {
    description = "Initiates pathfinder test run.",
    on_use = function(itemstack, user, pointed_thing)
        local path = star.find_path(star.TEST_START_POS, star.TEST_END_POS, {})
        if path then
            for i = 1, #path, 3 do
                star.p_red(path[i], path[i + 1], path[i + 2])
            end
        end
    end
})

function star.p_white(x, y, z)
    local pdef = particle_template_1
    pdef.pos = {x = x, y = y, z = z}
    core.add_particle(pdef)
end

function star.p_red(x, y, z)
    local pdef = particle_template_2
    pdef.pos = {x = x, y = y, z = z}
    core.add_particle(pdef)
end
