--PilzAdam (MIT)
--ShadowNinja (MIT)
--sofar (sofar@foo-projects.org) (MIT)
--Various Minetest developers and contributors (MIT)

fl_tnt = {}

-- loss probabilities array (one in X will be lost)
local loss_prob = {}

--loss_prob["default:cobble"] = 3
--loss_prob["default:dirt"] = 4

-- Fill a list with data for content IDs, after all nodes are registered
local cid_data = {}
minetest.register_on_mods_loaded(function()
	for name, def in pairs(minetest.registered_nodes) do
		cid_data[minetest.get_content_id(name)] = {
			name = name,
			drops = def.drops,
			flammable = def.groups.flammable,
			on_blast = def.on_blast,
		}
	end
end)

local function rand_pos(center, pos, radius)
	local def
	local reg_nodes = minetest.registered_nodes
	local i = 0
	repeat
		-- Give up and use the center if this takes too long
		if i > 4 then
			pos.x, pos.z = center.x, center.z
			break
		end
		pos.x = center.x + math.random(-radius, radius)
		pos.z = center.z + math.random(-radius, radius)
		def = reg_nodes[minetest.get_node(pos).name]
		i = i + 1
	until def and not def.walkable
end

local function eject_drops(drops, pos, radius)
	local drop_pos = vector.new(pos)
	for _, item in pairs(drops) do
		local count = math.min(item:get_count(), item:get_stack_max())
		while count > 0 do
			local take = math.max(1,math.min(radius * radius,
					count,
					item:get_stack_max()))
			rand_pos(pos, drop_pos, radius)
			local dropitem = ItemStack(item)
			dropitem:set_count(take)
			local obj = minetest.add_item(drop_pos, dropitem)
			if obj then
				obj:get_luaentity().collect = true
				obj:set_acceleration({x = 0, y = -10, z = 0})
				obj:set_velocity({x = math.random(-3, 3),
						y = math.random(0, 10),
						z = math.random(-3, 3)})
			end
			count = count - take
		end
	end
end

local function add_drop(drops, item)
	item = ItemStack(item)
	local name = item:get_name()
	if loss_prob[name] ~= nil and math.random(1, loss_prob[name]) == 1 then
		return
	end

	local drop = drops[name]
	if drop == nil then
		drops[name] = item
	else
		drop:set_count(drop:get_count() + item:get_count())
	end
end

local basic_flame_on_construct -- cached value
local function destroy(drops, npos, cid, c_air, c_fire,
		on_blast_queue, on_construct_queue,
		ignore_protection, ignore_on_blast, owner)
	if not ignore_protection and minetest.is_protected(npos, owner) then
		return cid
	end

    --minetest.chat_send_all(dump(on_blast_queue))

	local def = cid_data[cid]
    --minetest.chat_send_all(dump(cid_data[minetest.get_content_id("fl_stone:bedrock")]))
    --minetest.chat_send_all(minetest.get_name_from_content_id(cid))

	if not def then
        --minetest.chat_send_all("no def")
		return c_air
	elseif not ignore_on_blast and def.on_blast then
		on_blast_queue[#on_blast_queue + 1] = {
			pos = vector.new(npos),
			on_blast = def.on_blast
		}
        --minetest.chat_send_all("on blast")
		return cid
	elseif def.flammable then
		on_construct_queue[#on_construct_queue + 1] = {
			fn = basic_flame_on_construct,
			pos = vector.new(npos)
		}
        --minetest.chat_send_all("flammable")
		return c_fire
	else
		local node_drops = minetest.get_node_drops(def.name, "")
		for _, item in pairs(node_drops) do
			add_drop(drops, item)
		end
        --minetest.chat_send_all("else")
		return c_air
	end
end

local function calc_velocity(pos1, pos2, old_vel, power)
	-- Avoid errors caused by a vector of zero length
	if vector.equals(pos1, pos2) then
		return old_vel
	end

	local vel = vector.direction(pos1, pos2)
	vel = vector.normalize(vel)
	vel = vector.multiply(vel, power)

	-- Divide by distance
	local dist = vector.distance(pos1, pos2)
	dist = math.max(dist, 1)
	vel = vector.divide(vel, dist)

	-- Add old velocity
	vel = vector.add(vel, old_vel)

	-- randomize it a bit
	vel = vector.add(vel, {
		x = math.random() - 0.5,
		y = math.random() - 0.5,
		z = math.random() - 0.5,
	})

	-- Limit to terminal velocity
	dist = vector.length(vel)
	if dist > 250 then
		vel = vector.divide(vel, dist / 250)
	end
	return vel
end

local function entity_physics(pos, radius, drops)
	local objs = minetest.get_objects_inside_radius(pos, radius)
	for _, obj in pairs(objs) do
		local obj_pos = obj:get_pos()
		local dist = math.max(1, vector.distance(pos, obj_pos))

		local damage = (4 / dist) * radius
		if obj:is_player() then
			local dir = vector.normalize(vector.subtract(obj_pos, pos))
			local moveoff = vector.multiply(dir, 2 / dist * radius)
			obj:add_velocity(moveoff)

			obj:set_hp(obj:get_hp() - damage)
		else
			local luaobj = obj:get_luaentity()

			-- object might have disappeared somehow
			if luaobj then
				local do_damage = true
				local do_knockback = true
				local entity_drops = {}
				local objdef = minetest.registered_entities[luaobj.name]

				if objdef and objdef.on_blast then
					do_damage, do_knockback, entity_drops = objdef.on_blast(luaobj, damage)
				end

				if do_knockback then
					local obj_vel = obj:get_velocity()
					obj:set_velocity(calc_velocity(pos, obj_pos,
							obj_vel, radius * 10))
				end
				if do_damage then
					if not obj:get_armor_groups().immortal then
						obj:punch(obj, 1.0, {
							full_punch_interval = 1.0,
							damage_groups = {fleshy = damage},
						}, nil)
					end
				end
				for _, item in pairs(entity_drops) do
					add_drop(drops, item)
				end
			end
		end
	end
end

local function add_effects(pos, radius, drops)
	minetest.add_particle({
		pos = pos,
		velocity = {x=0, y=1, z=0},
		acceleration = vector.new(),
		expirationtime = 2,
		size = radius * 10,
		collisiondetection = false,
		vertical = false,
		texture = "farlands_explosion.png",
        animation = {type="vertical_frames", aspect_w=32, aspect_h=32, frame_length=1},
		glow = 15,
	})
	minetest.add_particlespawner({
		amount = 16,
		time = 0.5,
		minpos = vector.subtract(pos, radius / 2),
		maxpos = vector.add(pos, radius / 2),
		minvel = {x = -1, y = 2, z = -1},
		maxvel = {x = 1, y = 5, z = 1},
		minacc = vector.new(),
		maxacc = vector.new(),
		minexptime = 0.5,
		maxexptime = 1,
		minsize = radius * 3,
		maxsize = radius * 5,
		texture = "farlands_explosion_small.png",
        animation = {type="vertical_frames", aspect_w=32, aspect_h=32, frame_length=1},
	})
    minetest.add_particlespawner({
		amount = 32,
		time = 0.5,
		minpos = vector.subtract(pos, radius / 2),
		maxpos = vector.add(pos, radius / 2),
		minvel = {x = -1, y = 2, z = -1},
		maxvel = {x = 1, y = 5, z = 1},
		minacc = vector.new(),
		maxacc = vector.new(),
		minexptime = 1,
		maxexptime = 2.5,
		minsize = radius * 3,
		maxsize = radius * 5,
		texture = "farlands_smoke.png",
        animation = {type="vertical_frames", aspect_w=32, aspect_h=32, frame_length=1},
	})
    minetest.after(0.2, function()
		minetest.add_particle({
			pos = {x=pos.x-0.5, y=pos.y-0.5, z=pos.z},
			velocity = {x=0, y=1, z=0},
			acceleration = {x=0, y=0, z=0},
			expirationtime = 2,
			size = radius * 10,
			collisiondetection = false,
			vertical = false,
			texture = "farlands_explosion.png",
			animation = {type="vertical_frames", aspect_w=32, aspect_h=32, frame_length=1},
			glow = 10
		})
	end)
	minetest.after(0.4, function()
		minetest.add_particle({
			pos = {x=pos.x+0.5, y=pos.y+0.5, z=pos.z+0.5},
			velocity = {x=0, y=1, z=0},
			acceleration = {x=0, y=0, z=0},
			expirationtime = 2,
			size = radius * 15,
			collisiondetection = false,
			vertical = false,
			texture = "farlands_explosion.png",
			animation = {type="vertical_frames", aspect_w=32, aspect_h=32, frame_length=1},
			glow = 10
		})
	end)

	-- we just dropped some items. Look at the items entities and pick
	-- one of them to use as texture
	--local texture = "tnt_blast.png" --fallback texture
	local node
	local most = 0
	for name, stack in pairs(drops) do
		local count = stack:get_count()
		if count > most then
			most = count
			local def = minetest.registered_nodes[name]
			if def then
				node = { name = name }
			end
            --[[
			if def and def.tiles and def.tiles[1] then
				texture = def.tiles[1]
			end
            --]]
		end
	end

	minetest.add_particlespawner({
		amount = 64,
		time = 0.1,
		minpos = vector.subtract(pos, radius / 2),
		maxpos = vector.add(pos, radius / 2),
		minvel = {x = -3, y = 0, z = -3},
		maxvel = {x = 3, y = 5,  z = 3},
		minacc = {x = 0, y = -10, z = 0},
		maxacc = {x = 0, y = -10, z = 0},
		minexptime = 0.8,
		maxexptime = 2.0,
		minsize = radius * 0.33,
		maxsize = radius,
		--texture = texture,
		-- ^ only as fallback for clients without support for `node` parameter
		node = node,
		collisiondetection = true,
	})
end

local function tnt_explode(pos, radius, ignore_protection, ignore_on_blast, owner, explode_center)
	pos = vector.round(pos)
	-- scan for adjacent TNT nodes first, and enlarge the explosion

	local vm1 = VoxelManip()
	local p1 = vector.subtract(pos, 2)
	local p2 = vector.add(pos, 2)
	local minp, maxp = vm1:read_from_map(p1, p2)
	local a = VoxelArea:new({MinEdge = minp, MaxEdge = maxp})
	local data = vm1:get_data()
	local count = 0
	local c_air = minetest.get_content_id("air")
    local c_tnt = minetest.get_content_id("fl_tnt:tnt")

	-- make sure we still have explosion even when centre node isnt tnt related
	if explode_center then
		count = 1
	end

	for z = pos.z - 2, pos.z + 2 do
	for y = pos.y - 2, pos.y + 2 do
		local vi = a:index(pos.x - 2, y, z)
		for x = pos.x - 2, pos.x + 2 do
            local cid = data[vi]
            if cid == c_tnt then
                minetest.add_entity({x = x, y = y, z = z}, "fl_tnt:tnt_entity")
                count = count + 1
				data[vi] = c_air
            end
			vi = vi + 1
		end
	end
	end

	vm1:set_data(data)
	vm1:write_to_map()

	-- recalculate new radius
	--radius = math.floor(radius * math.pow(count, 1/3))


	-- perform the explosion
    --local c_air = minetest.get_content_id("air")
	local vm = VoxelManip()
	local pr = PseudoRandom(os.time())
	p1 = vector.subtract(pos, radius)
	p2 = vector.add(pos, radius)
	minp, maxp = vm:read_from_map(p1, p2)
	a = VoxelArea:new({MinEdge = minp, MaxEdge = maxp})
	data = vm:get_data()

	local drops = {}
	local on_blast_queue = {}
	local on_construct_queue = {}
	basic_flame_on_construct = minetest.registered_nodes["fl_stone:ors"].on_construct

	local c_fire = minetest.get_content_id("fl_stone:ors")
	for z = -radius, radius do
	for y = -radius, radius do
	local vi = a:index(pos.x + (-radius), pos.y + y, pos.z + z)
	for x = -radius, radius do
		local r = vector.length(vector.new(x, y, z))
		if (radius * radius) / (r * r) >= (pr:next(80, 125) / 100) then
			local cid = data[vi]
			local p = {x = pos.x + x, y = pos.y + y, z = pos.z + z}
			if cid ~= c_air then
				data[vi] = destroy(drops, p, cid, c_air, c_fire,
					on_blast_queue, on_construct_queue,
					ignore_protection, ignore_on_blast, owner)
			end
		end
		vi = vi + 1
	end
	end
	end

	vm:set_data(data)
	vm:write_to_map()
	vm:update_map()
	vm:update_liquids()

	-- call check_single_for_falling for everything within 1.5x blast radius
	for y = -radius * 1.5, radius * 1.5 do
	for z = -radius * 1.5, radius * 1.5 do
	for x = -radius * 1.5, radius * 1.5 do
		local rad = {x = x, y = y, z = z}
		local s = vector.add(pos, rad)
		local r = vector.length(rad)
		if r / radius < 1.4 then
			minetest.check_single_for_falling(s)
		end
	end
	end
	end

	for _, queued_data in pairs(on_blast_queue) do
		local dist = math.max(1, vector.distance(queued_data.pos, pos))
		local intensity = (radius * radius) / (dist * dist)
		local node_drops = queued_data.on_blast(queued_data.pos, intensity)
		if node_drops then
			for _, item in pairs(node_drops) do
				add_drop(drops, item)
			end
		end
	end

	for _, queued_data in pairs(on_construct_queue) do
		queued_data.fn(queued_data.pos)
	end

	minetest.log("action", "TNT owned by " .. owner .. " detonated at " ..
		minetest.pos_to_string(pos) .. " with radius " .. radius)

	return drops, radius
end

function fl_tnt.boom(pos, def)
	def = def or {}
	def.radius = def.radius or 4
    --def.radius = 4
	def.damage_radius = def.damage_radius or def.radius * 2
	local meta = minetest.get_meta(pos)
	local owner = meta:get_string("owner")
    --[[
	local sound = def.sound or "tnt_explode"
	minetest.sound_play(sound, {pos = pos, gain = 2.5,
			max_hear_distance = math.min(def.radius * 20, 128)}, true)
            --]]
	local drops, radius = tnt_explode(pos, def.radius, def.ignore_protection,
			def.ignore_on_blast, owner, def.explode_center)
	-- append entity drops
	local damage_radius = (radius / math.max(1, def.radius)) * def.damage_radius
	entity_physics(pos, damage_radius, drops)
	if not def.disable_drops then
		eject_drops(drops, pos, radius)
	end
	add_effects(pos, radius, drops)
	minetest.log("action", "A TNT explosion occurred at " .. minetest.pos_to_string(pos) ..
		" with radius " .. radius)
end

--start node/entity logic

minetest.register_entity("fl_tnt:tnt_entity", {
    initial_properties = {
        hp_max = 1,
        physical = true,
        collide_with_objects = true,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        visual = "cube",
        textures = {
            "farlands_tnt_top.png",
            "farlands_tnt_bottom.png",
            "farlands_tnt_side.png",
            "farlands_tnt_side.png",
            "farlands_tnt_side.png",
            "farlands_tnt_side.png",
        },
        --damage_texture_modifier = "^[brighten"
    },
    on_activate = function(self, staticdata, dtime_s)
        --self.object:setvelocity({x=0, y=4, z=0})
		self.object:set_acceleration({x=0, y=-10, z=0})
		self.object:set_texture_mod("^[brighten")
        self.object:set_armor_groups({immortal = 1})
    end,
    on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir)
        if puncher:is_player() then self.object:remove() end
    end,
    timer = 0,
    blinktimer = 0,
	blinkstatus = true,
    on_step = function(self, dtime, moveresult)
		self.timer = self.timer + dtime
		local mult = 1
		if self.timer > 5 * 0.8 then -- blink faster before explosion
			mult = 4
		elseif self.timer > 5 * 0.5 then
			mult = 2
		end
		self.blinktimer = self.blinktimer + mult * dtime

		if self.blinktimer > 0.5 then -- actual blinking
			self.blinktimer = self.blinktimer - 0.5
			self.object:settexturemod(self.blinkstatus and "^[brighten" or "")
			self.blinkstatus = not self.blinkstatus
		end

		if self.timer > 5 then -- boom!
			fl_tnt.boom(vector.round(self.object:get_pos()))
			self.object:remove()
		end
	end

})

minetest.register_node("fl_tnt:tnt", {
    description = "tnt",
    tiles = {"farlands_tnt_top.png", "farlands_tnt_bottom.png", "farlands_tnt_side.png"},
    on_punch = function(pos, node, puncher)
		if minetest.is_protected(pos, puncher:get_player_name()) then return end
        minetest.remove_node(pos)
        local entity = minetest.add_entity(pos, "fl_tnt:tnt_entity")
        entity:set_velocity({x=0, y=4, z=0})
    end,
    groups = {snappy = 3},
})