minetest.register_node("trails:path", {
	description = "Grass Path",
	tiles = {"path.png"},
	groups = {crumbly = 3},
	drop = "default:dirt",
})
minetest.register_node("trails:dry_path", {
	description = "Savanna Path",
	tiles = {"dry_path.png"},
	groups = {crumbly = 3},
	drop = "default:dirt",
})
minetest.register_node("trails:rainforest_path", {
	description = "Rainforest Path",
	tiles = {"rain_path.png"},
	groups = {crumbly = 3},
	drop = "default:dirt",
})

minetest.register_tool("trails:ground_roller", {
	description = "Ground Roller",
	inventory_image = "ground_roller.png",
	on_use = function(itemstack, user, pointed_thing)
		local pos = pointed_thing.under
		local node = minetest.get_node(pos)
		if node.name == "default:dirt_with_grass" then
			minetest.set_node(pos, {name = "trails:path"})
		elseif  node.name == "default:dry_dirt_with_dry_grass" then
			minetest.set_node(pos, {name = "trails:dry_path"})
		elseif node.name == "default:dirt_with_rainforest_litter" then
			minetest.set_node(pos, {name = "trails:rainforest_path"})

		end
	end,
})

minetest.register_craft({
	output = "trails:ground_roller",
	recipe = {
		{"default:cobble", "default:cobble", "default:cobble"},
		{"default:cobble", "default:stick", "default:cobble"},
		{"default:cobble", "default:cobble", "default:cobble"},
	}
})

