-- LUALOCALS < ---------------------------------------------------------
local include, nc
    = include, nc
-- LUALOCALS > ---------------------------------------------------------

nc.amcoremod()

local modname = core.get_current_modname()

core.unregister_biome("unknown")

core.register_biome({
    name = "modified_unknown",
    node_top = "nc_terrain:dirt_with_grass",
    depth_top = 1,
    node_filler = "nc_terrain:stone",
    depth_filler = 1,
    node_riverbed = "nc_terrain:stone",
    depth_riverbed = 2,
    y_min = 4,
    y_max = 31000,
    heat_point = 0,
    humidity_point = 0,
})

core.register_ore({
    name = "stony_grass",
    ore_type = "blob",
    ore = "nc_terrain:stone",
    wherein = "nc_terrain:dirt_with_grass",
    clust_size = 16,
    clust_scarcity = 8 * 8 * 8,
    random_factor = 0,
    noise_param = {
        offset = 0,
        scale = 3,
        spread = {x = 10 , y = 25 , z = 10 },
        octaves = 3,
        persist = 0.5,
        flags = "eased",
    },
    noise_thershold = 1.2,
})

core.register_ore({
    name = "stony_sand",
    ore_type = "blob",
    ore = "nc_terrain:stone",
    wherein = "nc_terrain:sand",
    clust_size = 16,
    clust_scarcity = 8 * 8 * 8,
    random_factor = 0,
    y_min = 0,
    noise_param = {
        offset = 0,
        scale = 3,
        spread = {x = 10 , y = 25 , z = 10 },
        octaves = 3,
        persist = 0.5,
        flags = "eased",
    },
    noise_thershold = 1.2,
})

core.register_ore({
        name = "dirt",
        ore_type = "blob",
        ore = "nc_terrain:dirt",
        wherein = "nc_terrain:stone",
        clust_size = 6,
        clust_scarcity = 8 * 8 * 8,
        random_factor = 0,
        y_min = -79,
        noise_param = {
            offset = 0,
            scale = 3,
            spread = {x = 10 , y = 25 , z = 10 },
            octaves = 3,
            persist = 0.5,
            flags = "eased",
        },
        noise_thershold = 1.2,
})
