local minx, minz, maxx, maxz
local border_name = "mcl_core:obsidian"
local border_built = false

function build_border()
	if border_built then return end
	border_built = true

	-- place border
		for dx=-1,16 do
			local x = minx + dx
			do
				local z = maxz + 1
				local y = minetest.get_spawn_level(x,z)
				if y then
					y = y - 2
					minetest.set_node({x=x, y=y, z=z}, {name=border_name})
				else
					border_built = false
				end
			end
			do
				local z = minz - 1
				local y = minetest.get_spawn_level(x,z)
				if y then
					y = y - 2
					minetest.set_node({x=x, y=y, z=z}, {name=border_name})
				else
					border_built = false
				end
			end
		end
		for dz=-1,16 do
			local z = minz + dz
			do
				local x = maxx + 1
				local y = minetest.get_spawn_level(x,z)
				if y then
					y = y - 2
					minetest.set_node({x=x, y=y, z=z}, {name=border_name})
				else
					border_built = false
				end
			end
			do
				local x = minx - 1
				local y = minetest.get_spawn_level(x,z)
				if y then
					y = y - 2
					minetest.set_node({x=x, y=y, z=z}, {name=border_name})
				else
					border_built = false
				end
			end
		end
end

function gegenereerd()
	if not minx or border_built then
		return
	end

	build_border()
end

function join(player)
	local startpos = player:get_pos()
	if not minx then
		minx = math.floor(startpos.x / 16) * 16
		minz = math.floor(startpos.z / 16) * 16
		maxx = minx + 15
		maxz = minz + 15

		build_border()
	end
end

function mag(pos)
	if pos.x < minx then return false end
	if pos.z < minz then return false end
	if pos.x > maxx then return false end
	if pos.z > maxz then return false end
	return true
end

function inhoude(dtime)
	local players = minetest.get_connected_players()
	for _, player in pairs(players) do
		local pos = player:get_pos()
		if not mag(pos) then
			if pos.x < minx then pos.x = minx end
			if pos.z < minz then pos.z = minz end
			if pos.x > maxx then pos.x = maxx end
			if pos.z > maxz then pos.z = maxz end
			player:set_pos(pos)
		end
	end
end

function place(pos, newnode, placer, oldnode, stemstack, pointed_thing)
	if not mag(pos) then
		minetest.set_node(pos, oldnode)
		return true
	else
		return false
	end
end

function dig(pos, oldnode, digger)
	if not mag(pos) then
		minetest.set_node(pos, oldnode)
	end
end

minetest.register_on_generated(gegenereerd)
minetest.register_globalstep(inhoude)
minetest.register_on_joinplayer(join)
minetest.register_on_placenode(place)
minetest.register_on_dignode(dig)