local minx, minz, maxx, maxz
local hasminx, hasminz, hasmaxx, hasmaxz
local border_nodename


local border_built = false

function build_border()
	if minetest.registered_nodes ["mcl_core:obsidian"] then
		border_nodename = "mcl_core:obsidian"
	elseif minetest.registered_nodes ["sand"] then
		border_nodename = "sand"
	else
		error ("No suitable material for chunk border!")
	end

	if border_built then return end
	border_built = true

	-- place border
		for dx=-1,16 do
			local x = minx + dx
			do
				local z = maxz + 1
				local y = minetest.get_spawn_level(x,z)
				if y then
					y = y - 2
					minetest.set_node({x=x, y=y, z=z}, {name=border_nodename})
				else
					border_built = false
				end
			end
			do
				local z = minz - 1
				local y = minetest.get_spawn_level(x,z)
				if y then
					y = y - 2
					minetest.set_node({x=x, y=y, z=z}, {name=border_nodename})
				else
					border_built = false
				end
			end
		end
		for dz=-1,16 do
			local z = minz + dz
			do
				local x = maxx + 1
				local y = minetest.get_spawn_level(x,z)
				if y then
					y = y - 2
					minetest.set_node({x=x, y=y, z=z}, {name=border_nodename})
				else
					border_built = false
				end
			end
			do
				local x = minx - 1
				local y = minetest.get_spawn_level(x,z)
				if y then
					y = y - 2
					minetest.set_node({x=x, y=y, z=z}, {name=border_nodename})
				else
					border_built = false
				end
			end
		end
end

function gegenereerd (minp, maxp, blockseed)
	if not minx or border_built then
		return
	end
	hasminx = minx and minp.x <= minx or hasminx
	hasminz = minz and minp.z <= minz or hasminz
	hasmaxx = maxx and maxp.x >= maxx or hasmaxx
	hasmaxz = maxi and maxp.z >= maxi or hasmaxz

	if hasminx and hasminz and hasmaxx and hasmaxz then
		build_border()
	end
end

function join(player)
	local startpos = player:get_pos()
	if not minx then
		minx = math.floor(startpos.x / 16) * 16
		minz = math.floor(startpos.z / 16) * 16
		maxx = minx + 15
		maxz = minz + 15

		build_border()
	end
end

function mag(pos)
	if pos.x < minx then return false end
	if pos.z < minz then return false end
	if pos.x > maxx then return false end
	if pos.z > maxz then return false end
	return true
end

function inhouden (dtime)
	local players = minetest.get_connected_players()
	for _, player in pairs(players) do
		local pos = player:get_pos()
		if not mag(pos) then
			if pos.x < minx then pos.x = minx end
			if pos.z < minz then pos.z = minz end
			if pos.x > maxx then pos.x = maxx end
			if pos.z > maxz then pos.z = maxz end
			player:set_pos(pos)
		end
	end
end

local old_is_protected = minetest.is_protected

function minetest.is_protected (pos, name)
	if not mag (pos) then
		return true
	else
		return old_is_protected (pos, name)
	end
end

minetest.register_on_generated (gegenereerd)
minetest.register_globalstep (inhouden)
minetest.register_on_joinplayer (join)