This mod integrates Advtrains with the [doc][minetest-doc] mod.

[minetest-doc]: https://content.minetest.net/packages/Wuzzy/doc/

## Usage

The `/helpform` command can be used as usual.

This mod adds the "Wagons" category that contains information related
to the wagons. It also adds adds certain Advtrains-related properties
to certain nodes.

**Please keep in mind that, while this mod attempts to provide accurate
information, its accuracy, especially for information related to
liveries, is limited by various factors. Refer the source code of the
relevant mods for authoritative information.**

## API

Wagon mods can add a description to the `_doc_wagon_longdesc` field of
the wagon prototype; adding `advtrains_doc_integration` as an optional
dependency is _not_ needed.

## CI

If you use [Mineunit][mineunit], you can copy (or add a symlink to)
this directory into the fixtures directory of your mod and then using
(for exmaple) the code below to generate wagon datasheets.

```
require "mineunit"
mineunit "core"
fixture "advtrains_doc_integration/ci/init"
sourcefile "init"
```

[mineunit]: https://github.com/S-S-X/mineunit

If you do not use Mineunit, the following functions are available in
the `advtrains_doc_integration` table:

* `write_wagon_info_as_latex`, which exports the datasheet of a single
type of wagon as LaTeX, and
* `write_all_wagons_as_latex`, which exports all wagon datasheets as
LaTeX.

It is also possible to export wagon datasheets using the `atdoc_write`
command in Minetest.

The datasheets are exported to the world directory (or, for Mineunit,
the fixtures directory). Note that the result of generating datasheets
from Minetest and from CI may differ for various reasons.
