-- Mineunit CI
require "mineunit"
mineunit "core"

if not minetest.get_translated_string then
	local ESCAPE_CHAR = string.char(0x1b)
	function _G.minetest.get_translated_string(_, s)
		return s:gsub(ESCAPE_CHAR .. "%(T@[^)]+%)", ""):gsub(ESCAPE_CHAR .. "[TFE]", "")
	end
end

if not minetest.safe_file_write then
	function _G.minetest.safe_file_write(fn, c)
		local f, e = io.open(fn, "wb")
		if not f then return error(e) end
		f:write(c)
		f:close()
	end
end

_G.advtrains = {
	wagon_prototypes = {},
	register_wagon = function(name, prototype, desc, invimg)
		advtrains.wagon_prototypes[name] = prototype
		minetest.register_craftitem(":"..name, {
			description = desc,
			inventory_image = invimg,
			wield_image = invimg,
			stack_max = 1,
		})
		advtrains_doc_integration.write_wagon_info_as_latex(name)
	end
}

fixture("advtrains_doc_integration/init")
