dir = "ldoc_output"
file = {".", exclude = {"spec", "mtt.lua", "doc_ui.lua"}}
format = "markdown"
project = "Documentation System Integration for Advtrains"
title = "Manual for advtrains_doc_integration"
readme = "README.md"

local function simple_see_handler(pattern, link)
	custom_see_handler(pattern, function(name)
		return name, link
	end)
end

local MT_API = "https://api.minetest.net"

simple_see_handler("^advtrains%.[%w%._]+$", "https://git.bananach.space/advtrains.git/tree/advtrains/api_doc.txt")
simple_see_handler("^SimpleSoundSpec$", MT_API .. "/sounds/#simplesoundspec")
simple_see_handler("^ItemStack$", MT_API .. "/class-reference/#itemstack")

-- vim: ft=lua
