# Documentation System Integration for Advtrains

This mod integrates Advtrains with the [doc][minetest-doc] mod, among
other things.

[minetest-doc]: https://content.minetest.net/packages/Wuzzy/doc/

## Usage

### Documentation Form

The `/helpform` command can be used as usual.

This mod adds the "Wagons" category that contains information related
to the wagons. It also adds adds certain Advtrains-related properties
to certain nodes.

This mod also provides the `atdoc_write` command, which can be used to
export wagon datasheets.

**Please keep in mind that, while this mod attempts to provide accurate
information, its accuracy, especially for information related to
liveries, is limited by various factors. Refer the source code of the
relevant mods for authoritative information.**

### Documentation strings

Wagon mods can add a description to the `_doc_wagon_longdesc` field of
the wagon prototype; adding `advtrains_doc_integration` as an optional
dependency is _not_ needed.

### CI

This mod also be used with [Mineunit][mineunit] in addition to a
regular Minetest environment, such as to generate wagon datasheets.
However, please note that, due to various limitations, the datasheet
generated in such an environment does not contain certain information
that would otherwise be available from Minetest.

[mineunit]: https://github.com/S-S-X/mineunit

## License

This mod is licensed under the [GNU AGPL v3.0][agpl3], a copy of which
can be found in the `LICENSE` file. You may use a later version of the
license if you want.

`bc.lua` uses code from [LuaJIT][luajit], the license statement of
which can be found in the `LICENSE_luajit` file.

[agpl3]: https://www.gnu.org/licenses/agpl-3.0
[luajit]: https://luajit.org/
