#!/bin/sh
modpath=`dirname "$0"`
localepath="$modpath/locale"
potpath="$localepath/advtrains_doc_integration.pot"
xgettext -L lua --from-code=utf-8 --sort-by-file \
	--add-location=file \
	--add-comments='TRANSLATORS:' \
	--package-name=advtrains_doc_integration \
	-kS -kNS \
	-D "$modpath" -o "$potpath" \
	`find "$modpath" -name '*.lua' -printf '%P\n'` \
	&&
for i in "$localepath"/*.po; do
	msgmerge -U --sort-by-file "$i" "$potpath"
done
