local S = minetest.get_translator("train_remote")
local function Sf(...)
	return minetest.formspec_escape(S(...))
end

local function toint(n)
	local m = tonumber(n)
	if n then
		return math.floor(n)
	else
		return nil
	end
end

local function check_train_access(pname, trainid)
	if not minetest.get_player_by_name(pname) then
		return false, S("Player is not online")
	end
	local t = advtrains.trains[trainid]
	if not t then
		return false, S("No train with ID @1", trainid)
	end
	for i = 1, #t.trainparts, 1 do
		local w = advtrains.wagons[t.trainparts[i]]
		if w and advtrains.check_driving_couple_protection(pname, w.owner, w.whitelist) then
			return true
		end
	end
	return false, S("No access to train @1", trainid)
end

-- From advtrains
local function leverof(train)
	if not train then return nil end
	local tlev = train.lever or 3
	if train.velocity == 0 and not train.active_control then tlev = 1 end
	if train.hud_lzb_effect_tmr then tlev = 1 end
	return tlev
end

local fstext_remote = [[
formspec_version[3]
size[11.5,6]
label[0.5,0.5;%s]
button[6,0.5;5,1;update;%s]
label[0.5,1;%s]textlist[0.5,1.5;5,2.5;lever;%s,%s,%s,%s,%s;%d;false]
label[6,2;%s]textlist[6,2.5;5,1.5;door;%s,%s,%s;%d;false]
button[0.5,4.5;5,1;reverse;%s]
textlist[6,4.5;5,1;ars;%s,%s;%d;false]
]]

local function show_train_remote_formspec(pname, trainid)
	if not check_train_access(pname, trainid) then return end
	local t = advtrains.trains[trainid]
	local fs = string.format(fstext_remote,
		Sf("Remote control for @1", trainid),
		Sf("Update"),
		Sf("Lever"),
		Sf("Accelerate"),
		Sf("Neutral"),
		Sf("Roll"),
		Sf("Regular brake"),
		Sf("Emergency brake"),
		5-leverof(t),
		Sf("Door control"),
		Sf("Open left"),
		Sf("Close both"),
		Sf("Open right"),
		(t.door_open or 0)+2,
		Sf("Reverse train"),
		Sf("Enable ARS"),
		Sf("Disable ARS"),
		advtrains.interlocking and t.ars_disable and 2 or 1
	)
	minetest.show_formspec(pname, "train_remote_" .. trainid, fs)
end

local function get_textlist(field, max)
	local et = minetest.explode_textlist_event(field)
	if not et then return nil end
	if et.type == "CHG" or et.type == "DCL"
		and et.index >= 1 and et.index <= max then
		return et.index
	end
	return nil
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
		local pname = player:get_player_name()
		local trainid = string.match(formname, "^train_remote_(%S+)$")
		if not trainid then return end
		if not check_train_access(pname, trainid) then return end
		local t = advtrains.trains[trainid]
		if fields.door then
			local dside = get_textlist(fields.door, 3)
			if dside then
				t.door_open = dside - 2
			end
		elseif fields.lever then
			local tlev = get_textlist(fields.lever, 5)
			if tlev and not t.lzb_effect_tmr then
				t.ctrl_user = 5-tlev
			end
		elseif fields.reverse then
			if t.velocity <= 0 then
				advtrains.invert_train(trainid)
				advtrains.atc.train_reset_command(t)
			end
		elseif fields.ars then
			if advtrains.interlocking then
				local e = get_textlist(fields.ars, 2)
				if e then
					advtrains.interlocking.ars_set_disable(t, e == 2)
				end
			end
		end
		show_train_remote_formspec(pname, trainid)
end)

minetest.register_chatcommand("train_remote", {
		params = "<ID>",
		description = "Remotely control the train",
		func = function(pname, trainid)
			local accessp, msg = check_train_access(pname, trainid)
			if not accessp then
				return false, msg
			end
			show_train_remote_formspec(pname, trainid)
		end
})
