(macro S [...] `(minetest.translate "train_remote" ,...))
(macro Sf [...] `(minetest.formspec_escape (S ,...)))

(macro toint [n]
       `(let [n# (tonumber ,n)]
          (if n# (math.floor n#) nil)))

(macro check-wagon-access [pname wagon]
       `(let [w# ,wagon]
          (advtrains.check_driving_couple_protection pname w#.owner w#.whitelist)))

(macro check-train-access [pname trainid]
       `(let [pn# ,pname tid# ,trainid]
          (if (not (minetest.get_player_by_name pn#))
              (values false (S "Player is not online"))
              (let [t# (. advtrains.trains tid#)]
                (if (not t#) (values false (S "No train with ID @1" tid#))
                    (let [tps# t#.trainparts]
                      (local n# (length tps#))
                      (local wagons# advtrains.wagons)
                      (var i# 0)
                      (var contp# true)
                      (while (and (<= i# n#) contp#)
                        (let [w# (. wagons# (. tps# i#))]
                          (if (and w# (check-wagon-access pn# w#))
                              (set contp# false)
                              (set i# (+ 1 i#)))))
                      (not contp#)))))))

(macro leverof [train]
       `(let [t# ,train]
          (if (not t#) nil
              (and (= t#.velocity 0) (not t#.active_control)) 1
              t#.hud_lzb_effect_tmr 1
              (or t#.lever 3))))

(local fsversion 3)
(local fstext-train "
size[11.5,6]
label[0.5,0.5;%s]
button[6,0.5;5,1;update;%s]
label[0.5,1;%s]textlist[0.5,1.5;5,2.5;lever;%s,%s,%s,%s,%s;%d;false]
label[6,2;%s]textlist[6,2.5;5,1.5;door;%s,%s,%s;%d;false]
button[0.5,4.5;5,1;reverse;%s]
textlist[6,4.5;5,1;ars;%s,%s;%d;false]
")

(macro fsformat [fmt ...]
       (let [argv [...] oargs ['string.format fmt]]
         (for [i 1 (length argv)]
              (tset oargs (+ (length oargs) 1)
                    (if (sequence? (. argv i))
                        (list 'Sf (unpack (. argv i)))
                        (. argv i))))
         (list (unpack oargs))))

(macro show-train-remote-formspec [pname trainid]
       `(let [pn# ,pname tid# ,trainid]
          (if (not (check-train-access pn# tid#)) nil
              (let [t# (. advtrains.trains tid#)]
                (local fs# (fsformat fstext-train
                                         ["Remote control for @1" tid#]
                                         ["Update"]
                                         ["Lever"]
                                         ["Accelerate"]
                                         ["Neutral"]
                                         ["Roll"]
                                         ["Regular brake"]
                                         ["Emergency brake"]
                                         (- 5 (leverof t#))
                                         ["Door control"]
                                         ["Open left"]
                                         ["Close both"]
                                         ["Open right"]
                                         (+ (or t#.door_open 0) 2)
                                         ["Reverse train"]
                                         ["Enable ARS"]
                                         ["Disable ARS"]
                                         (or (and advtrains.interlocking t#.ars_disable 2) 1)))
                (minetest.show_formspec pn# (.. "train_remote:" tid#) fs#)))))

(macro get-textlist [field max]
       `(let [et# (minetest.explode_textlist_event ,field)]
          (if (not et#) nil
              (and (or (= et#.type :CHG) (= et#.type :DCL))
                   (>= et#.index 1) (<= et#.index ,max))
              et#.index
              nil)))

(minetest.register_on_player_receive_fields
 (fn [player formname fields]
     (let [pname (player:get_player_name) trainid (string.match formname "^train_remote:(%S+)$")]
       (if (not trainid) nil
           (not (check-train-access pname trainid)) nil
           (let [t (. advtrains.trains trainid)]
             (if fields.door
                 (let [dside (get-textlist fields.door 3)]
                   (if dside (tset t :door_open (- dside 2))))
                 fields.lever
                 (let [tlev (get-textlist fields.lever 5)]
                   (if (and tlev (not t.lzb_effect_tmr))
                       (tset t :ctrl_user (- 5 tlev))))
                 fields.reverse
                 (when (<= t.velocity 0)
                   (advtrains.invert_train trainid)
                   (advtrains.atc.train_reset_command t))
                 fields.ars
                 (if advtrains.interlocking
                     (let [e (get-textlist fields.ars 2)]
                       (if e (advtrains.interlocking.ars_set_disable t (= e 2))))))
             (show-train-remote-formspec pname trainid))))))

(minetest.register_chatcommand
 "train_remote"
 { :params
   "<ID>"
   :description
   (S "Remotely control the train with the given ID")
   :func
   (fn [pname trainid]
       (let [(accessp msg) (check-train-access pname trainid)]
         (if (not accessp) (values false msg)
             (do (show-train-remote-formspec pname trainid) nil))))})
