(local m {})

(fn S [...] `(minetest.translate "train_remote" ,...))
(fn Sf [...] `(minetest.formspec_escape (S ,...)))

(fn toint [n]
    `(let [n# (tonumber ,n)]
       (if n# (math.floor n#) nil)))

(fn check-wagon-access [pname wagon]
    `(let [w# ,wagon]
       (advtrains.check_driving_couple_protection pname w#.owner w#.whitelist)))

(fn check-train-access [pname trainid]
    `(let [pn# ,pname tid# ,trainid]
       (if (not (minetest.get_player_by_name pn#))
           (values false (S "Player is not online"))
           (let [t# (. advtrains.trains tid#)]
             (if (not t#) (values false (S "No train with ID @1" tid#))
                 (let [tps# t#.trainparts]
                   (local n# (length tps#))
                   (local wagons# advtrains.wagons)
                   (var i# 0)
                   (var contp# true)
                   (while (and (<= i# n#) contp#)
                     (let [w# (. wagons# (. tps# i#))]
                       (if (and w# (check-wagon-access pn# w#))
                           (set contp# false)
                           (set i# (+ 1 i#)))))
                   (not contp#)))))))

(fn leverof [train]
    `(let [t# ,train]
       (if (not t#) nil
           (and (= t#.velocity 0) (not t#.active_control)) 1
           t#.hud_lzb_effect_tmr 1
           (or t#.lever 3))))

(local fsheader "formspec_version[3]")
(local fstext-train "%s
size[11.5,11]
label[0.5,0.75;%s]
label[0.5,1.25;%s]
button[6,0.5;5,1;update;%s]
label[1.25,2;%s]label[1.25,2.5;%s]label[1.25,3;%s]label[1.25,3.5;%s]label[1.25,4;%s]
scrollbaroptions[min=1;max=5;smallstep=1;largestep=1;thumbsize=1;arrows=hide]
scrollbar[0.5,1.75;0.5,2.5;vertical;lever;%d]
label[6,2;%s]scrollbaroptions[min=1;max=3;smallstep=1;largestep=1;thumbsize=1;arrows=hide]
scrollbar[8.5,1.75;2.5,0.5;horizontal;door;%d]
checkbox[6,2.75;ars;%s;%s]
button[6,3.25;5,1;reverse;%s]
field[0.5,5;9.5,1;outtext;%s;%s]
button[10,5;1,1;outset;%s]
field[0.5,6.5;9.5,1;intext;%s;%s]
button[10,6.5;1,1;inset;%s]
field[0.5,8;9.5,1;lntext;%s;%s]
button[10,8;1,1;lnset;%s]
field[0.5,9.5;9.5,1;rctext;%s;%s]
button[10,9.5;1,1;rcset;%s]
")

(fn fsformat [fmt ...]
    (let [argv [...] oargs ['string.format fmt]]
      (for [i 1 (length argv)]
           (tset oargs (+ (length oargs) 1)
                 (if (sequence? (. argv i))
                     (list 'Sf (unpack (. argv i)))
                     (. argv i))))
      (list (unpack oargs))))

(fn show-train-remote-formspec [pname trainid]
    `(let [pn# ,pname tid# ,trainid]
       (if (not (check-train-access pn# tid#)) nil
           (let [t# (. advtrains.trains tid#)]
             (local fs# (fsformat ,fstext-train
                                  ,fsheader
                                  ["Remote control for @1" tid#]
                                  ["Wagon(s): @1" (length t#.trainparts)]
                                  ["Update"]
                                  ["Accelerate"]
                                  ["Neutral"]
                                  ["Roll"]
                                  ["Regular brake"]
                                  ["Emergency brake"]
                                  (- 5 (leverof t#))
                                  ["Door control"]
                                  (+ (or t#.door_open 0) 2)
                                  ["Automatic routesetting"]
                                  (if (and advtrains.interlocking t#.ars_disable) "false" "true")
                                  ["Reverse train"]
                                  ["External display"]
                                  (or t#.text_outside "")
                                  ["Set"]
                                  ["Internal display"]
                                  (or t#.text_inside "")
                                  ["Set"]
                                  ["Line"]
                                  (or t#.line "")
                                  ["Set"]
                                  ["Routing code"]
                                  (or t#.routingcode "")
                                  ["Set"]))
             (minetest.show_formspec pn# (.. "train_remote:t" tid#) fs#)))))

(fn get-textlist [field max]
    `(let [et# (minetest.explode_textlist_event ,field)]
       (if (not et#) nil
           (and (or (= et#.type :CHG) (= et#.type :DCL))
                (>= et#.index 1) (<= et#.index ,max))
           et#.index
           nil)))

(fn has-scrollbar-event [field]
    `(let [et# (minetest.explode_scrollbar_event ,field)]
       (if (not et#) false
           (= et#.type :CHG))))

(fn get-scrollbar [field min max]
    `(let [et# (minetest.explode_scrollbar_event ,field)]
       (if (not et#) nil
           (and (= et#.type :CHG) (>= et#.value ,min) (<= et#.value ,max)) et#.value
           nil)))

(fn handle-train-control-fields [trainid pname fields]
    `(let [trainid# ,trainid pname# ,pname fields# ,fields]
       (if (not trainid#) nil
           (not (check-train-access pname# trainid#)) nil
           (let [t# (. advtrains.trains trainid#)]
             (if (has-scrollbar-event fields#.door)
                 (let [dside# (get-scrollbar fields#.door 1 3)]
                   (if dside# (tset t# :door_open (- dside# 2))))
                 (has-scrollbar-event fields#.lever)
                 (let [tlev# (get-scrollbar fields#.lever 1 5)]
                   (if tlev# (tset t# :ctrl_user (- 5 tlev#))))
                 fields#.reverse
                 (when (<= t#.velocity 0)
                   (advtrains.invert_train trainid#)
                   (advtrains.atc.train_reset_command t#))
                 fields#.ars
                 (if advtrains.interlocking
                     (advtrains.interlocking.ars_set_disable
                      t# (not (minetest.is_yes fields#.ars)))))
             (when fields#.outtext
               (tset t# :text_outside fields#.outtext))
             (when fields#.intext
               (tset t# :text_inside fields#.intext))
             (when fields#.lntext
               (tset t# :line fields#.lntext)
               (minetest.after 0 advtrains.invalidate_path trainid#))
             (when fields#.rctext
               (tset t# :routingcode fields#.rctext)
               (minetest.after 0 advtrains.invalidate_path trainid#))
             (show-train-remote-formspec pname# trainid#)
             nil))))

;; Stub
(fn handle-wagon-control-fields [wagonid pname fields]
    `(let [wagonid# ,wagonid pname# ,pname fields# ,fields] nil))

{:
 S
 : Sf
 : toint
 : check-wagon-access
 : check-train-access
 : leverof
 : fsformat
 : show-train-remote-formspec
 : get-textlist
 : has-scrollbar-event
 : get-scrollbar
 : handle-train-control-fields
 : handle-wagon-control-fields}
