local S = core.get_translator "wnlex"

local function translate_item_description(itemstring, tarlang)
	local itemstack = ItemStack(itemstring)
	local desc, shortdesc = itemstack:get_description(), itemstack:get_short_description()
	local str = ("[->%s] %s -> %s"):format(tarlang, shortdesc, core.get_translated_string(tarlang, shortdesc))
	if desc ~= shortdesc then
		return str .. "\n" .. core.get_translated_string(tarlang, desc)
	else
		return str
	end
end

local punch_queue = {}

core.register_on_punchnode(function(pos, node, puncher)
	local pname = puncher and puncher:get_player_name()
	if not punch_queue[pname] then
		return
	end
	if not core.registered_nodes[node.name] then
		return
	end
	local tarlang = punch_queue[pname]
	punch_queue[pname] = nil
	core.chat_send_player(pname, translate_item_description(node.name, tarlang))
end)

core.register_chatcommand("wnlex", {
	params = "<target language> [<item>]",
	description = S "Look up the name of an item",
	func = function(name, param)
		local lang, item = param:match("(%S+)%s+(.+)")
		if not (lang and item) then
			lang = param:trim()
			if lang == "" then
				return false, S "Invalid usage."
			end
		end
		local tarlang = lang

		if not item then
			punch_queue[name] = tarlang
			return true, S "Punch a node to view its translated description."
		elseif core.registered_items[item] then
			return true, translate_item_description(item, tarlang)
		end

		return false, S("Unable to find item: @1", item)
	end,
})
