local storage = minetest.get_mod_storage()

-- track playtime
minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
        local player_name = player:get_player_name()
        local pt = tonumber(storage:get_string(player_name .. "---playtime"))

        if pt == nil then pt = 0 end

        new_pt = pt + dtime
        storage:set_string(player_name .. "---playtime", tostring(new_pt))

        local old_hours = math.floor(pt / 3600)
        local new_hours = math.floor(new_pt / 3600)
        if new_hours > old_hours then
            local formatted_playtime = format_playtime(new_pt)
            minetest.chat_send_all(player_name .. " has now played for " .. formatted_playtime .. ".")
        end
    end
end)
function format_playtime(seconds)
    local days = math.floor(seconds / (24 * 3600))
    local hours = math.floor(seconds / 3600) % 24
    local minutes = math.floor(seconds / 60) % 60
    local remaining_seconds = seconds % 60

    local formatted_time = ""
    if days > 0 then
        formatted_time = string.format("%02d:%02d:%02d:%02d", days, hours, minutes, remaining_seconds)
    else
        formatted_time = string.format("%02d:%02d:%02d", hours, minutes, remaining_seconds)
    end

    return formatted_time
end
function getformattedplaytime(name)
    return format_playtime(storage:get_int(name .. "---playtime"))
end

minetest.register_chatcommand("playtime", {
    description = "Check your playtime or the playtime of a specified player.",
    privs = {},
    params = "[<playername>]",
    func = function(name, param)
        local target_name = param
        if target_name == "" then
            target_name = name
        end
        local playtime = storage:get_int(target_name .. "---playtime")
        if playtime == 0 then
            return true, target_name .. " has no recorded playtime."
        else
            local formatted_playtime = getformattedplaytime(target_name)

            if target_name == name then
                return true, "Your playtime is " .. formatted_playtime .. "."
            else
                return true, target_name .. "'s playtime is " .. formatted_playtime .. "."
            end
        end
    end,
})